/*
 * Created on Apr 18, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.gui;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.dkaedv.asteroids.data.GameStatus;

public class DisplayUpdaterThread extends Thread {
    private Log log = LogFactory.getLog(DisplayUpdaterThread.class);

    private MainFrame mainFrame;
    private GameStatus gameStatus;

    @Override
    public void run() {
        while (true) {
            //log.debug("Repainting MainFrame");

            try {
                mainFrame.repaint();
            } catch (NullPointerException e) {
                // Happens if the ship disappears in the middle of an update
                log.debug("NullPointerException catched while repainting");
            }

            try {
                gameStatus.waitForUpdate();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Injected spring beans.
     */

    /**
     * @param mainFrame the mainFrame to set
     */
    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    /**
     * @param gameStatus the gameStatus to set
     */
    public void setGameStatus(GameStatus gameStatus) {
        this.gameStatus = gameStatus;
    }


}
