/*
 * Created on Apr 15, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.ki;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.dkaedv.asteroids.data.GameStatus;
import com.dkaedv.asteroids.net.ConnectionStatus;
import com.dkaedv.asteroids.net.KeysDatagram;

public class DummyController implements Runnable {
    Log log = LogFactory.getLog(DummyController.class);

    protected TargetList targetList;
    protected GameStatus gameStatus;
    protected KeysDatagram keysDatagram;
    protected ConnectionStatus connectionStatus;

    private Boolean leftOrRight = false;

    public void run() {
        while(true) {
            keysDatagram.fire(1);

            if (leftOrRight) {
                keysDatagram.left(1);
                leftOrRight = false;
            } else {
                keysDatagram.right(1);
                leftOrRight = true;
            }

            try {
                gameStatus.waitForUpdate();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }


    /*
     * Injected Spring beans.
     */

    /**
     * @param targetList the targetList to set
     */
    public void setTargetList(TargetList targetList) {
        this.targetList = targetList;
    }


    /**
     * @param gameStatus the gameStatus to set
     */
    public void setGameStatus(GameStatus gameStatus) {
        this.gameStatus = gameStatus;
    }


    /**
     * @param keysDatagram the keysDatagram to set
     */
    public void setKeysDatagram(KeysDatagram keysDatagram) {
        this.keysDatagram = keysDatagram;
    }


    /**
     * @param connectionStatus the connectionStatus to set
     */
    public void setConnectionStatus(ConnectionStatus connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

}
