/*
 * Created on Apr 18, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.ki;

import java.util.Collections;
import java.util.List;
import java.util.Vector;

import com.dkaedv.asteroids.data.IPositionable;
import com.dkaedv.asteroids.util.DistanceComparator;

public class NearestFirstStrategy extends BaseStrategy {

    @Override
    public void run() {
        while (true) {
            if (gameStatus.getShip() != null) {
                List<IPositionable> targetCandidates = new Vector<IPositionable>();
                targetCandidates.addAll(gameStatus.getAsteroids());

                if (gameStatus.getUfo() != null)
                    targetCandidates.add(gameStatus.getUfo());

                Collections.sort(targetCandidates, new DistanceComparator(gameStatus.getShip()));

                synchronized (targetList) {
                    targetList.getTargets().clear();
                    targetList.getTargets().addAll(targetCandidates);
                }
            }

            try {
                gameStatus.waitForUpdate();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}
