/*
 * Created on Jun 16, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.ki.rater;

import com.dkaedv.asteroids.data.Asteroid;
import com.dkaedv.asteroids.data.GameStatus;
import com.dkaedv.asteroids.data.IPositionable;
import com.dkaedv.asteroids.data.RatedTarget;
import com.dkaedv.asteroids.data.Ufo;
import com.dkaedv.asteroids.ki.TargetList;

public class ScoreRater extends BaseTargetRater {

    private final static double MAX_SCORE = 1000;

    private final static double SCORE_ASTEROID_BIG = 20;

    private final static double SCORE_ASTEROID_MEDIUM = 50;

    private final static double SCORE_ASTEROID_SMALL = 100;

    private final static double SCORE_UFO_SMALL = 1000;

    private final static double SCORE_UFO_BIG = 200;

    @Override
    public void rateTarget(GameStatus gameStatus, TargetList targetList,
            RatedTarget target) {

        IPositionable innerTarget = target.getTarget();
        double score = 0;

        if (innerTarget instanceof Asteroid) {
            Asteroid asteroid = (Asteroid) innerTarget;
            switch (asteroid.getRadius() / 4) {
            case Asteroid.NORMAL_SCALE:
                score = SCORE_ASTEROID_BIG;
                break;
            case Asteroid.NORMAL_SCALE / 2:
                score = SCORE_ASTEROID_MEDIUM;
                break;
            case Asteroid.NORMAL_SCALE / 4:
                score = SCORE_ASTEROID_SMALL;
                break;
            }

        } else if (innerTarget instanceof Ufo) {
            Ufo ufo = (Ufo) innerTarget;
            switch (ufo.getRadius()) {
            case 15:
                score = SCORE_UFO_BIG;
                break;
            case 8:
                score = SCORE_UFO_SMALL;
                break;
            }

        }

        int rating = (int) ((score / MAX_SCORE) * 100);
        rateIt(target, rating);
    }

}
