/*
 * Created on Apr 16, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.data;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class Ufo implements IPositionable, IDrawable {
    private Position position;
    private int scaleFactor = 0;

    // Drawing Support
    // taken from Rammi (rammi@caff.de)
    /** Shape used for big ufo. */
    private static final GeneralPath BIG = new GeneralPath();
    /** Shape used for small ufo. */
    private static final GeneralPath SMALL;
    static {
      int w = 24;
      int h = 8;
      BIG.moveTo(-w,  0);
      BIG.lineTo( w,  0);
      BIG.lineTo( w/2, -h);
      BIG.lineTo(-w/2, -h);
      BIG.lineTo(-w,  0);
      BIG.lineTo(-w/2, h);
      BIG.lineTo( w/2, h);
      BIG.lineTo( w,  0);
      BIG.moveTo( -h, h);
      BIG.lineTo( -2*h/3, 2*h);
      BIG.lineTo(  2*h/3, 2*h);
      BIG.lineTo(  h, h);

      SMALL = new GeneralPath(BIG);
      SMALL.transform(AffineTransform.getScaleInstance(0.5, 0.5));
    }


    public Ufo(int curX, int curY, int scaleFactor) {
        position = new Position(curX, curY);
        this.scaleFactor = scaleFactor;
    }

    public Position getPosition() {
        return position;
    }

    public int getRadius() {
        return (scaleFactor == 15) ? 15 : 8;
    }

    public void draw(Graphics2D g, Graphics2D textG) {
        g.setColor(Color.white);
        g.draw(AffineTransform.getTranslateInstance(position.getCurVector().x, position.getCurVector().y).createTransformedShape((scaleFactor == 15) ? BIG : SMALL));

        getPosition().draw(g, textG);
    }
}
