/*
 * Created on Apr 18, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.ki;

import com.dkaedv.asteroids.data.IDrawable;
import com.dkaedv.asteroids.data.IPositionable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import java.util.Vector;

public class TargetList implements IDrawable {
    private List<IPositionable> targets = new Vector<IPositionable>();

    private final static int CIRCLE_SIZE = 50;

    /**
     * @return the targets
     */
    public List<IPositionable> getTargets() {
        return targets;
    }

    public void addTarget(IPositionable target) {
        targets.add(target);
    }

    public synchronized IPositionable getFirstTarget() {
        if (targets.size() > 0) {
            return targets.get(0);
        }

        return null;
    }

    public void draw(Graphics2D g, Graphics2D textG) {
        IPositionable target = getFirstTarget();

        if (target != null) {
            g.setColor(Color.RED);
            g.drawOval(target.getPosition().getCurVector().x - (CIRCLE_SIZE / 2), target.getPosition().getCurVector().y - (CIRCLE_SIZE / 2), CIRCLE_SIZE, CIRCLE_SIZE);


        }

    }
}
