/*
 * Created on Jun 15, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.ki.rater;

import com.dkaedv.asteroids.data.GameStatus;
import com.dkaedv.asteroids.data.RatedTarget;
import com.dkaedv.asteroids.ki.TargetList;
import com.dkaedv.asteroids.util.VectorCalculations;

public class DirectionRater extends BaseTargetRater {

    @Override
    public void rateTarget(GameStatus gameStatus, TargetList targetList,
            RatedTarget target) {

        double oldDistance = VectorCalculations.getDistance(target.getTarget().getPosition().getLastVector(), gameStatus.getShip().getPosition().getCurVector());
        double newDistance = VectorCalculations.getDistance(target.getTarget(), gameStatus.getShip());

        if (newDistance < oldDistance) {
            // Moving towards me
            rateIt(target, 100);
        }

    }

}
