/*
 * Created on Apr 17, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.net;

import java.util.HashMap;
import java.util.Map;

public class ConnectionStatus {
    /**
     * Dropped frames.
     */
    private long droppedFrames = 0;

    /**
     * Maps the package serial to the sent timestamps for latency calculation.
     */
    private Map<Integer, Long> sentTimestamps = new HashMap<Integer, Long>();

    /**
     * Latency in ms.
     */
    private long latency = 0;

    public synchronized void addSentTimestamp(int serial, long time) {
        sentTimestamps.put(serial, time);
    }

    public synchronized void calculateLatency(int serial, long receiveTime) {
        if (sentTimestamps.get(serial) != null)
            this.latency = receiveTime - sentTimestamps.get(serial);
    }

    public long getLatency() {
        return latency;
    }
}
