// player.cpp: Beispielspieler fr Asteroids
// Harald Bgeholz / c't

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <math.h>


#if defined (WINDOWS)
#include <winsock2.h>
#else
// 2 Includes fr socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes fr inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes fr fcntl()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1
#define WSAGetLastError() errno
#endif

#define PROJSPEED 8
#define MID 0
#define LEFT -1
#define RIGHT 1

#include "player.h"

void Player::Run(void)
{
	FramePacket frame;
	KeysPacket keys;
	GameStatus game;
	game.ship_rot=0;
	GameStatus prevgstat;
	char prevframe = 0;
	int t = 0;
	bool salve=false;
	bool search_target=true;
	bool fire=false;
	Asteroid targets[MAX_ASTEROIDS];
	Asteroid prev_targets[MAX_ASTEROIDS];


	for (;;)
	{
#ifdef DEBUG
		printf("--- frame %i ---\n",t);
#endif
		++t;         // Zeit
		++keys.ping; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
		SendPacket(keys);
		ReceivePacket(frame);

		bool frame_error=false;
		if (frame.frameno != ++prevframe || frame.ping != keys.ping)
		{
			printf("Latenz %d. %d Frames verloren.\n", keys.ping - frame.ping, frame.frameno - prevframe);
			prevframe = frame.frameno;
			frame_error=true;
		}

		static const int shiprot[88][2]=
		{
			{1536,0}, {1536,0}, {1536,0}, {1528,-152}, {1504,-296}, {1472,-440}, {1472,-440}, {1416,-584}, {1360,-720}, {1280,-856},
			{1280,-856}, {1192,-976}, {1088,-1088}, {976,-1192}, {976,-1192}, {856,-1280}, {720,-1360}, {584,-1416}, {584,-1416},
			{440,-1472}, {296,-1504}, {152,-1528}, {152,-1528}, {-152,-1528}, {-296,-1504}, {-296,-1504}, {-440,-1472}, {-584,-1416},
			{-720,-1360}, {-720,-1360}, {-856,-1280}, {-976,-1192}, {-1088,-1088}, {-1088,-1088}, {-1192,-976}, {-1280,-856}, {-1360,-720},
			{-1360,-720}, {-1416,-584}, {-1472,-440}, {-1504,-296}, {-1504,-296}, {-1528,-152}, {-1536,0}, {-1536,0}, {-1528,152},
			{-1528,152}, {-1504,296}, {-1472,440}, {-1416,584}, {-1416,584}, {-1360,720}, {-1280,856}, {-1192,976}, {-1192,976}, {-1088,1088},
			{-976,1192}, {-856,1280}, {-856,1280}, {-720,1360}, {-584,1416}, {-440,1472}, {-440,1472}, {-296,1504}, {-152,1528}, {0,1536},
			{152,1528}, {296,1504}, {440,1472}, {440,1472}, {584,1416}, {720,1360}, {856,1280}, {856,1280}, {976,1192}, {1088,1088},
			{1192,976}, {1192,976}, {1280,856}, {1360,720}, {1416,584}, {1416,584}, {1472,440}, {1504,296}, {1528,152}, {1528,152}, {1536,0}, {1536,0}
		};
//		if(t==1)printf("size of shiprot %i\n", sizeof(shiprot)/sizeof(int));
		int aim_dx;
		int aim_dy;
		int target;
		int aim;
		int last_target;
		int last_aim;
		if(t!=1){
			prevgstat=game; // wenn vorhanden, letzten spielstatus sichern
			last_target=target;
			last_aim=aim;
			for(int i=0;i<MAX_ASTEROIDS;i++){prev_targets[i]=targets[i];}
		}
		InterpretScreen(frame, game);

		if(game.nshots<game.fired_cnt) game.fired_cnt=game.nshots; // wenn weniger schsse im frame als gezhlt, reduzieren.
		bool hyper;
		if(game.ship_present==false)hyper=false;
		keys.clear();   // alle Tasten loslassen
//		if(hyper==true) keys.hyperspace(true);
//		printf ("prev_x: %x    ", prevgstat.asteroids[0].x);
//		printf ("this_x: %x\n", game.asteroids[0].x);
		
		int min_dist_saucer = 0x7fffffff;
		int min_dist_aster = 0x7fffffff;
//		int min_offset=0x7fffffff;
//		int offset=0x7fffffff;
		double prio_hs_time=0x7fffffff;
		double min_hit_off=0x7fffffff;
		int min_dx = 0;
		int min_dy = 0;
		int aim_cnt;
		enum FIRE_PRIO {NONE, ASTER, SAUCER} fire_prio;   // if 0 prio array start at 1
		int i;
		bool new_target;
		double speed_x;
		double speed_y;
		int speed_s_x;
		int speed_s_y;
		double speed_s_sumx;
		double speed_s_sumy;
		int dist_aster;
		int target_flp;
		int target_close;
		bool new_calc;
		int close_size;
		int calc_cnt;
		int aim_offset;
		int shiprot_pnt;
		int min_rot=0;
		double real_dist;
		
//		if(frame_error) calc_cnt=0;
		if(t==2 || calc_cnt==0) new_calc=true;
		if(aim==MID && salve==false) new_target=true;
		else new_target=new_calc=false;
		if(game.nshots>0){
			for(i=0;i<game.nshots;i++){
#ifdef DEBUG
				printf("shot dx: %i dy: %i ",game.shots[i].dx,game.shots[i].dy);
#endif
			}
#ifdef DEBUG
			printf("\n");
#endif
		}
		if(game.nhits > 0){
#ifdef DEBUG
			printf("hit: target %i * %i %i\n", target, game.hits[game.nhits].x, game.hits[game.nhits].y);
#endif
			for (i=0; i<prevgstat.nasteroids; ++i){
//				if (prevgstat.asteroids[i].x == game.hits[game.nhits].x 
//					&& prevgstat.asteroids[i].y == game.hits[game.nhits].y)
//					printf("asteroid #: %i\n",i);
			}
			game.nhits--;
			if(game.fired_cnt > 0)game.fired_cnt--;
			new_calc=true;
			calc_cnt=0;
		}
		if(new_calc==true){
			search_target=true;
			new_target=true;
//			aim_cnt=0;
			last_target=0;
			aim=MID;
			fire_prio=NONE;
		}
		calc_cnt++;
		target=target_flp=0;
		targets[0].dx=0;
		targets[0].dy=0;
		aim_dx=aim_dy=0;
//		fire_prio=NONE;
#ifdef DEBUG
		printf("new_calc: %i ## search_target: %i ## aim: %i ## salve %i ### new_target %i\n",new_calc, search_target, aim, salve, new_target);
#endif
//		printf("  ##  fired_cnt: %i\n",game.fired_cnt);
		int shp_cnt;
		if (game.ship_present)
		{
			shp_cnt++;
		//	if(shp_cnt<=2) fire=true;
			for(i=0; i<88; i++){
				if(game.ship_dx==shiprot[i][0] && game.ship_dy==shiprot[i][1]){
					// printf("found rotation position\n");
					shiprot_pnt=i;
					break;
				}
			}
			if(i==87) printf("didnt find rotation position\n");
			if(game.nshots>0){
				for(i=0;i<game.nshots;++i){
					game.shots[i].num=i;
					int dx = game.shots[i].x - game.ship_x;
					while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
					while (dx > 511) dx -= 1024;
					game.shots[i].dx=dx;
					int dy = game.shots[i].y - game.ship_y;
					while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
					while (dy > 383) dy -= 768;
					game.shots[i].dy=dy;
					int dist_shot=dx*dx+dy*dy;
					game.shots[i].dist=dist_shot;
//					if(game.saucer_present==true)printf("shot: %i dx: %i dy %i x: %i y: %i s_x: %i s_y: %i\n", i, dx, dy, game.shots[i].x, game.shots[i].y, game.saucer_x, game.saucer_y);
					if((game.saucer_present==true || prevgstat.saucer_present==true) && dist_shot<2000){
//						printf("!!! shot alert , shots: %i * dist %i prevdist %i\n",game.nshots, dist_shot,prevgstat.shots[i].dist);
//						if(prevgstat.shots[i].dist!=0 && dist_shot<prevgstat.shots[i].dist){
						if(prevgstat.shots[i].dist!=0 && abs(dx)<=abs(prevgstat.shots[i].dx) && abs(dy)<=abs(prevgstat.shots[i].dy) && (abs(prevgstat.shots[i].dist)-abs(dist_shot)<2000)){
//							keys.hyperspace(true);
							hyper=true;
							printf("shot hyperspace\n");
//							search_target=false;
//							new_target=false;
//							aim_cnt=0;
//							last_target=0;
//							aim=MID;
//							new_calc=true;
						}
					}
				}
			}else { // if no shot present
				for(i=0;i<MAX_SHOTS;i++){
					prevgstat.shots[i].dist=0;
				}
			}
			int astrad;  // radius des asteroiden
			if(fire_prio==NONE)new_target=true;
			for (i=0; i<game.nasteroids; ++i){   // nchsten Asteroiden berechnen
				// wenn schuss auf asteroiden bereits abgegeben weiterhin als beschossen markieren
				if(prevgstat.asteroids[i].shot==true && fire_prio==NONE && new_calc==false && game.nshots > 0) game.asteroids[i].shot=true;
				else game.asteroids[i].shot=false;
				if(prevgstat.asteroids[i].aimed==true && fire_prio==NONE && new_calc==false && game.nshots > 0) game.asteroids[i].aimed=true;
				else game.asteroids[i].aimed=false;

				game.asteroids[i].astno=i;
				switch (game.asteroids[i].sf)
				{	// Abstand um den ungefhren Radius des Asteroiden korrigieren
					case 0:  // groer Asteroid
						 astrad=40;
						break;
					case 15: // mittlerer Asteroid
						astrad=20;
						break;
					case 14: // kleiner Asteroid
						astrad=8;
//						astrad=10;
						break;
				}
				int dx = game.asteroids[i].x - game.ship_x;
				while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
				while (dx > 511) dx -= 1024;
				game.asteroids[i].dx=dx;
				int dy = game.asteroids[i].y - game.ship_y;
				while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
				while (dy > 383) dy -= 768;
				game.asteroids[i].dy=dy;
				dist_aster = dx*dx+dy*dy;
				real_dist=sqrt(dist_aster);
				game.asteroids[i].real_dist=real_dist;
				dist_aster -= astrad*astrad;
				if (dist_aster < min_dist_aster)
				{
					close_size=astrad+astrad;
					min_dist_aster = dist_aster;              // nchster asteroid zum schiff
					if(game.asteroids[i].shot==false && game.asteroids[i].aimed==false){
						min_dx = dx;
						min_dy = dy;
						target_close=i;
						target++;
						targets[target]=game.asteroids[i];

					}//else printf("already aimed\n");
//					printf("min_dist_aster %i\n",min_dist_aster);
				}
//				printf("min_dx %i * min_dy %i\n",min_dx, min_dy);
				if(t!=1 && calc_cnt>1){
					// geschwindigkeit des asteroiden, korrektur bei bertretung des Bilsch.randes
					speed_x=game.asteroids[i].x - prevgstat.asteroids[i].x;
					speed_y=game.asteroids[i].y - prevgstat.asteroids[i].y;
			//		if(i==0)printf("precalc target %i -- speed-x %f -- speed-y %f\n",i ,speed_x, speed_y);
					
					if(fabs(speed_x)>5) speed_x=-1*fmod(1024,speed_x); 
					if(fabs(speed_y)>5) speed_y=-1*fmod(768,speed_y);
	#ifdef DEBUG
					printf("speed_x %i , speed_y %i\n",speed_x, speed_y );
	#endif
					double pspeed_x=speed_x, pspeed_y=speed_y;
					speed_x=((prevgstat.asteroids[i].speed_x*(calc_cnt-1) + speed_x)/calc_cnt);
					speed_y=((prevgstat.asteroids[i].speed_y*(calc_cnt-1) + speed_y)/calc_cnt);
					if(fabs(fabs(pspeed_x)-fabs(speed_x))>1.5){
				//		printf("asteroid %i :: pspeed_x %f -- speed-x %f\n",i, pspeed_x, speed_x);
						speed_x=pspeed_x;
					}
					if(fabs(fabs(pspeed_y)-fabs(speed_y))>1.5){
				//		printf("asteroid %i :: pspeed_y %f -- speed-y %f\n",i, pspeed_y, speed_y);
						speed_y=pspeed_y;
					}
					game.asteroids[i].speed_x=speed_x;
					game.asteroids[i].speed_y=speed_y;
						if(t!=1 && calc_cnt > 1){
	#ifdef DEBUG
							printf("calculate_targets\n");
	#endif
							int speed_x_int=(int)round(speed_x);
							int speed_y_int=(int)round(speed_y);
							if(fabs(speed_x)>6 || fabs(speed_y>6)){
	//#ifdef DEBUG
								printf("speed unreasonable: speed_x_int %i * speed_y_int %i\n",speed_x_int, speed_y_int);
								printf("last: x %i * y %i * now: x %i * y %i\n",prevgstat.asteroids[i].x, prevgstat.asteroids[i].y, game.asteroids[i].x, game.asteroids[i].y);
								printf("last speed: x %f * y %f\n",prevgstat.asteroids[i].speed_x, prevgstat.asteroids[i].speed_y);
	//#endif
	//							if(prevgstat.asteroids[i].speed_x < 1000 && (prevgstat.asteroids[i].speed_y <1000)
								game.asteroids[i].speed_x=game.asteroids[i].speed_y=0;
								speed_x=speed_y=0;
								search_target=false;
								aim=MID;
								if (calc_cnt>0)calc_cnt--;
							}
							
							// Astereoid mit der nhesten Flugbahn richtung Schiff
							if (speed_x != 0 || speed_y != 0 && calc_cnt>1){ // wenn vorheriger gamestatus vorhanden
								double hs_time, hit_time_x, hit_time_y, hit_offset;
								double dx_adj, dy_adj;
//								printf("dx %i -- astrad %i\n", dx,astrad);
								if (abs(dx)-astrad<0)dx_adj=0.1; 
								else if(dx<0) dx_adj=dx+astrad;
								else dx_adj=dx-astrad;
								if (abs(dy)-astrad<0)dy_adj=0.1;
								else if(dy<0) dy_adj=dy+astrad;
								else dy_adj=dy-astrad;
								if(speed_x!=0)hit_time_x=fabs(dx_adj/speed_x);
								else hit_time_x=0;
								if(speed_y!=0)hit_time_y=fabs(dy_adj/speed_y);
								else hit_time_y=0;
								if((hit_time_x != 0 && hit_time_x < hit_time_y) || hit_time_y ==0) hs_time=hit_time_x;
								else hs_time=hit_time_y;
								if(hs_time==0)printf("+++ hit_time 0 fault +++\n");
#ifdef DEBUG
								printf("hit x %i y %i\n",hs_time,hit_time_y);
#endif
								game.asteroids[i].hstime=hs_time;
								if(real_dist<600
										&& game.asteroids[i].shot==false 
										&& game.asteroids[i].aimed==false
										&& fire_prio==NONE){// ziel mit den wenigen shiff-drehbewegungen suchen
									
									double next_aim;
									int cnt, cnt1, relrot;
									for(cnt=1; cnt<44; cnt++){
										relrot=(cnt+shiprot_pnt)%87;
										next_aim=fabs((double)shiprot[relrot][0] * fabs((double)aim_dy+cnt*speed_y+hit_time_y) - (double)shiprot[relrot][1] * fabs((double)aim_dx+cnt*speed_x+hit_time_x));
										if(next_aim < 700) break;
									}
									if(game.asteroids[i].shot==false){
										target++;
										targets[target]=game.asteroids[i];
										min_rot=target;
						//				printf("minrot\n");
									}
									for(cnt1=1; cnt1<44; cnt1++){
										relrot=(cnt1+shiprot_pnt)%87;
										next_aim=fabs((double)shiprot[88-relrot][0] * fabs((double)aim_dy+cnt1*speed_y+hit_time_y) - (double)shiprot[88-relrot][1] * fabs((double)aim_dx+cnt1*speed_x+hit_time_x));
										if(next_aim < 700) break;
									}
									if(game.asteroids[i].shot==false){
										if (cnt< cnt1|| min_rot==0){
											target++;
											min_rot=target;
											targets[target]=game.asteroids[i];
					//						printf("minrot\n");
										}
									}
								}

//								if((abs(dx) >= (int)fabs(round(dx+speed_x)) && abs(dy) >= (int)fabs(round(dy+speed_y)))
								if((abs(dx) <= abs(prevgstat.asteroids[i].dx) && abs(dy) <= abs(prevgstat.asteroids[i].dy))
										&& (dx!=0 || dy!=0)
										&& (real_dist<300)){ // wenn flugrichtung des asteroiden zum shiff hin
	#ifdef DEBUG
									printf("hs_time: %f # dx_now: %i # dx_next %i # dy_now: %i # dy_next: %i # speed_x %f, speed_y %f # astrad %i\n",hs_time,  dx, dx+(int)round(speed_x), dy, dy+(int)round(speed_y), speed_x, speed_y, astrad);
	#endif

									if(hit_time_x<hit_time_y)hit_offset=hit_time_y/hit_time_x;
									else hit_offset=hit_time_x/hit_time_y;
								#ifdef DEBUG
									printf("min_hit_off: %f ### hs_time %f\n",hit_offset, hs_time);
								#endif
									if(hit_offset <= min_hit_off && hit_offset<sqrt(astrad)){
										game.asteroids[i].min_hit_time=hit_offset;
										if(game.asteroids[i].shot==false && game.asteroids[i].aimed==false){
											min_hit_off=hit_offset;
											target++;
											targets[target]=game.asteroids[i];
											target_flp=target;
										}
									}	
										
//									printf("astrad: %i\n",astrad_mult);
//										if (hit_offset<astrad+15 && game.asteroids[i].shot==false){
									if (hit_offset<sqrt(astrad)/2 && prevgstat.asteroids[i].hstime>hs_time && hit_offset>1){
//									if (hit_offset<(sqrt(astrad)/2)){
#ifdef DEBUG
									printf("min_hit_offset %f -- hs_time %f\n",hit_offset, hs_time);
#endif
										// estimate frame-time, when asteroid will hit ship 

										if (hs_time<astrad+50){
											targets[target].hstime=hs_time;
											
											new_target=true;
											search_target=true;
											targets[target].fprio=true;
											fire_prio=ASTER;

//											if(dx_mult+speed_x <= prio_dx && dy_mult+speed_y <= prio_dy){
											if( hs_time <= prio_hs_time){
												prio_hs_time=hs_time;
												game.asteroids[i].shot=false;
												targets[0]=game.asteroids[i];
//		#ifdef DEBUG
												printf("flight path alert !! target#: %i * hs_time: %f * dx_target: %i -- dx: %i , dy_target: %i -- dy: %i, speed_x %f, speed_y %f\n",target, hs_time, targets[0].dx, dx, targets[0].dy, dy, speed_x, speed_y);
//		#endif
												if(hs_time>0 && hs_time < 1){
													hyper=true;
													keys.fire(true);
												//	new_calc=true;
												//#ifdef DEBUG
															printf("!!! hit_time alert\n");
												//#endif
												}
											}
										}
									}
								}// else 	fire_prio=NONE;
							} else {    // wenn speed_x und speed_y ==0
								fire_prio=NONE;
								if(calc_cnt>0)calc_cnt--;
							}
						}
					}else{
						search_target=false;
						new_target=false;
					}
			}   // END iterate through existing asteroids
//******************************************************************************************
//******************************************************************************************
//******************************************************************************************
			
			while(target!=0 && fire_prio==NONE && game.asteroids[targets[target].astno].shot==true && new_target==true){   // wenn schuss auf asteroiden bereits abgegeben, nchstes ziel
#ifdef DEBUG
				printf("shot fired on asteroid %i \n",targets[target].astno);
#endif
				target--;
/*
 				else{
					search_target=false;
					new_target=false;
					aim_cnt=0;
					last_target=0;
					aim=MID;
					new_calc=true;
				}
*/
			}

/*			if(target==0 && fire_prio==NONE && last_target!=0) {
				target=1;
				targets[target]=game.asteroids[prev_targets[last_target].astno];
#ifdef DEBUG
				printf("using last target no. %i * dx: %i, dy: %i\n",prev_targets[last_target].astno, targets[target].dx, targets[target].dy);
#endif
			}
*/
			if(fire_prio==NONE && new_target==true){
#ifdef DEBUG
				printf("target_flp: %i\n", target_flp);
#endif
				if (target==0)target=target_flp;
				if (target==0) search_target=false;
/*
				if(target==0) {  // wenn keine Prio -Asteroid mit nchstgelegener Flugbahn zum Schiff oder nchster Asteroid zum Schiff
					target=1;
					targets[1]=game.asteroids[target_close];
#ifdef DEBUG
					printf("use close target: %i\n",target);
#endif
				}
*/
			}
		
			if (game.saucer_present){
#ifdef DEBUG
				printf("saucer present\n");
#endif
				new_target=true;
				search_target=true;
				fire_prio=SAUCER;
				int dx = game.saucer_x - game.ship_x;
				while (dx < -512) dx += 1024;
				while (dx > 511) dx -= 1024;
				int dy = game.saucer_y - game.ship_y;
				while (dy < -384) dy += 768;
				while (dy > 383) dy -= 768;
				int dist = dx*dx+dy*dy;
				switch (game.saucer_size)
				{	// Abstand um den ungefhren Radius des UFOs korrigieren
				case 15: // groes UFO
					dist -= 20*12;
					aim_offset=10000;
					break;
				case 14: // kleines UFO
					dist -= 10*6;
					aim_offset=5000;
					break;
				}
//				if (dist < min_dist)
//				{
					min_dist_saucer = dist;
					aim_dx = dx;
					aim_dy = dy;
//				}
				int sp_cnt;
				if(prevgstat.saucer_present){
					sp_cnt++;
					// geschwindigkeit des ufo*100, korrektur bei bertretung des Bilsch.randes
					if((abs(speed_s_x=game.saucer_x - prevgstat.saucer_x))>10) speed_x=-1*(1024%speed_s_x); 
					if((abs(speed_s_y=game.saucer_y - prevgstat.saucer_y))>10) speed_x=-1*(768%speed_s_y); 
					speed_s_sumx=(speed_s_sumx*(sp_cnt-1) + speed_s_x)/sp_cnt;
					speed_s_sumy=(speed_s_sumy*(sp_cnt-1) + speed_s_y)/sp_cnt;
				}else sp_cnt=0;
			}else {
				speed_s_sumx=0;
				speed_s_sumy=0;
			}

			if(fire_prio==ASTER && fire==false && (targets[0].dx!=0 || targets[0].dy!=0) ){
				aim_dx=targets[0].dx;
				aim_dy=targets[0].dy;
				target=0;
//#ifdef DEBUG
				printf("aim_prio: x: %i , y: %i\n",aim_dx, aim_dy);
//#endif
			}else{
#ifdef DEBUG
				printf("non aster prio target --- fire_prio: %i * new_target: %i * target: %i speed_x: %f * speed_y %f\n", fire_prio, new_target, target,targets[target].speed_x, targets[target].speed_y);
#endif
				if((last_target==0 || targets[last_target].shot==true) 
						&& new_target==true 
						&& fire_prio==NONE 
						&& target!=0 
						&& (targets[target].speed_x!=0 || targets[target].speed_y!=0)){
					double hit_time=0x7fffffff;
					for(i=1;i<=target;i++){
						if(targets[i].min_hit_time<hit_time){ //&& targets[i].min_hit_time < 15){
							hit_time=targets[i].min_hit_time;
							aim_dx=targets[i].dx;
							aim_dy=targets[i].dy;
							target=i;
						}
					}
					if(min_rot!=0){
						aim_dx=targets[min_rot].dx;
						aim_dy=targets[min_rot].dy;
						target=min_rot;
		//				printf("use min_rot\n");
					}
					search_target=true;
#ifdef DEBUG
					printf("use nonprio target: %i * aim_dx: %i * aim_dy: %i * speed_x: %f * speed_y: %f\n",target, aim_dx, aim_dy, targets[target].speed_x, targets[target].speed_y );
#endif
				} 
				else if(new_target==true && fire_prio==NONE && target==0) search_target=false;
				else if(last_target>0 && targets[last_target].shot==false && fire_prio==NONE){
					target=last_target;
					aim_dx=game.asteroids[targets[last_target].astno].dx;
					aim_dy=game.asteroids[targets[last_target].astno].dy;
				}
			}
			
			
#ifdef DEBUG
			//			printf("new min_dx: %i\n", min_dx);
#endif
			
			// aim_x, aim_y in Bez. auf shussdistanz anpassen
//			if((last_min_dy != 0 || last_min_dx != 0) && new_target==true){
			if(fire_prio!=SAUCER && targets[target].speed_x==0 && targets[target].speed_y==0 && calc_cnt>1){
				new_target=false;
				search_target=false;
				new_calc=true;
				aim=MID;
#ifdef DEBUG
				printf("setting new_target false\n");
#endif
			}
#ifdef DEBUG
				printf("fire_prio: %i * target: %i\n", fire_prio, target);
#endif
				// if target speed available do calulation
				if(targets[target].speed_x!=0 || targets[target].speed_y!=0){
					double real_dist;
//					if(game.saucer_present==false) real_dist=sqrt((double)(targets[target].dx*targets[target].dx+targets[target].dy*targets[target].dy));
					if(game.saucer_present==false) real_dist=targets[target].real_dist;
					else real_dist=sqrt((double)min_dist_saucer);
					double hit_time=real_dist/PROJSPEED;   // treffer nach 'hit_time' frames bei unbewegtem ziel
					double hit_x;
					double hit_y;
					if(game.saucer_present==false){
	#ifdef DEBUG
						printf("nosaucer: %i ## targetno. %i * asterno. %i * aim_dx: %i # aim_dy: %i ### speed_x %i # speed_y %i\n",game.saucer_present, target, targets[target].astno, aim_dx, aim_dy, targets[target].speed_x,targets[target].speed_y);
	#endif
						hit_x=targets[target].speed_x * hit_time + targets[target].x;		// zielposition asteroid inkl. shusszeit, ohne drehzeit
						hit_y=targets[target].speed_y * hit_time + targets[target].y;
					} else {
	#ifdef DEBUG
						printf("saucer: %i ## aim_dx: %i # aim_dy: %i ### speed_s_x %i # speed_s_y %i\n",game.saucer_present, aim_dx, aim_dy, speed_s_x, speed_s_y);
	#endif
						hit_x=speed_s_x * hit_time + game.saucer_x;		// zielposition saucer inkl. shusszeit, ohne drehzeit
						hit_y=speed_s_y * hit_time + game.saucer_y;
					}
	
					aim_dx = (int)round(hit_x - game.ship_x);
					while (aim_dx < -512) aim_dx += 1024; // dx normalisieren auf -512 ... 511
					while (aim_dx > 511) aim_dx -= 1024;
					aim_dy = (int)round(hit_y - game.ship_y);
					while (aim_dy < -384) aim_dy += 768;  // dy normalisieren auf -384 ... 383
					while (aim_dy > 383) aim_dy -= 768;
				}
				
				// wenn asteroid nher als hit-ship-time 2 -- ALARM!
//				if(fire_prio==ASTER && (targets[0].hstime>0 && targets[0].hstime<2)) {
//					keys.hyperspace(true);
//					hyper=true;
//					keys.fire(true);
//					new_calc=true;
//#ifdef DEBUG
//					printf("!!! hit_time alert\n");
//#endif
//				}
#ifdef DEBUG
				printf("min_dist_aster - %i - sqrt: %i hit_time %i\n", min_dist_aster, real_dist, hit_time);
#endif
#ifdef DEBUG
				printf("new_dx: %i ### new_dy %i\n", aim_dx, aim_dy );
#endif
				
#ifdef DEBUG
			printf("search_target: %i ## fire_prio: %i\n",search_target,fire_prio);
#endif
			if (search_target==true){
//				printf("target %i\n",target);
				salve=false;
				new_target=false;
				int aim_calc=(game.ship_dx * aim_dy - game.ship_dy * aim_dx); // wenn asteroid_dx/ship_dx==asteroid_dy/ship_dy, dann auf ziel ausgerichtet

#ifdef DEBUG
//				if(fire_prio==ASTER)printf("ship_dx %i # ship_dy %i # aim_dx %i # aim_dy %i # aim_calc: %i ## new_target %i\n",game.ship_dx, game.ship_dy, aim_dx, aim_dy, aim_calc, new_target);
				printf("ship_dx %i # ship_dy %i # aim_dx %i # aim_dy %i # aim_calc: %i ## new_target %i\n",game.ship_dx, game.ship_dy, aim_dx, aim_dy, aim_calc, new_target);
#endif
				//			if (game.ship_dx * aim_dy - game.ship_dy * aim_dx > 0)
				
				if(fire_prio!=SAUCER && (fire_prio==ASTER || target>0)){
					if(target>0)game.asteroids[targets[target].astno].aimed=true;
					switch(targets[target].sf){
					case 0:  // groer Asteroid
						 aim_offset=45000-(int)round(targets[target].real_dist)*7;
						break;
					case 15: // mittlerer Asteroid
						aim_offset=30000-(int)round(targets[target].real_dist)*6;
						break;
					case 14: // kleiner Asteroid
						aim_offset=25000-(int)round(targets[target].real_dist)*6;
						break;
					}
				} else aim_offset=25000-(int)round(targets[target].real_dist)*5;
				if(aim_offset<300){
					aim_offset=600;
					printf("aim_offset %i\n", aim_offset);
				}
				if (abs(aim_calc)<aim_offset) {
					bool adjust_aim=false;

 					for(int i=1; i<3;i++){
						double best_aim_r=abs(shiprot[(shiprot_pnt+i)%87][0] * (int)fabs(aim_dy+speed_y) - shiprot[(shiprot_pnt+i)%87][1] * (int)fabs(aim_dx+speed_x));
						double best_aim_l=abs(shiprot[(shiprot_pnt-i)%87][0] * (int)fabs(aim_dy+speed_y) - shiprot[(shiprot_pnt-i)%87][1] * (int)fabs(aim_dx+speed_x));
						if((best_aim_r < abs(aim_calc-aim_offset)) && targets[target].real_dist>500)adjust_aim=true;
						else if((best_aim_l < abs(aim_calc-aim_offset)) && targets[target].real_dist>500)adjust_aim=true;
					}
		

					if(adjust_aim==false){
//#ifdef DEBUG
						if(fire_prio==ASTER)printf("aim_good * frame_odd %i\n", t%2);
//#endif
//						new_target=true;
//						fire_prio=NONE;
						aim=MID;
						fire=true;
//						aim_dx=0;
//						aim_dy=0;
					}else printf("adjusting aim\n");
				}
				else {
					if (aim_calc > 0) 
					aim=LEFT;
					else if(aim_calc < 0) aim=RIGHT;
					else aim=MID;
					// ziel pro shiffsdrehung einen frame weiter
//					aim_dx+=targets[target].speed_x/100;
//					aim_dy+=targets[target].speed_y/100;
					new_target=false;
					if(abs(aim_calc)<5000 && calc_cnt > 1) aim_cnt++; // wenn ziel nicht optimal anvisierbar
					else aim_cnt=0;
					if(aim_cnt==6){
//#ifdef DEBUG
						printf("aimloop\n");
//#endif
						new_target=true;
						search_target=false;
						new_calc=true;
						fire_prio=NONE;
						aim=-2;
						salve=true;
						aim=MID;
						fire=true;
//						aim_dx=0;
//						aim_dy=0;
						aim_cnt=0;
//						calc_cnt=0;
					}
				}
			}else aim=MID;
#ifdef DEBUG
			printf("aim: %i\n", aim);
#endif
			if(aim<MID){
				keys.left(true);
#ifdef DEBUG
				printf("key_left\n");
#endif
			}
			if (aim>MID){
				keys.right(true);
#ifdef DEBUG
				printf("key_right\n");
#endif
			}	
#ifdef DEBUG
			printf("min_distaster: %i * ship_x: %i # ship_y %i # ship_dx %i # ship_dy %i\n\n",min_dist_aster, game.ship_x, game.ship_y, game.ship_dx, game.ship_dy);	
#endif
			if (close_size==16 && min_dist_aster < close_size*55) printf("+++ small aster close alert\n +++");
			if ((close_size==16 && min_dist_aster < close_size*55) 
					|| (min_dist_aster < close_size*30) 
					&& game.saucer_present==false){  // Flucht
				keys.clear();
				keys.fire(true);
//				keys.hyperspace(true);
				hyper=true;
//#ifdef DEBUG
				printf("!!! dist hyperspace\n");
//#endif
			}
			else if ((close_size==16 && min_dist_aster < close_size*65) 
					|| (min_dist_aster < close_size*40) 
					|| min_dist_saucer < 10000
					&& game.saucer_present==true){  // Flucht
				keys.clear();
				keys.fire(true);
//				keys.hyperspace(true);
				hyper=true;
				printf("!!! dist hyperspace saucer\n");
			}
			
//			if (min_dist > 400*400) // beschleunigen, wenn nichts in der Nhe
//				keys.thrust(true);
//			printf("asteroid #: %i -- shot_stat: %i\n",close_asteroid, game.asteroids[close_asteroid].shot);
			if(search_target==true && new_target==false && fire_prio==NONE){
				if(targets[target].sf!=14 && targets[target].hstime < 0){
//#ifdef DEBUG
					printf("do salve\n");
//#endif
					search_target=false;
					aim = -1;
					salve=true;
				}
			}
			else { 
				if(salve==true && aim!=1){
#ifdef DEBUG
					printf("salve\n");
#endif
					if(t % 2 == 0 && game.fired_cnt<3){
						fire=true;
						aim++;
						if(aim==0)aim++;
					}
				} else {
					search_target=true;
					salve=false;
				}
			}

			if(hyper==true) keys.hyperspace(true);
			if (t % 2 == 0){
				if((game.fired_cnt<3 && fire==true) || (fire==true && fire_prio>0) || (game.fired_cnt<2 && salve==true)){  // Feuerknopf drcken
#ifdef DEBUG
					printf("fire ## prio: %i * target: %i * target_x: %i * target_y: %i * aim_dx: %i * aim_dy: %i\n",fire_prio, target, targets[target].dx, targets[target].dy, aim_dx, aim_dy);
#endif
					fire_prio=NONE;
					keys.fire(true);
					aim_cnt=0;
					target=0;
					game.fired_cnt++;
					if(salve==false || (salve==true && aim==-1 && fire_prio==0)){
						game.asteroids[targets[target].astno].shot=true;
						targets[target].shot=true;
					}
					if(salve==false){
						aim=MID;
						search_target=true;
						new_target=true;
					}
					fire=false;
//					game.asteroids[close_asteroid].shot=true;
				}
			}else{
				if(fire==true)new_calc=new_target=false;
			}
			

		}else{    // if ship not present
			target=0;
			shp_cnt=0;
			new_calc=true;
#ifdef DEBUG
			printf("-------------------- no ship --------------\n");
#endif
			fire_prio=NONE;
			aim_dx=aim_dy=0;
			aim=MID;
			salve=0;
			aim_cnt=0;
			calc_cnt=0;
		}
	}
}

void Player::InterpretScreen(FramePacket &packet, GameStatus& game)
{
	unsigned short vector_ram[512];
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
	int shipdetect = 0;

	game.clear();

	/* Vektor-RAM in 16-Bit-Worte konvertieren. War in der ersten Version mal ein sportlicher
	Typecast: unsigned short *vector_ram = (unsigned short*)packet.vectorram;
	Das klappt aber nur auf Little-Endian-Systemen, daher besser portabel: */
	for (int i=0; i<512; ++i)
		vector_ram[i] = (unsigned char)packet.vectorram[2*i] | (unsigned char)packet.vectorram[2*i+1] << 8;

	if (vector_ram[0] != 0xe001 && vector_ram[0] != 0xe201)
		return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	int pc = 1;
	while (pc < 512)
	{
		int op = vector_ram[pc] >> 12;
		switch (op)
		{
		case 0xa: // LABS
			vy = vector_ram[pc] & 0x3ff;
			vx = vector_ram[pc+1] & 0x3ff;
			vs = vector_ram[pc+1] >> 12;
			break;
		case 0xb: // HALT
			return;
		case 0xc: // JSRL
			switch (vector_ram[pc] & 0xfff)
			{
			case 0x8f3:
				game.asteroids[game.nasteroids++].set(vx, vy, 1, vs);
				break;
			case 0x8ff:
				game.asteroids[game.nasteroids++].set(vx, vy, 2, vs);
				break;
			case 0x90d:
				game.asteroids[game.nasteroids++].set(vx, vy, 3, vs);
				break;
			case 0x91a:
				game.asteroids[game.nasteroids++].set(vx, vy, 4, vs);
				break;
			case 0x929:
				game.saucer_present = true;
				game.saucer_x = vx;
				game.saucer_y = vy;
				game.saucer_size = vs;
				break;
			case 0x8b5:
				if(vs==11) game.hits[++game.nhits].set(vx, vy);
				break;
			}  
			break;
		case 0xd: // RTSL
			return;
		case 0xe: // JMPL
			/*
			pc = vector_ram[pc] & 0xfff;
			break;
			*/
			return;
		case 0xf: // SVEC
			/*
			dy = vector_ram[pc] & 0x300;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = (vector_ram[pc] & 3) << 8;
			if ((vector_ram[pc] & 4) != 0)
				dx = -dx;
			sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			vz = (vector_ram[pc] & 0xf0) >> 4;
			*/
			break;
		default:
			// get vector y length
			dy = vector_ram[pc] & 0x3ff;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;

			// get vector x length
			dx = vector_ram[pc+1] & 0x3ff;
			if ((vector_ram[pc+1] & 0x400) != 0)
				dx = -dx;

			sf = op;
			vz = vector_ram[pc+1] >> 12;
			if (dx == 0 && dy == 0 && vz == 15)
				game.shots[game.nshots++].set(vx, vy);
			if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			{
//				printf("dy: %i -  dx: %i - ", dy, dx);
				switch (shipdetect)
				{
				case 0:				// vector seite rechts
					v1x = dx;		// VCTR x
					v1y = dy;		// VCTR y
					++shipdetect;
					break;
				case 1:				// vector seite links
					game.ship_present = true;
					game.ship_x = vx;	// LABS x
					game.ship_y = vy;	// LABS y
					game.ship_dx = v1x - dx;
					game.ship_dy = v1y - dy;
					//					++shipdetect;
					break;
				}
//				printf("ship_dy: %i - ship_dx: %i - ", game.ship_dy, game.ship_dx);
			}
			else if (shipdetect == 1)
				shipdetect = 0;

			break;
		}
		if (op <= 0xa)
			++pc;
		if (op != 0xe) // JMPL
			++pc;
	}   

}


void Asteroid::set(int x, int y, int type, int sf)
{
	this->x = x;
	this->y = y;
	this->type = type;
	this->sf = sf;
}

void Shot::set(int x, int y)
{
	this->x = x;
	this->y = y;
}

void Hit::set(int x, int y)
{
	this->x = x;
	this->y = y;
}

void GameStatus::clear(void)
{
	ship_present = false;
	saucer_present = false;
	nasteroids = 0;
	nshots = 0;
	nhits = 0;
}

KeysPacket::KeysPacket(void)
{
	signature[0] = 'c';
	signature[1] = 't';
	signature[2] = 'm';
	signature[3] = 'a';
	signature[4] = 'm';
	signature[5] = 'e';

	keys = '@';
	ping = 0;
}

void KeysPacket::clear(void)
{
	keys = '@';
}

void KeysPacket::hyperspace(bool b)
{
	if (b)
		keys |= KEY_HYPERSPACE;
	else
		keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
	if (b)
		keys |= KEY_FIRE;
	else
		keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
	if (b)
		keys |= KEY_THRUST;
	else
		keys &= ~KEY_THRUST;
}

void KeysPacket::left(bool b)
{
	if (b)
	{
		keys |= KEY_LEFT;
		right(false);
	}
	else
		keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
	if (b)
	{
		keys |= KEY_RIGHT;
		left(false);
	}
	else
		keys &= ~KEY_RIGHT;
}

void Player::ReceivePacket(FramePacket &packet)
{
//	sockaddr_in sender;
//	int sender_size = sizeof sender;
	fd_set readfds, writefds, exceptfds;

	do
	{
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		FD_SET(sd, &exceptfds);
		select(sd+1, &readfds, &writefds, &exceptfds, NULL);
		int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
		if (bytes_received != sizeof packet)
		{
			int err = WSAGetLastError();
			if(packet.vectorram[0]=='b' || packet.vectorram[0]=='g') fprintf(stderr, " server: %s\n", packet.vectorram);
			else fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
			exit(1);
		}
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		timeval zero;
		zero.tv_sec = zero.tv_usec = 0;
		select(sd+1, &readfds, &writefds, &exceptfds, &zero);
	} while(FD_ISSET(sd, &readfds));
}

void Player::SendPacket(KeysPacket &packet)
{
	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
	if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
	{
#if defined (WINDOWS)
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
#else
		if (errno != EAGAIN)
		{
			perror("Fehler bei sendto()");
			exit(1);
		}
#endif
	}
}
