/*****************************************************************************
*  ADBotPlayerV1                                                             *
*                                                                            *
*  Copyright (C) 2008 Andreas Dittrich                                       *
*                                                                            *
*  Author:  Andreas Dittrich                                                 *
*           Am Schimmelberg 29                                               *
*           67729 Sippersfeld (Germany)                                      *
*****************************************************************************/

#ifndef ADBOTPLAYERV1_H
#define ADBOTPLAYERV1_H

#define RELEASE_CONTEST

#ifndef RELEASE_CONTEST
	#define RECEIVE_CPU_RAM 
#endif






#define MAX_NUM_ASTEROIDS 27
#define MAX_NUM_SHOTS 16


#ifndef UINT8_T
	#define UINT8_T
	typedef unsigned char uint8_t;
#endif

#ifndef UINT16_T
	#define UINT16_T
	typedef unsigned short uint16_t;
#endif

#ifndef UINT32_T
	#define UNT32_T
	typedef unsigned int uint32_t;
#endif


#ifndef VECTOR_T
	#define VECTOR_T
	typedef struct {
		int x;
		int y;
	} vector_t;
#endif


typedef enum {
	KEY_NONE       = 0,
	KEY_HYPERSPACE = (1<<0),
	KEY_FIRE       = (1<<1),
	KEY_THRUST     = (1<<2),
	KEY_RIGHT      = (1<<3),
	KEY_LEFT       = (1<<4),
} key_flag_enum_t;


typedef enum {
	IS_TRACKED     = (1<<0),
	IS_ESTIMATED   = (1<<1),
	IS_INITIALIZED = (1<<2),
	IS_SAUCER      = (1<<20),
	IS_ASTEROID    = (1<<21),
	IS_SHIP        = (1<<22),
	IS_SHOT        = (1<<24),
	IS_SHIP_SHOT   = (1<<25),
} obj_flags_enum_t;


#define MOVING_OBJECT_VARS \
	vector_t r;			/*current position*/ \
	vector_t v;			/*current velocity*/ \
	vector_t rr[8];		/*last eight positions (from vector ram)*/ \
	vector_t r2; \
	int t0; \
	int t2; \
	uint32_t flags; \
	int state;			/*4 = big, 2 = medium, 1 = small*/ \
	int id; \
	int t1_min; \
	int t2_min;



#pragma pack( push, 1)

typedef struct {
	MOVING_OBJECT_VARS
} moving_object_t;

typedef struct {
	MOVING_OBJECT_VARS

	vector_t r_last;
	vector_t v_last;

	int shape;			// 0..3

	int width;

	int id_shot;

} asteroid_t;


typedef struct {
	MOVING_OBJECT_VARS

	int id_target;
	int angle_code;

} shot_t;


typedef struct {
	MOVING_OBJECT_VARS

	int id_shot;

} saucer_t;


typedef struct {
	MOVING_OBJECT_VARS

	vector_t v0;
	int angle_code;

	int is_init_angle;

	int num_shots_available;
	int is_gun_ready;
} ship_t;


typedef struct {
	uint16_t s;
	uint16_t reserved;
	uint16_t ss[8];

	struct {
		int shape;
		vector_t r;
		vector_t v;
	} asteroids_init[16];

} randgen_t;



#define KEYSLOG_SIZE_LOG2 3



typedef struct {
	uint32_t keys;

	uint32_t flags;
	int id_target;
	int id_shot;
	int t0; //the expected time the keys are received
	int t1;	//time shot is firstly visible
	int t2; //expected time target is hit, i.e. shot is not visible anymore
} KeysInfo_t;


typedef struct {

	ship_t ship;

	saucer_t saucer;

	int num_asteroids;
	asteroid_t asteroids[MAX_NUM_ASTEROIDS];
	int list_sync_lost;

	int num_shots;
	shot_t shots[MAX_NUM_SHOTS];

	randgen_t rgen;
	int n_rgen_resync;

	int time;
	int t0_ship;

	int t0_run;		//time of first frame received
	int t0_game;	//time of the first appeareance of the ship
	int t0_level;	//time at the asteroids appear

	uint32_t phi128_offset;
	int level;

	KeysInfo_t keysinfo_next;
	KeysInfo_t keysinfo_curr;
	KeysInfo_t keysinfo_last;

	KeysInfo_t keysLog[1<<KEYSLOG_SIZE_LOG2];

	int next_asteroid_id;
	uint32_t flags;

	int score;

	uint8_t L02F8;	//decreased by 6 for each saucer. start value is 0x92. if >0x80, only big saucer appears
	uint8_t L0053;	//high byte of score. If bigger than 0x30, only small saucer appears
	uint8_t reserved[2];

	//only for debugging
	#ifndef RELEASE_CONTEST

	asteroid_t asteroids_predicted[MAX_NUM_ASTEROIDS];

	vector_t r_destination;
	int is_save_jump;

	char dbgtext[8][40];
	int  dbgtext_linenumber;

	#endif

	//only for debugging
	#ifdef RECEIVE_CPU_RAM

	uint8_t ram[1024];
	
	#endif

} GameState_t;


#pragma pack( pop )






#endif  //ADBOTPLAYERV1_H