package haui.asteroid.control;

/**
 * Momentane Ansicht des Spielfeldes.
 * 
 * @author Harald Bögeholz / c't
 * @author Bernhard Haumacher
 */
public class GameStatus {
	static final int MAX_ASTEROIDS = 100;
	static final int MAX_SHOTS = 10;
	
	/**
	 * Zeigt an, dass das Schiff sichtbar ist.
	 */
	boolean shipPresent;

	/**
	 * X-Koordinate des Mittelpunkts des Schiffs
	 */
	int shipX;         

	/**
	 * Y-Koordinate des Mittelpunkts des Schiffs
	 */
	int shipY;
	
	/**
	 * X-Anteil der Blickrichtung des Schiffes.
	 */
	int shipDx;        

	/**
	 * Y-Anteil der Blickrichtung des Schiffes.
	 */
	int shipDy;
	
	/**
	 * Zeigt an, dass ein UFO sichtbar ist.
	 */
	boolean ufoPresent;

	/**
	 * X-Koordinate des Mittelpunkts des UFOs (falls {@link #ufoPresent}).
	 */
	int ufoX;       

	/**
	 * Y-Koordinate des Mittelpunkts des UFOs (falls {@link #ufoPresent}).
	 */
	int ufoY;

	/**
	 * Größe des UFOs auf dem Spielfeld: 15 = groß, 14 = klein
	 */
	int ufoSize;

	/**
	 * Anzahl Asteroiden in {@link #asteroids}
	 */
	int asteroidCount;
	
	/**
	 * Asteroiden auf dem Spielfeld. Nur Einträge 0 bis {@link #asteroidCount} -
	 * 1 sind gültig.
	 */
	Asteroid asteroids[] = new Asteroid[MAX_ASTEROIDS];
	
	/**
	 * Anzahl Schüsse in {@link #shotCount}.
	 */
	int shotCount;
	
	/**
	 * Schüsse auf dem Spielfeld. Nur Einträge an den Stellen 0 bis
	 * {@link #shotCount} - 1 sind gültig.
	 */
	Shot[] shots = new Shot[MAX_SHOTS];
	
	public GameStatus() {
		for (int n = 0; n < MAX_ASTEROIDS; n++) {
			asteroids[n] = new Asteroid();
		}
		for (int n = 0; n < MAX_SHOTS; n++) {
			shots[n] = new Shot();
		}
	}
	
	void clear() {
		shipPresent = false;
		ufoPresent = false;
		asteroidCount = 0;
		shotCount = 0;
	}
}
