package haui.asteroid.control;

/**
 * Strukturiertes Steuerpaket, das an den Emulator geschickt wird.
  * 
 * @author Harald Bögeholz / c't
 * @author Bernhard Haumacher
*/
public class KeysPacket {
	static final byte KEY_HYPERSPACE = 1;
	static final byte KEY_FIRE = 2;
	static final byte KEY_THRUST = 4;
	static final byte KEY_RIGHT = 8;
	static final byte KEY_LEFT = 0x10;

	byte signature[] = new byte[6];
	byte keys;
	
	/**
	 * Wird vom Server bei nächster Gelegenheit zurückgeschickt. Für Latenzmessung.
	 */
	byte ping;
	public static final int PACKET_SIZE = 8;     

	public KeysPacket() {
		signature[0] = 'c';
		signature[1] = 't';
		signature[2] = 'm';
		signature[3] = 'a';
		signature[4] = 'm';
		signature[5] = 'e';
		keys = '@';
		ping = 0;
	}

	/**
	 * alle Tasten loslassen
	 */
	void clear() {
		keys = '@';
	}

	/**
	 * Hyperspace drücken (true) oder loslassen (false)
	 */
	void hyperspace(boolean b) {
		if (b)
			keys |= KEY_HYPERSPACE;
		else
			keys &= ~KEY_HYPERSPACE;
	}

	/**
	 * Feuerknopf drücken (true) oder loslassen (false)
	 */
	void fire(boolean b) {
		if (b)
			keys |= KEY_FIRE;
		else
			keys &= ~KEY_FIRE;
	}

	/**
	 * Beschleunigen ...
	 */
	void thrust(boolean b) {
		if (b)
			keys |= KEY_THRUST;
		else
			keys &= ~KEY_THRUST;
	}
	
	/**
	 * rechts drehen ...
	 */
	void right(boolean b) {
		if (b)
		{
			keys |= KEY_RIGHT;
			left(false);
		}
		else
			keys &= ~KEY_RIGHT;
	}

	/**
	 * links drehen
	 */
	void left(boolean b) {
		if (b)
		{
			keys |= KEY_LEFT;
			right(false);
		}
		else
			keys &= ~KEY_LEFT;
	}
	
	/**
	 * Kopiert dieses das strukturierte Steuerpaket in den gegebenen flachen
	 * Datenpuffer.
	 */
	public int copyTo(byte[] buffer) {
		int pos = 0;
		
		System.arraycopy(signature, 0, buffer, pos, signature.length);
		pos += signature.length;
		
		buffer[pos++] = keys;
		buffer[pos++] = ping;
		
		return pos;
	}

}
