; LOESCH V2.0  c't 8/98  (V 1.0 in c't 2/92) // as
; lscht komplett CMOS-RAM von 10h bis 3Fh
; fr 27128 oder 27256-EPROM, ist zugegeben etwas gro
; wahlweise als System-BIOS oder VGA-BIOS
; mu bei 16-Bit auf zwei ROMs gesplittet werden
; Version 2 piept guildomig nach getaner Tat
; Binfile-Erstellung:
; Tasm loesch
; tlink loesch
; exe2bin loesch,loesch.bin

Epromsize EQU  8000h;   (oder 4000h, falls 27128)

xOUT      Macro adr,wert
          local @@L1
          mov dx,100;    IORecovery
@@L1:     dec dx
          jnz @@L1
          mov al,wert
          out adr,al
          endm


; Macros fr Piepserei

w_g   equ    3044
w_es  equ    3835

Delay     Macro n
          local @@L1
          mov cx,n
@@L1:     in  al,61h
          cmp al,ah
          jz @@L1
          mov ah,al
          dec cx
          jnz @@l1
          endm


Play      macro wert, dauer, wait
          local @@l1
          mov   bx,wert
          xout  42h,bl
          xout  42h,bh
          mov   dx,100
@@l1:     dec   dx
          jnz   @@l1
          in   al,61h
          or    al,3
          xout  61h,al
          delay dauer
          in    al,61h
          and   al,not 3
          xout  61h,al
          delay wait
          endm
;*****************************************************************

CSEG        SEGMENT
            ASSUME  CS:CSEG
            org 0               ; liegt bei F000:0 oder F800:0 oder C000:0
            db Epromsize dup (0FFh) ; vorteilhaft fr EPROMs

            org 0
Loesch:
            dw  0AA55h             ; Kennung falls via VGA-ROM
            db  Epromsize/ 512  ;
            JMP start

start:
            MOV CL,00h       ; radikal alles Lschen!!!
xloop:
            xOUT 70h,CL
            xout 71h,0
            INC  CL
            CMP  CL,7Fh
            JNZ xloop


@Piepsen:   ; kleine "Fertigmeldung", nicht unbedingt ntig
            xOUT 43h,56h          ; Timer 2, 8 bittig auf Rechteck
            xOUT 41h,18           ; Timer 2 auf 15,6  s
            xOUT 43h,0B6h         ; Timer 3, 16 bittig auf Rechteck
            xout  80h,0
            Play  w_g,10000,4000
            xout  80h,1
            Play  w_g,10000,4000
            xout  80h,2
            Play  w_g,10000,4000
            xout  80h,4
            Play  w_es,30000,34000
            mov  ax,cs
            cmp  ax,0A000h        ; als COM oder EXE aufgerufen?
            jc   @RET             ; ja dann RETurn
            jmp  @Piepsen         ; sonst Dauerschleife
@RET:       pop  bp
	    MOV  ax,04C00h
            INT  21h

; Abbruch   nur durch Reset / Ausschalten ....
;*********************************************
; oder einfach:
            HLT           ; es ist vollbracht

            org Epromsize-10h  ; Reset Entry an der obergrenze
reset:Jmp start
           DB 12 dup (0FFh)   ; auch leer
           DB 0E0h;           ; Prfsumme zu 0
ends
end loesch

