/*
 * pwdigit.c
 *
 * Jan Stohner, 05.04.1998
 */

#include <stdio.h>
#include <stdlib.h>

void get_password(unsigned int chk, char *digits)
{
  int i;
  unsigned int help;

  for(i=0; i<8; i++) digits[i] = '0';
  digits[8] = 0;

  help = chk;
  for(i=7; i>=0; i--) {
    digits[i] |= help & 3;
    help = help >> 2;
  }

  if(chk<48) digits[0] |= 4;
  if((chk>=48) && (chk<52)) digits[7]++;
  if((chk>=52) && (chk<256)) digits[7] |= 4;
  if((chk>=256) && (chk<1024)) digits[6] |= 4;
}

unsigned int get_cmos_pw(void)
{
  FILE *fd;
  unsigned char buf,a,b;

  fd = fopen("/dev/port", "w+b");
  if(fd==NULL) {
    printf("Kann /dev/port nicht oeffnen!\n");
    exit(1);
  }

  fseek(fd, (long) 0x70, SEEK_SET);
  buf = 28;
  fwrite(&buf, 1, 1, fd);
  fread(&a, 1, 1, fd);

  fseek(fd, (long) 0x70, SEEK_SET);
  buf = 29;
  fwrite(&buf, 1, 1, fd);
  fread(&b, 1, 1, fd);

  fclose(fd);

  return((unsigned int)a+256*(unsigned int)b);
}


int main(void)
{
  unsigned int chk;
  unsigned char pw[9];

  chk = get_cmos_pw();
  printf("CMOS-Checksumme: %d\n", chk);
  get_password(chk, pw);
  printf("Das Passwort ist '%s'\n", pw);

  return(0);
}

