/********************************/
/* CT-API Speicherkartentest    */
/* Kai-Uwe Mrkor, 2000          */
/* fr c't 08/00                */
/********************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "ctapi.h"

int main( void)
{
 unsigned char      sad, dad;       /* Quell- und Zieladresse */
 unsigned char      command[30];    /* Kommando-String */
 unsigned char      response[100];  /* Antwort-Speicher */
 unsigned short int cnr,            /* KartenTerminal-Nummer */
                    lenr,           /* Grenangabe Antwortpuffer */
                    lenc;           /* Grenangabe Kommando */
 char               ret;            /* Rckgabewert der Funktion */
 int                i;

 /*                              CLA   INS   P1    P2    LEN */
 unsigned char REQUEST_ICC[]=   {0x20, 0x12, 0x01, 0x00, 0};
 unsigned char UPDATE_BINARY[]= {0x00, 0xD0, 0x00, 0x00, 16,
                                 "Der Kai war hier"};
 unsigned char READ_BINARY[]=   {0x00, 0xB0, 0x00, 0x04, 12};

 /* Initialisierung */
 cnr=0;                 /* TerminalNummer=1 */
 ret=CT_init(cnr,2);    /* Verbindung mit COM2 herstellen */
 if (ret != OK)
 {
     printf("Kartenterminal konnte nicht initialisiert werden\n");
     exit(1);
 }


 /* Anforderung der Chipkarte */
 sad=2;                     /* Quelle = Host */
 dad=1;                     /* Ziel = Kartenterminal */
 lenc=sizeof(REQUEST_ICC);  /* Gre der APDU ermitteln */
 lenr=sizeof(response);     /* Puffergre der Antwort-APDU */
 memcpy(command, REQUEST_ICC, lenc);
 ret=CT_data(cnr, &dad, &sad, lenc, command, &lenr, response);
 if (ret != OK)
 {
     printf("CT_data() fehlgeschlagen!\n");
     exit(1);
 }

 if (response[0]==0x90 && response[1]==0x00)
 {
    /* Kartenspeicher auslesen*/
    sad=2;                      /* Quelle = Host */
    dad=0;                      /* Ziel = Chipkarte 1*/
    lenc=sizeof(READ_BINARY);   /* Gre der APDU ermitteln */
    lenr=sizeof(response);      /* Puffergre der Antwort-APDU */
    memcpy(command, READ_BINARY, lenc);
    ret=CT_data(cnr, &dad, &sad, lenc, command, &lenr, response);

    printf("Karteninhalt vor dem Beschreiben:\t");
    for (i=0; i<lenr-2; i++)
        printf("%c",response[i]);

    printf("\nSoll die Karte ueberschrieben werden? (j/n) ");
    scanf("%c", &ret);
    if (ret == 'j' || ret == 'J')
    {
        /* Karte beschreiben */
        sad=2;                      /* Quelle = Host */
        dad=0;                      /* Ziel = Chipkarte 1*/
        lenc=sizeof(UPDATE_BINARY); /* Gre der APDU ermitteln */
        lenr=sizeof(response);      /* Puffergre Antwort-APDU */
        memcpy(command, UPDATE_BINARY, lenc);
        ret=CT_data(cnr, &dad, &sad, lenc, command, &lenr, response);

        /* Kartenspeicher auslesen*/
        sad=2;                      /* Quelle = Host */
        dad=0;                      /* Ziel = Chipkarte 1*/
        lenc=sizeof(READ_BINARY);   /* Gre der APDU ermitteln */
        lenr=sizeof(response);      /* Puffergre Antwort-APDU */
        memcpy(command, READ_BINARY, lenc);
        ret=CT_data(cnr, &dad, &sad, lenc, command, &lenr, response);

        printf("\nKarteninhalt nach dem Beschreiben:\t");
        for (i=0; i<lenr-2; i++)
        printf("%c",response[i]);
    }
 }
 else
        printf("Keine Speicherkarte erkannt\n");

 /* Freigabe */
 ret=CT_close(cnr);
 return 0;
}
