//Titel:        Mail-Client
//Version:      0.99
//Copyright:    Copyright (c) 2000
//Autor:        Christoph Borowski, cb@ordix.de
//Firma:        ORDIX AG, www.ordix.de, Westernmauer 12-16, 33098 Paderborn
//Beschreibung: Beispielanwendung, die die JavaMail-API einsetzt.

package mail.view;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.awt.event.*;
import java.awt.*;
import java.io.*;

import mail.model.*;

/**
  * Die Klasse implementiert das Fenster zum Empfangen
  * und Lschen von e-Mails.
  */
public class ReceiveFrame extends JFrame
											implements ActionListener {
	JButton			receiveButton = new JButton("Empfangen");
	JButton			deleteButton = new JButton("Lschen");

	JTextArea			messageArea = new JTextArea();
	
	HeaderTable		headerTable;
	HeaderTableModel	headerTableModel;
	MailReceiver		mailReceiver;

	/**
	  * Konstruktor, der das Empfangsfenster erzeugt.
	  */
	public ReceiveFrame() {
		mailReceiver = new MailReceiver();
		JSplitPane splitPane = new JSplitPane(
														JSplitPane.VERTICAL_SPLIT,
														getTablePanel(), getMessagePanel());
		splitPane.setDividerLocation(0.5);

		getContentPane().add(splitPane, BorderLayout.CENTER);
		getContentPane().add(getButtonPanel(), BorderLayout.SOUTH);
		
		setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);

		setTitle("Mail empfangen");
		setSize(400, 300);
	}
	
	/**
	  * Liefert die JScrollPane zurck, die die Textflche fr
    * die Anzeige des Mailtextes enthlt.
	  */
	private JScrollPane getMessagePanel() {
		// Eigenschaften der Textflche festlegen
		messageArea.setLineWrap(true);
		messageArea.setWrapStyleWord(true);
		messageArea.setEditable(false);
		// Textflche einer JScrollPane hinzufgen
		JScrollPane scrollPane = new JScrollPane(messageArea);

		return scrollPane;
	}
	
	/**
	  * Liefert die JScrollPane zurck, die die Header-Tabelle
    * beinhaltet.
	  */
	private JScrollPane getTablePanel() {
		// Table-Model erzeugen
		headerTableModel = new HeaderTableModel(mailReceiver);
		// Tabelle erzeugen
		headerTable = new HeaderTable(headerTableModel);
		// Tabelle einer JScrollPane hinzufgen
		JScrollPane panel = new JScrollPane(headerTable);
		
		return panel;
	}
	
	/**
	  * Erzeugt das JPanel mit den zwei Buttons Empfangen
    * und Lschen.
	  */
	private JPanel getButtonPanel() {
		// JPanel erzeugen
		JPanel panel = new JPanel(new BorderLayout());
    JPanel panel1 = new JPanel();

    // Tastaturkrzel fr die Buttons setzen
    receiveButton.setMnemonic('E');
    deleteButton.setMnemonic('L');

		// Fenster als Listener bei den Button anmelden
		receiveButton.addActionListener(this);
		deleteButton.addActionListener(this);

		// Button zum JPanel hinzufgen
		panel1.add(receiveButton);
		panel1.add(deleteButton);

    panel.add(panel1, BorderLayout.CENTER);
    panel.add(new JLabel(new ImageIcon("logo.gif")), BorderLayout.EAST);

		return panel;
	}
	
	/**
	  * ActionListener-Methode zur Behandlung der ActionEvents
    * der beiden Buttons optionButton und exitButton.
	  */
	public void actionPerformed(ActionEvent ae) {
		if (ae.getSource() == receiveButton) {
			Thread worker = new Thread() {
				public void run() {
					mailReceiver.readMessages();
				}
			};
			worker.start();
		}
		if (ae.getSource() == deleteButton) {
			Thread worker = new Thread() {
				public void run() {
          // Mail auf dem Mailserver lschen
					mailReceiver.deleteMessage(headerTable.getSelectedRow());
					// Mailtextes aus der Anzeige lschen
					messageArea.setText(null);
				}
			};
			worker.start();
		}
	}

	/**
    * Die Klasse implementiert die Tabelle, in der die
    * Header-Eintrge der empfangenen E-Mails angezeigt werden.
	  */
	class HeaderTable extends JTable
                    implements ListSelectionListener {
		public HeaderTable(TableModel model) {
			super(model);
			setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		}

		public void valueChanged(ListSelectionEvent lse) {
			super.valueChanged(lse);

			if (getSelectedRow() != -1) {
				Thread worker = new Thread() {
					public void run() {
						messageArea.setText(
                mailReceiver.getMessageText(getSelectedRow()));
					}
				};
				worker.start();
			}
		}
	}
}
