//Titel:        Mail-Client
//Version:      0.99
//Copyright:    Copyright (c) 2000
//Autor:        Christoph Borowski, cb@ordix.de
//Firma:        ORDIX AG, www.ordix.de, Westernmauer 12-16, 33098 Paderborn
//Beschreibung: Beispielanwendung, die die JavaMail-API einsetzt.

package mail.model;

import java.io.*;
import java.net.InetAddress;
import java.util.*;
import javax.activation.*;
import javax.mail.*;
import javax.mail.internet.*;

/**
  * Die Klasse MailSender implementiert die Funktionalitt
  * zum Erstellen und Versenden von e-Mails.
  */
public class MailSender {
	private MimeMessage msg;
	private Multipart mp;
	private MimeBodyPart mbpMessageText;

	/**
	  * Konstruktor, der aufgrund der bergebenen Parameter
    * eine E-Mail erstellt.
	  */
	 public MailSender(	String from, String to, File attachment,
    		String subject, String messageText, String mailServer)
   {
   	Properties props = System.getProperties();
   	props.put("mail.smtp.host", mailServer);
   	// holt Referenz auf ein Session-Objekt
		Session session = Session.getDefaultInstance(props, null);

    session.setDebug(true);
		// erzeugt ein MimeMessage-Objekt
		msg = new MimeMessage(session);

		try {
			// Im folgenden werden die Absenderadresse, der direkte
			// Empfnger, das Absendedatum, der Betreff kodiert in
			// US-ASCII Zeichen und der Headereintrag "X-Mailer" gesetzt
			msg.setFrom(new InternetAddress(from));
			msg.setRecipients(Message.RecipientType.TO,
                        InternetAddress.parse(to, false));
			msg.setSentDate(new Date());
			msg.setSubject(
                MimeUtility.encodeText(subject,"iso-8859-1","Q"));
			msg.setHeader("X-Mailer", "JavaMail");

			if (attachment != null) {
				// erzeugt ein MimeMultipart-Objekt
				mp = new MimeMultipart();

				// erzeugt ein MimeBodyPart-Objekt, setzt in diesem den
				// Mailtext kodiert in US-ASCII Zeichen und fgt das
				// MimeBodyPart-Objekt dem MimeMultipart-Objekt hinzu
				mbpMessageText = new MimeBodyPart();
				mbpMessageText.setText(messageText, "iso-8859-1");
				mp.addBodyPart(mbpMessageText);

				// erzeugt ein MimeBodyPart-Objekt, setzt in diesem das
				// Attachment und fgt das MimeBodyPart-Objekt dem
        // MimeMultipart-Objekt hinzu
				MimeBodyPart mbpAttachment = new MimeBodyPart();
				FileDataSource fds = new FileDataSource(
                                      attachment.getAbsolutePath());
				mbpAttachment.setDataHandler(new DataHandler(fds));
				mbpAttachment.setFileName(
	    				MimeUtility.encodeText(
                            attachment.getName(),"iso-8859-1","Q"));
				mp.addBodyPart(mbpAttachment);

				// MimeMultipart wird dem MimeMessage-Objekt hinzugefgt.
				msg.setContent(mp);
			} else {
				// kein Anhang, Mailtext wird direkt der Mail hinzugefgt.
				msg.setText(messageText, "iso-8859-1");
			}
		} catch (java.io.UnsupportedEncodingException e) {
			System.out.println(
            "Fehler UnsupportedEncodingException in MailSender: " +
            e.getMessage());
			e.printStackTrace();
		} catch (MessagingException e) {
			System.out.println(
            "Fehler MessagingException in MailSender: " +
            e.getMessage());
			e.printStackTrace();
		}
	}

	/**
	  * Versendet die erstellte E-Mail.
	  */
	public boolean sendMessage() {
		try {
			// E-Mail versenden
    		Transport.send(msg);
		} catch (MessagingException e) {
			System.out.println("Fehler in Methode sendMessage(): " +
                                                e.getMessage());
			e.printStackTrace();
			return false;
		}
		return true;
	}
}