//Titel:        Mail-Client
//Version:      0.99
//Copyright:    Copyright (c) 2000
//Autor:        Christoph Borowski, cb@ordix.de
//Firma:        ORDIX AG, www.ordix.de, Westernmauer 12-16, 33098 Paderborn
//Beschreibung: Beispielanwendung, die die JavaMail-API einsetzt.

package mail.view;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.io.*;

import mail.model.*;

/**
  * Die Klasse MainFrame implmentiert das Startfenster der
  * Anwendung mit zwei Button zum ndern der
  * Anwendungseinstellungen und zum Beenden der Anwendung.
  * Zustzlich erzugt die Klasse die Fenster zum Erstellen/
  * Versenden und zum Empfangen/Lschen von e-Mails.
  */
public class MainFrame extends JFrame
										implements ActionListener {
	JButton		optionButton = new JButton("Einstellungen");
	JButton		exitButton = new JButton("Ende");

	/**
	  * Konstruktor, der die graphische Oberflche erzeugt.
	  */
	public MainFrame() {
		// Layout-Manager setzen
		getContentPane().setLayout(new GridLayout(1, 2));

		// Button dem Fenster hinzufgen
		getContentPane().add(optionButton);
		getContentPane().add(exitButton);

    optionButton.setMnemonic('E');
    exitButton.setMnemonic('d');

		// Fenster als ActionListener bei den beiden Button anmelden
		optionButton.addActionListener(this);
		exitButton.addActionListener(this);

		// Anwendung darf nur ber den Ende-Button geschlossen werden
		setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);

		// Fenstergre berechnen lassen, Titel setzen
		// und auf den Bildschirm bringen
		pack();
		setTitle("Mein Mailsystem");
		setVisible(true);

		// Fenster zum Senden und Empfangen von Mails erzeugen
		SendFrame sendFrm = new SendFrame();
		ReceiveFrame receiveFrame = new ReceiveFrame();

		// Position auf dem Bildschirm zuweisen
		sendFrm.setLocation(new Point(0,60));
		receiveFrame.setLocation(new Point(400, 60));

		// Beide Fenster sichtbar machen
		sendFrm.setVisible(true);
		receiveFrame.setVisible(true);
	}

	/**
	  * ActionListener-Methode zur Behandlung der ActionEvents
    * der beiden Buttons optionButton und exitButton.
	  */
	public void actionPerformed(ActionEvent ae) {
		if (ae.getSource() == optionButton) {
			// Dialog "Einstellungen" ffen
			new OptionsDialog(this, "Einstellungen");
			return;
		}
		if (ae.getSource() == exitButton) {
			// Anwendung beenden
			System.exit(0);
		}
	}

	/**
	  * Einstiegspunkt in die Anwendung.
	  */
	public static void main(String[] argv) {
		// Hauptfenster der Anwendung erzeugen
		new MainFrame();
	}
}