/**************************************************/
/* BasicCard - VERIFY                             */
/* Autor: Kai-Uwe Mrkor                           */
/**************************************************/

#include <stdio.h>
#include <winscard.h>
#include <string.h>

BOOL verify(char *pin, SCARDHANDLE handle);

/*********************/
/* Das Hauptprogramm */
/*********************/
int main(void)
{
  SCARDCONTEXT hContext;
  SCARDHANDLE  hKartenHandle;
  DWORD        protokoll;
  BOOL         test;
  char         pin[10];

  /* Mit Kontext verbinden */
  if (SCardEstablishContext(SCARD_SCOPE_USER,0,0,&hContext)
      == SCARD_S_SUCCESS)
  {
    /* Mit der Karte im angegebenen Leser verbinden */
    if (SCardConnect(hContext, "ZeitControl ZCT/ZC-SET 0",
        SCARD_SHARE_SHARED, SCARD_PROTOCOL_T1, &hKartenHandle,
        &protokoll) == SCARD_S_SUCCESS)
    {
      do
      {
        printf("\nBitte geben Sie Ihre PIN ein: ");
        scanf("%s",pin);
        test = verify(pin, hKartenHandle);
      }
      while(test!=TRUE);
      /* Verbindung mit Karte schlieen */
      SCardDisconnect(hKartenHandle, SCARD_EJECT_CARD );
    }
    else
      printf("SCardConnect() fehlgeschlagen\n");
    /* Kontext freigeben*/
    SCardReleaseContext(hContext);
  }
  else
    printf("SCardEstablishContext() fehlgeschlagen\n");

  return 0;
}

/********************************************************/
/* Sendet eine VERIFY-APDU mit einer 4stelligen PIN und */
/* gibt das Ergebnis auf dem Bildschirm aus             */
/********************************************************/
BOOL verify(char *pin, SCARDHANDLE handle)
{
  unsigned int  i;
  unsigned char antwort[20];
  DWORD         antwort_laenge;
  /*****************************************************************/
  /* die APDU VERIFY() liefert einen Prototypen zum PIN-Vergleich  */
  /*********************** CLA  INS   P1   P2  Lc    Datenfeld    **/
  unsigned char VERIFY[]={0x00,0x20,0x00,0x00,0x04, 'x','x','x','x'}; 

  /* bergebene PIN in APDU einfgen */
  memcpy((char*)&VERIFY[5],pin,4);
 
  printf("APDU: ");
  for (i=0; i<sizeof(VERIFY); i++)  /* Ausgabe der APDU */
    printf("%.2xh ", VERIFY[i]);

  antwort_laenge = sizeof(antwort); /* Senden der APDU */
  if (SCardTransmit(handle, SCARD_PCI_T1, VERIFY, sizeof(VERIFY), 
      NULL, antwort, &antwort_laenge) != SCARD_S_SUCCESS)
  {
    printf("SCardTransmit fehlgeschlagen.\n");
    return FALSE;
  } 
 
  printf("\nAntwort (SW1:SW2): ");  /* Trailer ausgeben */
  printf("%.2xh %.2xh\n", antwort[0], antwort[1]);  
 
  if (antwort[0]==0x90 && antwort[1]==0x00)
  {
    printf("Verify erfolgreich\n");
    return TRUE;
  }
  else
  {
    printf("Verify fehlgeschlagen\n");
    return FALSE;
  }
}
