#!/usr/bin/perl -w
#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#
 
use CGI qw/:standard :html3/;
use CGI::Carp qw/fatalsToBrowser/;


require "../shared_modules/M_session.pm";
require "../shared_modules/M_filters.pm";
require "M_tools.pm";
require "html_interface.cfg";

#-----------------------------------------------
my $debug = 0;

#-----------------------------------------------
my $max_filters        = $html_interface_config::max_filters;
my $no_session_message = $html_interface_config::mess_closed;
my $mail_message       = $html_interface_config::mess_mail;

#-----------------------------------------------

my $lang_code = "EN";     # actual language, must be fetched from userDB

#-----------------------------------------------
# these headers are presented for filtering
my @list_of_header_names = @html_interface_config::list_of_header_names;

#-----------------------------------------------

#--- for SessionDB
my $SessDB_DIR      = "../databases/ZWap-SessionKeys";
my $SessDB_DSN      = "DBI:CSV:f_dir=$SessDB_DIR";
my $SessDB_USER     = "";
my $SessDB_PASSWD   = "";

#-- create connection to Session-database  
my $SessDbh = M_session::connectDB(
				   $SessDB_DSN, 
				   $SessDB_USER, 
				   $SessDB_PASSWD
				  ) 
  or die "Cannot connect to sessionDB";

#--- for EmailDB
my $EmailDB_DIR      = "../databases/ZWap-Email";
my $EmailDB_DSN      = "DBI:CSV:f_dir=$EmailDB_DIR";
my $EmailDB_USER     = "";
my $EmailDB_PASSWD   = "";

#-- create connection to Email-database  
my $EmailDbh = M_filters::connectDB(
				    $EmailDB_DSN, 
				    $EmailDB_USER, 
				    $EmailDB_PASSWD
				   ) 
  or die "Cannot connect to EmailDB";


#-- find sessID  ---------------
my $sessID = $ENV{"PATH_INFO"};
$sessID =~ s#^/+(.*)#$1#;     # fuehrende / ab
my $sessIDvalid = M_session::validID( $SessDbh, $sessID);


#-- there is no active session ---------
if ( $sessIDvalid == 0) {
  no_session( $sessID);
  exit;
}
#--------------------------------
# get UserID from Session
my $user = M_session::getIDFromSession( $SessDbh, $sessID);

#--------------------------------
#-- marker
my $normal_color = "black";
my $ok_color = "blue";
my $err_color = "red";
#--------------------------------


#-- let's start 
print header(), start_html(-BGCOLOR=>'#FFFFFF');


#-- insert new MailFilter
if(param('insert')) {

  $alias   = param('alias');
  $filter  = param('filter');
  $type    = param('type');
  $target  = param('target');
  $activ   = param('activ');

  if( $alias eq "" || $filter eq "") {
    nothing_entered();
  } else {
    if( M_filters::insert_rec(
			      $EmailDbh, 
			      $user,
			      $alias, 
			      $filter,
			      $type,
			      $target,
			      $activ
			     ) == 1) {
      
      print "<h1>MailFilter <font color=\"$ok_color\">$alias</font> inserted.</h1>\n";
      show( $alias, $ok_color);
    } else {
      print "<h1>insert failed: MailFilter <font color=\"$err_color\">$alias</font> exists!</h1>\n";
      show( $alias, $err_color);
    }
  }


#-- new MailFilter
} elsif ( $sessIDvalid && param('new')) {

  print "<form action=\"$sessID\" method=\"post\">";
  print "<input type=\"hidden\" name=\"user\" value=\"${user}\">";

  print "<table>\n";
  print "<tr><td>FilterAlias:</td><td><input type=\"text\" name=\"alias\"></td></tr>\n";
  print "<tr><td>Filter:</td><td><input name=\"filter\"></td></tr>\n";

  print "<tr><td>Target:</td><td>"
      . "<select name=\"target\">";
  foreach $o (@list_of_header_names) {
    print "<option" . ($target eq $o ? " selected " : " ") . "value=\"${o}\">$o";
  }
  print "</select>"	
      . "</td></tr>\n";

  print "</table>\n";

  #-- new table for radioboxes
  print "<table>\n";
  #-- radioboxes in one row !
  print "<tr><td>Type:</td><td>"
      . "<input type=\"radio\" name=\"type\" checked value=\"X\">&nbsp;&nbsp;reject"
      . "<br>"
      . "<input type=\"radio\" name=\"type\" value=\"I\">&nbsp;&nbsp;accept"
      . "</td>\n";

  #-- spacer
  print "<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>";

  print "<td align=\"right\">active:</td><td>"
      . "<input type=\"radio\" name=\"activ\" checked value=\"Y\">&nbsp;&nbsp;yes"
      . "<br>"
      . "<input type=\"radio\" name=\"activ\" value=\"N\">&nbsp;&nbsp;no"
      . "</td>\n";

  print "</table>\n";

  #-- end radioboxes

  print "<input type=\"submit\" name=\"insert\" value=\"save\">\n";
  print "</form>";



#-- delete MailFilter
} elsif ( $sessIDvalid && param('delete')) {

  my $alias = param('sel');

  if ($alias eq "") {
    not_selected();
  } else {
    if( M_filters::delete_rec( $EmailDbh, $user, $alias) == 1) {
      print "<h1>MailFilter <font color=\"$ok_color\">$alias</font> deleted</h1>\n";
      show( $alias, $ok_color);
    } else {
      print "<h1>MailFilter <font color=\"$err_color\">$alias</font> delete failed</h1>\n";
      show( $alias, $err_color);
    }
  }

#-- edit MailFilter
} elsif ( $sessIDvalid && param('edit')) {

  my $alias = param('sel');

  if ($alias eq "") {
    not_selected();
  } else {
    my ($filter,$type,$target,$activ) = M_filters::getMailFilter( $EmailDbh, $user, $alias, 1);

    print "<form action=\"$sessID\" method=\"post\">";
    print "<input type=\"hidden\" name=\"user\" value=\"${user}\">";

    print "<table>\n";
    print "<tr><td>FilterAlias:</td><td><input type=\"hidden\" name=\"alias\" value=\"$alias\">$alias</td></tr>\n";
    print "<tr><td>Filter:</td><td><input name=\"filter\" value=\"$filter\"></td></tr>\n";

    print "<tr><td>Target:</td><td>"
        . "<select name=\"target\">";
    foreach $o (@list_of_header_names) {
      print "<option" . ($target eq $o ? " selected " : " ") . "value=\"${o}\">$o";
    }
    print "</select>"	
        . "</td></tr>\n";

    print "</table>\n";

    #-- new table for radioboxes
    print "<table>\n";
    #---- radioboxes in one row !
    print "<tr><td>Type:</td><td>"
      . "<input type=\"radio\" name=\"type\""
      . ($type eq "X" ? " checked " : "")
      . "value=\"X\">&nbsp;&nbsp;reject"
      . "<br>"
      . "<input type=\"radio\" name=\"type\""
      . ($type eq "I" ? " checked " : "")
      . "value=\"I\">&nbsp;&nbsp;accept"
      . "</td>\n";
    
    #-- spacer
    print "<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>";

    print "<td>active:</td><td>"
      . "<input type=\"radio\" name=\"activ\""
      . ($activ eq "Y" ? " checked " : "")
      . "value=\"Y\">&nbsp;&nbsp;yes"
      . "<br>"
      . "<input type=\"radio\" name=\"activ\""
      . ($activ eq "N" ? " checked " : "")
      . "value=\"N\">&nbsp;&nbsp;no"
      . "</td></tr>\n";

    print "</table>\n";

    #-- end radioboxes 
    
    print "<input type=\"submit\" name=\"change\" value=\"save\">\n";
    print "</form>";

  }


#-- write modified MailFilter
} elsif ( $sessIDvalid && param('change')) {

  my $alias   = param('alias');
  my $filter  = param('filter');
  my $type    = param('type');
  my $target  = param('target');
  my $activ   = param('activ');

  if( $alias eq "" || $filter eq "") {
    nothing_entered();
  } else {
    if ( M_filters::update_rec( $EmailDbh, $user, $alias, $filter, $type, $target, $activ) == 1) {
      print "<h1>MailFilter <font color=\"$ok_color\">$alias</font> changed </h1>\n";
      show( $alias, $ok_color);
    } else {
      print "<h1>MailFilter <font color=\"$err_color\">$alias</font> change failed </h1>\n";
      show( $alias, $err_color);
    }
  }


#-- list existing MailFilters, buttons for: 
#--      new, edit, delete 
} else {

  print "<h1>MailFilters for member $user </h1>\n";
  show("","");
}
#-- end of actions


#---
print end_html();


M_filters::disconnectDB( $EmailDbh );


#-- update TimeStamp 
M_session::updateSessID( $SessDbh, $sessID);

M_session::disconnectDB( $SessDbh );

       
#------------------ END --------------------------------

#-----------------------------------------------------------
#--  message "session not active"
sub no_session {
  my ($sessID) = @_;

  print header(), start_html(-BGCOLOR=>'#FFFFFF') ;
  M_tools::print_file($no_session_message);
  M_tools::print_file($mail_message);
  print end_html();
}

#---
sub not_selected {
  print "<h1><font color=\"$err_color\">Select an item to perfom action on, please</font></h1>\n";
  show("","");
}

#---
sub nothing_entered {
  print "<h1><font color=\"$err_color\">Nothing entered.</font></h1>\n";
  show("","");
}

#--- 
sub show {
  my ($selection,$marker_color) = @_;

  my %texts = (
	       X    => "reject",
	       I    => "accept",
	       Y    => "yes",
	       N    => "no"
	      );

  my %filters  = ();
  my %targets  = ();
  my %types    = ();
  my %actives  = ();

  M_filters::getMailFilters( $EmailDbh, $user, \%filters, \%types, \%targets, \%actives, 1);

  print "<h1>No MailFilters defined yet.</h1>\n" if !(keys %filters);

  print "<form action=\"$sessID\" method=\"post\">\n";

  print "<table>\n"
      . "<th align=\"left\">select:</th>"
      . "<th>&nbsp;&nbsp;</th>"
      . "<th align=\"left\">Name</th>"
      . "<th>&nbsp;&nbsp;</th>"
      . "<th align=\"left\">Pattern</th>" 
      . "<th>&nbsp;&nbsp;</th>"
      . "<th align=\"left\">Type</th>" 
      . "<th>&nbsp;&nbsp;</th>"
      . "<th align=\"left\">Target</th>\n"   
      . "<th>&nbsp;&nbsp;</th>"
      . "<th align=\"left\">activ</th>\n"   
	if (keys %filters);

  foreach $t (sort (keys %filters)) {
    if ( $t eq $selection ) { 
      $color = $marker_color;
    } else {
      $color = $normal_color;
    } 

    print "<tr>"
        . "<td align=\"center\"><input type=\"radio\" name=\"sel\" value=\"${t}\"></td>"
        . "<td>&nbsp;&nbsp;</td>"
        . "<td align=\"left\"><font color=\"$color\">$t</font></td>"
        . "<td>&nbsp;&nbsp;</td>"
        . "<td align=\"left\"><font color=\"$color\">$filters{$t}</font></td>"
        . "<td>&nbsp;&nbsp;</td>"
        . "<td align=\"left\"><font color=\"$color\">$texts{$types{$t}}</font></td>"
        . "<td>&nbsp;&nbsp;</td>"
        . "<td align=\"left\"><font color=\"$color\">$targets{$t}</font></td>"
        . "<td>&nbsp;&nbsp;</td>"
        . "<td align=\"left\"><font color=\"$color\">$texts{$actives{$t}}</font></td>"
        . "<td>&nbsp;&nbsp;</td>"
        . "</tr>\n";
  }

  print "</table>\n";

  print "<p>perform action on selected item (except \"new\" ;)</p>" if (keys %filters);
  print "<p>please define MailFilters by use of \"new\"-button.</p>" if !(keys %filters);
  print "<table><tr>";
  print "<td><input type=\"submit\" name=\"new\" value=\"new\"></td>" if (keys %filters) < $max_filters;
  print "<td><input type=\"submit\" name=\"edit\" value=\"edit\"></td>"
      . "<td><input type=\"submit\" name=\"delete\" value=\"delete\"></td>" if (keys %filters);
  print "</tr></table>";
  print "</form>\n";

}

#-----------------------------------------------------------
 


