#!/usr/bin/perl -w
#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#
 
use CGI qw/:standard :html3/;
use CGI::Carp qw/fatalsToBrowser/;


require "../shared_modules/M_session.pm";
require "../shared_modules/M_instantext.pm";
require "M_tools.pm";
require "html_interface.cfg";

#-----------------------------------------------
my $debug = 0;

#-----------------------------------------------
my $max_instantexts    = $html_interface_config::max_instantexts;
my $no_session_message = $html_interface_config::mess_closed;
my $mail_message       = $html_interface_config::mess_mail;

#-----------------------------------------------

my $lang_code = "EN";     # actual language, must be fetched from userDB

#-----------------------------------------------

#--- for SessionDB
my $SessDB_DIR      = "../databases/ZWap-SessionKeys";
my $SessDB_DSN      = "DBI:CSV:f_dir=$SessDB_DIR";
my $SessDB_USER     = "";
my $SessDB_PASSWD   = "";

#-- create connection to Session-database  
my $SessDbh = M_session::connectDB(
				   $SessDB_DSN, 
				   $SessDB_USER, 
				   $SessDB_PASSWD
				  ) 
  or die "Cannot connect to sessionDB";

#--- for EmailDB
my $EmailDB_DIR      = "../databases/ZWap-Email";
my $EmailDB_DSN      = "DBI:CSV:f_dir=$EmailDB_DIR";
my $EmailDB_USER     = "";
my $EmailDB_PASSWD   = "";

#-- create connection to Email-database  
my $EmailDbh = M_instantext::connectDB(
				       $EmailDB_DSN, 
				       $EmailDB_USER, 
				       $EmailDB_PASSWD
				      ) 
  or die "Cannot connect to EmailDB";


#-- find sessID  ---------------
my $sessID = $ENV{"PATH_INFO"};
$sessID =~ s#^/+(.*)#$1#;     # fuehrende / ab
my $sessIDvalid = M_session::validID( $SessDbh, $sessID);


#-- there is no active session ---------
if ( $sessIDvalid == 0) {
  no_session( $sessID);
  exit;
}
#--------------------------------
# get UserID from Session
my $user = M_session::getIDFromSession( $SessDbh, $sessID);

#--------------------------------
#-- marker
my $normal_color = "black";
my $ok_color = "blue";
my $err_color = "red";
#--------------------------------


#-- let's start 
print header(), start_html(-BGCOLOR=>'#FFFFFF');


#-- new InstanText
if(param('insert')) {

  $text_alias = param('i_alias');
  $text       = param('i_text');

  if( $text_alias eq "" || $text eq "") {
    nothing_entered();
  } else {

    if( M_instantext::insert_rec(
				 $EmailDbh, 
				 $user,
				 $text_alias, 
				 $text
				) == 1) {
      
      print "<h1>InstanText <font color=\"$ok_color\">$text_alias</font> inserted.</h1>\n";
      show( $text_alias, $ok_color);
    } else {
      print "<h1>insert failed: InstanText <font color=\"$err_color\">$text_alias</font> exists!</h1>\n";
      show( $text_alias, $err_color);
    }
  }

#-- new InstanText 
} elsif ( $sessIDvalid && param('new')) {

  print "<form action=\"$sessID\" method=\"post\">";
  print "<input type=\"hidden\" name=\"user\" value=\"${user}\">";

  print "<table>\n";
  print "<tr><td>TextName:</td><td><input type=\"text\" name=\"i_alias\"></td></tr>\n";
  print "<tr><td>Text:</td><td><textarea rows=\"5\" cols=\"40\" wrap=\"physical\" maxlength=\"200\" name=\"i_text\"></textarea></td></tr>\n";
  print "</table>\n";

  print "<input type=\"submit\" name=\"insert\" value=\"save\">\n";
  print "</form>";


#-- delete InstanText 
} elsif ( $sessIDvalid && param('delete')) {

  my $text_alias = param('sel');

  if ($text_alias eq "") {
    not_selected();
  } else {

    if( M_instantext::delete_rec( $EmailDbh, $user, $text_alias) == 1) {

      print "<h1>InstanText <font color=\"$ok_color\">$text_alias</font> deleted</h1>\n";
      show( $text_alias, $ok_color);

    } else {
      print "<h1>InstanText <font color=\"$err_color\">$text_alias</font> delete failed</h1>\n";
      show( $text_alias, $err_color);
    }
  }

#-- edit InstanText 
} elsif ( $sessIDvalid && param('edit')) {

  my $text_alias = param('sel');

  if ($text_alias eq "") {
    not_selected();
  } else {

    my ($text) = M_instantext::getInstanText( $EmailDbh, $user, $text_alias);

    print "<form action=\"$sessID\" method=\"post\">";
    print "<input type=\"hidden\" name=\"user\" value=\"${user}\">";
    
    print "<table>\n";
    print "<tr><td>TextName:</td><td><input type=\"hidden\" name=\"i_alias\" value=\"$text_alias\">$text_alias</td></tr>\n";
    print "<tr><td>Text:</td><td><textarea rows=\"5\" cols=\"40\" wrap=\"physical\" maxlength=\"200\" name=\"i_text\">$text</textarea></td></tr>\n";
    print "</table>\n";
    
    print "<input type=\"submit\" name=\"change\" value=\"save\">\n";
    print "</form>";
  }

#-- write modified InstanText 
} elsif ( $sessIDvalid && param('change')) {

  my $text_alias = param('i_alias');
  my $text = param('i_text');

  if( $text_alias eq "" || $text eq "") {
    nothing_entered();
  } else {

    if ( M_instantext::update_rec( $EmailDbh, $user, $text_alias, $text) == 1) {
      print "<h1>InstanText <font color=\"$ok_color\">$text_alias</font> changed</h1>\n";
      show( $text_alias, $ok_color);
    } else {
      print "<h1>InstanText <font color=\"$err_color\">$text_alias</font> change failed</h1>\n";
      show( $text_alias, $err_color);
    }
  }


#-- list existing InstanTexts, buttons for: 
#--      new, edit, delete 
} else {

  print "<h1>InstanTexts for member $user</h1>\n";

  show("", $normal_color);
}
#-- end of actions


#---
print end_html();


M_instantext::disconnectDB( $EmailDbh );


#-- update TimeStamp 
M_session::updateSessID( $SessDbh, $sessID);

M_session::disconnectDB( $SessDbh );

       
#------------------ END --------------------------------

#-----------------------------------------------------------
#--  message "session not active"
sub no_session {
  my ($sessID) = @_;

  print header(), start_html(-BGCOLOR=>'#FFFFFF') ;
  M_tools::print_file($no_session_message);
  M_tools::print_file($mail_message);
  print end_html();
}

#---
sub not_selected {
  print "<h1><font color=\"$err_color\">Select an item to perfom action on, please</font></h1>\n";
  show("","");
}

#---
sub nothing_entered {
  print "<h1><font color=\"$err_color\">Nothing entered.</font></h1>\n";
  show("","");
}

#--- 
sub show {
  my ($selection,$marker_color) = @_;

  my %texts = ();

  M_instantext::getInstanTexts( $EmailDbh, $user, \%texts);

  print "<h1>No InstanTexts defined yet.</h1>\n" if !(keys %texts);

  print "<form action=\"$sessID\" method=\"post\">\n";

  print "<table>\n"
      . "<th align=\"left\">select:</th>"
      . "<th>&nbsp;&nbsp;</th>"
      . "<th align=\"left\">name</th>"
      . "<th>&nbsp;&nbsp;</th>"
      . "<th align=\"left\">InstanText</th>\n" if (keys %texts);

  foreach $t (sort (keys %texts)) {
    if ( $t eq $selection ) { 
      $color = $marker_color;
    } else {
      $color = $normal_color;
    } 
    print "<tr>"
        . "<td align=\"center\"><input type=\"radio\" name=\"sel\" value=\"${t}\"></td>"
        . "<td>&nbsp;&nbsp;</td>"
        . "<td align=\"left\"><font color=\"$color\">$t</font></td>"
        . "<td>&nbsp;&nbsp;</td>"
        . "<td align=\"left\"><font color=\"$color\">$texts{$t}</font></td>"
        . "</tr>\n";
  }

  print "</table>\n";

  print "<p>perform action on selected item (except \"new\" ;)</p>" if (keys %texts);
  print "<p>please define InstanText by use of \"new\"-button.</p>" if !(keys %texts);
  print "<table><tr>";
  print "<td><input type=\"submit\" name=\"new\" value=\"new\"></td>" if (keys %texts) < $max_instantexts;
  print "<td><input type=\"submit\" name=\"edit\" value=\"edit\"></td>"
      . "<td><input type=\"submit\" name=\"delete\" value=\"delete\"></td>" if (keys %texts);
  print "</tr></table>";
  print "</form>\n";

}

#-----------------------------------------------------------
 


