#!/usr/bin/perl -w
#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#




#-----------------------------------------------------------
#
# daemon zum Loeschen der SessionIDs nach Ablauf d. timeouts
#
#
#-----------------------------------------------------------


use POSIX;
use IO::Socket;
use DBI;            # fuer Datenbank
use Unix::Syslog qw(:macros);
use Unix::Syslog qw(:subs);

$debug = 0;
$logit = 1;


#-------- fuer SessionDB 
my $SessDB_DIR      = "../databases/ZWap-SessionKeys";
my $SessDB_DSN      = "DBI:CSV:f_dir=$SessDB_DIR";
my $SessDB_USER     = "";
my $SessDB_PASSWD   = "";
#---------------------------------------------

my $time2die = 0;        # daemon beenden (sigint, sigterm, sighup)
my $saveDir ="/tmp/daemon";  # Arbeitsverzeichnis
my $pidFile ="sIDkiller.pid";
my $delay   = 5;         # naechster Test in sek.

#-----------------------------------------------

#--- in sicheres Verzeichnis wechseln
#chroot(${saveDir}) or die "chroot: can`t change to ${saveDir}\n";

#--- neuen Prozess forken
$pid = fork;
exit if $pid;
die "fork: can`t start new prozess: $!\n" unless defined($pid);

#--- ProzessNr. nach /var/run/NAME schreiben 
#open(PFILE, "> $pidFile") or die "cannot open pid file\n";
#print PFILE $$ . "\n";
#close PFILE;

#--- vom kontollierenden Terminal loesen
POSIX:setsid() or die "setsid: \n";

#--- signale abfangen
$SIG{INT} = $SIG{TERM} = $SIG{HUP} = \&signal_handler;

#--- syslog-Verbindung herstellen
openlog('sIDkiller', LOG_PID, LOG_DAEMON) if $logit;
syslog( LOG_INFO, "sIDkiller.pl started") if $logit;

#--- Datenbank-Verbindung. ----------------------------
#- Handle holen
my $SessDbh = DBI->connect(
		       $SessDB_DSN, 
		       $SessDB_USER, 
		       $SessDB_PASSWD
		      ) 
  or die "Cannot connect to DB";
#--- Datenbank-Verbindung. ende -----------------------


#--- jetzt die Hauptaufgabe
until ($time2die) {

  # per SQL alle AKTUELLEN Eintraege der DB holen
  #  >> perldoc DBI

  $sth = $SessDbh->prepare("SELECT user,sessionID,timelimit FROM SessionKeys");
  $sth->execute();

  while ( @row = $sth->fetchrow_array) {

    ($user,$sessionID,$timelimit) = @row;

    my $now = time() ;
    print "TIME: $now   U:$user   S:$sessionID   T:$timelimit \n" if $debug;

    # fuer jeden Eintrag testen, ob timeout abgelaufen ist.
    if ($now > $timelimit) {
      # ja:  Eintrag entfernen, syslog schreiben
      delID( $SessDbh, $sessionID);
      syslog( LOG_INFO, "ID %s cancelled", $sessionID) if $logit;
    }
  }
  print "-----------------\n" if $debug;

  # warten bis zum naechsten Durchlauf
  sleep($delay);

}
#--- fertig damit

#--- Datenbankverbindung lsen.
$SessDbh->disconnect();

#--- syslog-Verbindung abbauen
syslog( LOG_INFO, "sIDkiller.pl shutdown") if $logit;
closelog() if $logit;

exit; #-------- schluss


#-----------------------------------------------
#     SignalHandler
sub signal_handler {
  $time2die = 1;
}

#---------------
#- ID loeschen
sub delID {             
  my ($dbh,$sessID) = @_;

  if ( isvalidID( $dbh, $sessID) eq "OK") {
    #- Eintrage mit sessID loeschen
    my $sql = qq[ 
		 DELETE FROM SessionKeys
		 WHERE (sessionID = "$sessID")
		];
    $dbh->do($sql) or return("FAIL");

    print "ID: $sessID cancelled\n" if $debug;

    return($sessID);
  } else {
    return("FAIL");
  }
}

#---------------
#- gibts diese ID?
sub isvalidID {
  my ($dbh,$sessID) = @_;

  #- gibts einen Eintrag sessID?
  $sth = $dbh->prepare(
	       "SELECT sessionID FROM SessionKeys WHERE (sessionID = ?)") 
               or return("FAIL");;
  $sth->execute($sessID) or return("FAIL");

  ($ID) =  (@row = $sth->fetchrow_array);
  if( !defined $ID) { $ID = "";}
  
#  print "ID: $ID \n" if $debug;

  if ( $ID eq $sessID) {
    return("OK");
  } else {
    return("FAIL");
  }
}

