#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#

# package zur verwaltung der InstantTexte

package M_instantext;

use DBI;


##################################################
#
#     DataBase: ZWap-Email
#
#
#
#           table  InstanText
#   ------------------------------------------
#   ZWAPuser,   i_alias,   i_text
#
#
##################################################




##################################################
sub connectDB {
##################################################
  my (
      $DB_DSN, 
      $DB_USER, 
      $DB_PASSWD
     ) = @_;

  #-- Datenbank-Verbindung herstellen  
  my $dbh = DBI->connect($DB_DSN, $DB_USER, $DB_PASSWD) or $dbh = undef;
 
  return $dbh;
}

##################################################
sub disconnectDB {
##################################################
  my ($dbh) = @_;

  #-- Datenbank-Verbindung schliessen
  $dbh->disconnect();  # Datenbankverbindung lsen.
}

##################################################
sub instantext_exists {
##################################################
  my (
      $dbh, 
      $user, 
      $i_alias
     ) = @_;
			  
  my $sql = qq[SELECT i_alias FROM InstanText WHERE ZWAPuser = ? AND i_alias = ?];

  my $sth = $dbh->prepare( $sql) or return(0);



#  my $sth = $dbh->prepare(
#			  "SELECT i_alias FROM InstanText WHERE ZWAPuser = ? AND i_alias = ?"
#			 ) 
#    or return(0);




  $sth->execute( $user, $i_alias) or return(0);

  ($alias) =  (@row = $sth->fetchrow_array);
  if( !defined $alias) { $alias = "";}
  
  if ( $alias eq $i_alias) {
    return(1);
  } else {
    return(0);
  }
}

##################################################
sub insert_rec {
##################################################
  my(
     $dbh,
     $user,
     $i_alias, 
     $i_text
    ) = @_;
  
  if( instantext_exists( $dbh, $user, $i_alias)) {
    return(0);
  }

  my $sql = qq[
	       INSERT INTO InstanText
	       (ZWAPuser,i_alias,i_text)
	       VALUES ('$user', '$i_alias', '$i_text')
	      ];

  $dbh->do($sql) or die "Insert failed ($sql)";

  return(1);
}

##################################################
sub update_rec {
##################################################
  my(
     $dbh,
     $user,
     $i_alias, 
     $i_text
    ) = @_;

  my $sql = qq[
	       UPDATE InstanText SET
	       i_text='$i_text'
	       WHERE (ZWAPuser = '$user' AND i_alias = '$i_alias')
	      ];

  $dbh->do($sql) or die "Update failed ($sql)";

  return(1);
}

##################################################
sub delete_rec {
##################################################
  my(
     $dbh,
     $user,
     $i_alias
    ) = @_;

  my $sql = qq[
               DELETE FROM InstanText
               WHERE (ZWAPuser = '$user' AND i_alias = '$i_alias')
              ];

  $dbh->do($sql) or return(0);

  return(1);
}

#################################################
#-- Mail-Texte holen
#################################################
sub getInstanTexts {
  my (
      $dbh, 
      $user, 
      $texts
     ) = @_;

  %textsTmp = (
	       "vacation"     => "Ich bin bis zum x August im Urlaub!",
	       "Termin"       => "Ich komme um x Uhr.",
	       "Kaffee"       => "Mach schon mal Kaffee!",
	       "Tee"          => "Ich mag lieber Tee!",
	       "was?"         => "was gibts?",
	      );

#  foreach $t (keys %textsTmp) {
#    $ {$texts}{$t} = $textsTmp{$t};
#  }

  my $sth = $dbh->prepare(
			  "SELECT i_alias, i_text FROM InstanText WHERE (ZWAPuser = ?)"
			 );
  $sth->execute( $user);
  
  while( (@row = $sth->fetchrow_array) ) {
    ($alias,$text) =  (@row);
    $ {$texts}{$alias} = ${text};
  }

}


#################################################
#-- einen    Mail-Texte holen
#################################################
sub getInstanText {
  my (
      $dbh, 
      $user, 
      $i_alias
     ) = @_;

  my $sth = $dbh->prepare(
			  "SELECT i_text FROM InstanText WHERE (ZWAPuser = ? AND i_alias = ?)"
			 );

  $sth->execute( $user,$i_alias) or return("");;

  my ($t) = (@row = $sth->fetchrow_array);
  return($t);
}


#---------------------------------------------------------------------

1;     # rueckmeldung

#---------------------------------------------------------------------
