#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#

package M_pop;

use Net::POP3;
require "ZwapTools.pm";

$debug = 0;




#---  EmailDB (Filters), vars are set by calling script 
$EmailDB_DIR      = "";
$EmailDB_DSN      = "";
$EmailDB_USER     = "";
$EmailDB_PASSWD   = "";

#---  SessDB , vars are set by calling script 
$SessDB_DIR      = "";
$SessDB_DSN      = "";
$SessDB_USER     = "";
$SessDB_PASSWD   = "";


  
#-- auth. per pop3server durchfuehren
sub POPauth {
  my ($server, $account, $p) = @_;
  my $ret = undef;
  
  my $pop = Net::POP3->new( $server );
  if (defined($pop)) {
    
    if( defined($pop->login($account, $p)) ) {
      $ret = 1; # OK
    } else {
      $ret = 0; # login failed, pw or user wrong
    }
    $pop->quit();
  } else {
    $ret = 2; # server failed
  }
  return $ret;
}


#-- Mails auflisten
sub getList {
  my ($ID,$server, $account, $pw, $start, $mail_cnt) = @_;
  
  my @entrys = ();
  my $new_start = 0;

  my $pop = Net::POP3->new( $server);
  if ($pop) {
    my $count = $pop->login( $account, $pw);
    if( defined( $count) ){
      #print "M_pop::count: $count \n" if $debug;
      if ( $count > 0 ) {


	#- SessID used by next function call
	my $SessID = ZwapTools::getSessIDfromID (
						 $SessDB_DSN,
						 $SessDB_USER,
						 $SessDB_PASSWD,
						 $ID,
						);

	# get mail filters selection from session, used by "match_filter"
	my $FI = ZwapTools::getGlobalFilterCFGfromSession(
							  $SessDB_DSN,
							  $SessDB_USER,
							  $SessDB_PASSWD,
							  $SessID,
							 );
  	
	#-- also used by "match_filter" subroutine  
	%filters = ();
	%types   = ();
	%targets = ();
	%actives = ();

	# get filter from filter-DB, 
	#  select only activated ones by sessionDB
	ZwapTools::getMailFilters(
				  $EmailDB_DSN,
				  $EmailDB_USER,
				  $EmailDB_PASSWD,
				  $ID,
				  \%filters,
				  \%types,
				  \%targets,
				  \%actives
				 );

	#-- create hash of defined filters 
	#-- one entry for every header name
	%FI_targets = ();
	foreach $kkk (keys %targets) {
	  $FI_targets{$targets{$kkk}} = 1;
	}

	my $Msgs = $pop->list();
	
	my $eindex = 0;
	my $index = 0;
	foreach $MsgID ( keys %$Msgs) {

#-- next, falls MsgID im Array (pro User) der schon gelesenen Mails
#--       bzw. nur die schon gelesenen Mails anzeigen

	  $index++;
	  if ( $index < $start ) { next; }   # skip 

	  print "\n\n\nMSGID: $MsgID        \n" if $debug;

	  #- init
	  %FI_headers = ();
	  $date = $from = $subject = "";    # init varsD

	  $size = $pop->list($MsgID);       # get size of mail
	  
	  my $header = $pop->top( $MsgID, 0);  # get headers of mail 

	  foreach $h ( @$header) {
	    chop($h);                            # cut off newline 

	    #-- lets prepare FI_headers for "match_filter" routine
	    #- work on copy of header
	    my $tmp_h = $h;
	    
	    #-- get header name from header
	    $header_name = $tmp_h;
	    $header_name =~ s/^(\S[^:]*):\s*(.*)/$1/;

	    #- if there is a filter defined for this header name,
	    #- store this header into hash
	    if ( defined($FI_targets{$header_name})) {
 	      $tmp_h =~ s/^($header_name):\s*(.*)/$2/;
	      $FI_headers{$header_name} = $tmp_h;
	    }

	    #-- from, subject and date  are needed in any case
 	    if ( $h =~ m/^(From|Von):\s+/i ) {   # hit From: header
 	      $from = $h;
 	      $from =~ s/^(From|Von):\s*(.*)/$2/;
 	    }
 	    if ( $h =~ m/^(Subject):\s+/i ) {    # hit Subject: header
 	      $subject = $h;
 	      $subject =~ s/^(Subject):\s*(.*)/$2/;
 	    }
 	    if ( $h =~ m/^(Date):\s+/i ) {       # hit Date: header
 	      $date = $h;
 	      $date =~ s/^(Date):\s*(.*)/$2/;
 	    }

	  } # end foreach header


	  #-- MailFilter 
	  
	  #-- BETTER PASS HASH-REFERENCES TO SUBROUTINE THAN USE GLOBAL VARS
	  #-- match_filter must be modified to do this!!!!
#	  if ( match_filter( 
#			    $ID, $FI, 
#			    \%filters, \%types, \%target, \%actives, 
#			    \%FI_headers, \%FI_targets
#			   ) == 1) { 
	  if ( match_filter( $ID, $FI) == 1) { 
#	    print STDERR "\n.... skipped ....\n";
	    next; 
	  }

	if ($subject eq "") { $subject = "subject empty"; }
	if ($from eq "") { $from = "from empty"; }
	if ($date eq "") { $date = "date empty"; }

	  #-- store header data into entry :  from, subject, size, date
	  $entrys[$eindex] = [$MsgID, $from, $subject, $size, $date];
	  $eindex++;

	  #- enough entrys
	  if ( $eindex >= $mail_cnt) { last; }

	} # foreach MsgID

	# new startindex
	$new_start = $index + 1;

#print STDERR "count: $count\nstart: $start \nnewstart: $new_start\n";

	print "OK: count: $count \n" if $debug;
	#-- liefert referenz auf array !!!
	return( \@entrys, $eindex, $count, $new_start);
      } else {
	print "no mails  (count =0)\n" if $debug;
	return( \@entrys, 0, 0, 0);
      }
    } else {
      #- login failed
      print "login failed \n" if $debug;
      return( \@entrys, 0, 0, 0);
    }

    #- MailServerVerbindung loesen
    $pop->quit(); 
	
  } else {
    print "no connection to  mail server\n" if $debug;
    return( \@entrys, 0, 0, 0);
  }
}


#---------------------------------------------
sub filterFromLine {
  my ($str) = @_;

  #--- KlarName
#  $str =~ s/(.*)<.*>(.*)/$1 $2/;

  #--- echte MailAdr.
  $str =~ s/.*<(.*)>.*/$1/;

  return( $str);
}
#---------------------------------------------



#-- Mail stueckweise auslesen
# liefert:  (
#            $lines,             Referenz auf ZeilenArray
#            $heads,             Ref auf Array mit Headern (variabel)
#            $ecount,            Anzahl der Zeilen in lines
#            $mail_zeilen        gesamtZahl der Zeilen in der Mail
#           )
sub readMail {
  my ($server,$account,$pw,$mailstart,$mailend,$msgID) = @_;
#  my ($server,$account,$pw,$mailstart,$mailend,$msgID,$maxbytes) = @_;

  my @lines = ();
  my @heads = ();
  my $subject = "";
  my $from = "";
  my $date = "";
  my $replyto = "";
  my $NumOfBytes = 0;



  $maxbytes = 600;                # abhaengig vom WAP-Client

  
  my $pop = Net::POP3->new( $server);
  if ($pop) {

    my $loginOK = $pop->login( $account, $pw);
    if( defined( $loginOK) ){

      #--  Header und die Zeilen der Mail lesen
      my $isMime = 0;   #-- erstmal keine MIME-Mail
      my $count = 0;
      my $ecount = 0;        #-- 
      my $headerZeilen = 0;  #-- soviel Zeilen hat der Header
      my $mail_zeilen = 0;   #-- soviel Zeilen hat die ganze Mail
      my $zeilenarray = $pop->get( $msgID);  # liefert Ref. auf Array mit Zeilen

      if( defined( $zeilenarray)) {

	$mail_zeilen = $#{$zeilenarray};

	#--- ueber alle Zeilen in zarr 
	$NumOfBytes = 0;
	my $inHeader = 1;
	foreach $z ( @$zeilenarray) {
	  chop( $z );   # newline abschneiden

	  if( $inHeader ) { #----------------------------- HEADER
	    #-- header filtern
	    if ( $z =~ m/^(From|Von):\s+/i ) {   # From: getroffen
	      $from = $z;
	      $from =~ s/^(From|Von):\s*(.*)/$2/;
	    }
	    
	    if ( $z =~ m/^(Subject):\s+/i ) {    # Subject: getroffen
	      $subject = $z;
	      $subject =~ s/^(Subject):\s*(.*)/$2/;
	    }
	    
	    if ( $z =~ m/^(Date):\s+/i ) {    # Date: getroffen
	      $date = $z;
	      $date =~ s/^(Date):\s*(.*)/$2/;
	    }

	    if ( $z =~ m/^(Reply-To):\s+/i ) {    # Reply-To: getroffen
	      $replyto = $z;
	      $replyto =~ s/^(Reply-To):\s*(.*)/$2/;
	    }
	    
	    $headerZeilen++;

	    if ( $z eq "" ) {  #- auf MailContent schalten
	      $inHeader = 0; 

	      if ( $mailstart == 1) {
		# verbrauchte Bytes berechnen
		$NumOfBytes = length($from) + length($subject) + length($date);
	      }
	    } 

	  } else { #--------------------------------------- MAIL CONTENT



####### hier (mail-Inhalt) nicht zeilenweise, sondern byte-weise zaehlen !!!!!!!





#????	    if ( $z =~ m/^(MIME):\s+/i  ) { $isMime = 1;} #-- MIME einschalten

	    if ( $isMime ) { #------------------------- MIME

	      #- isMIME = 1;
	      #- MIME mail bearbeiten
	    
	    } else { #--------------------------------- Text

	      $count ++;
	      if( $count < $mailstart) { next; }
	    
	      $lines[$ecount] = $z;
	      
	      $NumOfBytes += length( $z );
	      $ecount ++;
	      if( $NumOfBytes >= $maxbytes) { last; }
	    
	      if ( $count >= $mailend) { last; }	  
	    }

	  }
	}

	#- from, subject, date, replyto einsetzen
	$heads[0] = $from;
	$heads[1] = $subject;
	$heads[2] = $date;
	$heads[3] = $replyto;
      }




#-- pro User: MsgID !!!! Hash der ID !!!!  
#--           , MsgDate und LeseDatum ins Array der schon gelesenen Mails schreiben





      #- MailServerVerbindung loesen
      $pop->quit(); 

      #- OK mail liefern
      print "OK show mail  \n" if $debug;
      return( \@lines, \@heads, $ecount, $mail_zeilen-$headerZeilen);

    } else {
      #- MailServerVerbindung loesen
      $pop->quit(); 
      #- login failed
      print "login failed \n" if $debug;
      return( \@lines, \@heads, 0, 0);
    }

    #- MailServerVerbindung loesen
    $pop->quit(); 

  } else {
    print "no connection to mail server\n" if $debug;
    return( \@lines, \@heads, 0, 0);
  }
}

#-------------------------------------------------------------------

# filter mail headers
sub match_filter {
  my (
      $ID,          # userID
      $FI           # Filter
     ) = @_;


  #- now filled from calling routine
  #- have better to be passed throuh parameter list as reference
  #- access to hashes must be modified to access references
#  my %filters = ();
#  my %types   = ();
#  my %targets = ();
#  my %actives = ();



  # which filter types in DB?
  my ($excl, $incl) = ZwapTools::getdefinedFilterTypes(
						       $EmailDB_DSN,
						       $EmailDB_USER,
						       $EmailDB_PASSWD,
						       $ID
						      );

  # fall back, if globally selected filter type isn't defined in DB
  if ( $FI eq "X" && $excl == 0) { $FI = "N"; }
  if ( $FI eq "I" && $incl == 0) { $FI = "N"; }

  my $ftype = "";
  my $ret = 1;
  #- initialize vars according to filter selection
  if ($FI eq "X") {           # apply exclude filters

    $ftype = "X";
    $matched = 1;             # skip
    $n_matched = 0;           # dont skip

  } elsif ( $FI eq "I") {     # apply include filters
                              # reverse return values 

    $ftype = "I";
    $matched = 0;             # skip
    $n_matched = 1;           # dont skip

  } else {                    # don't apply any filters, return 0
    return(0);
  }


  my %FI_strings = ();
  foreach $ft (keys %FI_targets) {      # one entry per defined header to filter 
    foreach $fk (keys %filters) {
      if ( $targets{$fk} eq $ft  && $types{$fk} eq $ftype ) {
	$FI_strings{$ft} .=  "($filters{$fk})|" ;
#print STDERR "test-   FI_strings{$ft} = $FI_strings{$ft} \n";	
      }
    }
  }
  foreach $ft (keys %FI_strings) {
    chop($FI_strings{$ft});     # cut off |
#print STDERR "test-  chopped  FI_strings{$ft} = $FI_strings{$ft} \n";	
  }

  my $match = 0;
  foreach $hk (keys %FI_headers) {
    foreach $fk (keys %FI_strings) {
      if ( $FI_headers{$hk} =~ m/$FI_strings{$fk}/i ) {
	$match = 1;
#print STDERR "FI_headers{$hk} = $FI_headers{$hk}   FI_strings{$fk} = $FI_strings{$fk}  \n";	
      }
    }
  }


  #- skip mail if headers match filter criteria
  if ($match == 1) { 
    return( $matched ); 
  } else{
    return( $n_matched );
  }
}


#---------------#------------#-------------#------------#--------------
my @readMails = ();
my $Path2ReadArrays = "ReadMail/";


sub readReadArray {
  my ($user, $msgid) = @_;

  open ARR, "${Path2ReadArrays}${user}.read";
  
  @readMails = <ARR>;
  
  close(ARR);
}

sub msgidInReadArray {
  my ($msgid) = @_;

  if ( defined( $readMails{$msgid} ) ) {
    return 1;
  } else {
    return 0;
  }
}

#-------------------------------------------------------------------

1; # rueckgabe


#-------------------------------------------------------------------



