#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#


package ZwapTools;

require "../../shared_modules/M_user.pm";
require "../../shared_modules/M_session.pm";
require "../../shared_modules/M_instantext.pm";
require "../../shared_modules/M_aliases.pm";
require "../../shared_modules/M_filters.pm";
require "../../shared_modules/M_signature.pm";


#------------------------------------------------------



#######################################################
#
#    Daten User-DB
#
#######################################################

sub getPOPdata {
  my (
      $UserDB_DSN,
      $UserDB_USER,
      $UserDB_PASSWD,
      $ID,
      $serverNo
     ) = @_;
  
  my $POP3server = undef;
  my $POP3account = undef;

  my $UserDbh = M_user::connectDB( 
				  $UserDB_DSN,
				  $UserDB_USER,
				  $UserDB_PASSWD
				 );
  if ($UserDbh) {
    #-- ID = ZWAPuser
    #--      POP3Server, POP3account fuer ZWAPuser holen, merken
    ($POP3server, $POP3account, $emailAdr) = M_user::getPOP( $UserDbh, $ID, $serverNo);

    M_user::disconnectDB( $UserDbh);

    return ($POP3server, $POP3account, $emailAdr);

  } else {
    return (undef, undef);
  }
}


sub getGUIdata {
  my (
      $UserDB_DSN,
      $UserDB_USER,
      $UserDB_PASSWD,
      $ID
     ) = @_;
  

  my $GUI_lang_def = 'EN';  #-default: englisch
  my $GUI_small_def = 'S';  #-default: kleinSchrift

  my $UserDbh = M_user::connectDB( 
				  $UserDB_DSN,
				  $UserDB_USER,
				  $UserDB_PASSWD
				 );
  if ($UserDbh) {
    #-- ID = ZWAPuser
    #--     GUI_lang, GUI_small fuer ZWAPuser holen, merken
    @row = M_user::getGUIdata( $UserDbh, $ID);

    M_user::disconnectDB( $UserDbh);
  }

  if( defined( @row) ) {
    return( @row);
  } else {
    return( $GUI_lang_def, $GUI_small_def);
  }
}


#------------------------------
sub userValid {
  my (
      $UserDB_DSN,
      $UserDB_USER,
      $UserDB_PASSWD,
      $ID,
      $P
     ) = @_;

  my $valid = 0;

  my $UserDbh = M_user::connectDB( 
				  $UserDB_DSN,
				  $UserDB_USER,
				  $UserDB_PASSWD
				 );

  if ($UserDbh) {
    $valid = M_user::auth( $UserDbh, $ID, $P);
    M_user::disconnectDB( $UserDbh);
  }
  return($valid);
}

#------------------------------
sub getDefaultFilterType {
  my (
      $UserDB_DSN,
      $UserDB_USER,
      $UserDB_PASSWD,
      $ID
     ) = @_;
  

  my $fiType_def = 'N';  #- none

  my $UserDbh = M_user::connectDB( 
				  $UserDB_DSN,
				  $UserDB_USER,
				  $UserDB_PASSWD
				 );
  if ($UserDbh) {
    #-- ID = ZWAPuser
    #--     fi_global fuer ZWAPuser holen, merken
    $fiType = M_user::getDefFilterType( $UserDbh, $ID);
    M_user::disconnectDB( $UserDbh);
  }

  if( defined( $fiType) ) {
    return( $fiType);
  } else {
    return( $fiType_def);
  }
}








#######################################################
#
#    Daten Session-DB
#
#######################################################


sub getSessIDfromID {
  my (
      $SessDB_DSN,
      $SessDB_USER,
      $SessDB_PASSWD,
      $ID
     ) = @_;

  my $dbh = M_session::connectDB( 
				  $SessDB_DSN,
				  $SessDB_USER,
				  $SessDB_PASSWD
				 );
  if ($dbh) {
    my $ID = M_session::getSessionFromID( $dbh, $ID);
    M_session::disconnectDB( $dbh);
    return( $ID);
  }
  return(undef);
}


#-------------------------------------------- 
sub getGlobalFilterCFGfromSession {
  my (
      $SessDB_DSN,
      $SessDB_USER,
      $SessDB_PASSWD,
      $SessID
     ) = @_;

  my $dbh = M_session::connectDB( 
				  $SessDB_DSN,
				  $SessDB_USER,
				  $SessDB_PASSWD
				 );
  if ($dbh) {
    my $FI = M_session::getFilterCFGfromSession( $dbh, $SessID);
    M_session::disconnectDB( $dbh);
    return( $FI);
  }
  return(undef);
}

#--------------------------------------
sub saveGlobalFilterCFGtoSession {
  my (
      $SessDB_DSN,
      $SessDB_USER,
      $SessDB_PASSWD,
      $SessID,
      $FI
     ) = @_;

  my $dbh = M_session::connectDB( 
				  $SessDB_DSN,
				  $SessDB_USER,
				  $SessDB_PASSWD
				 );
  if ($dbh) {
    my $OK = M_session::saveFilterCFGtoSession( $dbh, $SessID, $FI);
    M_session::disconnectDB( $dbh);
  }
  return( $OK );
}





#######################################################
#
#    Daten Email-DB  (Aliases, InstanText, Filters)
#
#######################################################


#-----------------------
sub getInstanTexts {
  my (
      $EmailDB_DSN,
      $EmailDB_USER,
      $EmailDB_PASSWD,
      $ID,
      $texts
     ) = @_;

  my $dbh = M_instantext::connectDB( 
				  $EmailDB_DSN,
				  $EmailDB_USER,
				  $EmailDB_PASSWD
				 );
  if ($dbh) {
    M_instantext::getInstanTexts( $dbh, $ID, $texts);
    M_instantext::disconnectDB( $dbh);
  }
}

#-----------------------
sub getMailAliases {
  my (
      $EmailDB_DSN,
      $EmailDB_USER,
      $EmailDB_PASSWD,
      $ID,
      $tos
     ) = @_;

  my $dbh = M_aliases::connectDB( 
				  $EmailDB_DSN,
				  $EmailDB_USER,
				  $EmailDB_PASSWD
				 );
  if ($dbh) {
    M_aliases::getMailAliases( $dbh, $ID, $tos);
    M_aliases::disconnectDB( $dbh);
  }
}

#-----------------------
sub getMailFilters {
  my (
      $EmailDB_DSN,
      $EmailDB_USER,
      $EmailDB_PASSWD,
      $ID,
      $filters,
      $types,
      $targets,
      $actives
     ) = @_;

  my $dbh = M_filters::connectDB( 
				  $EmailDB_DSN,
				  $EmailDB_USER,
				  $EmailDB_PASSWD
				 );
 
 if ($dbh) {
    M_filters::getMailFilters( $dbh, $ID, $filters, $types, $targets, $actives, 0);
    M_filters::disconnectDB( $dbh);
  }
}

#---------------------------
sub getdefinedFilterTypes {
  my (
      $EmailDB_DSN,
      $EmailDB_USER,
      $EmailDB_PASSWD,
      $ID
     ) = @_;

  my $excl = 0;
  my $incl = 0;

  my %filters  = ();
  my %types    = ();
  my %targerts = ();
  my %actives  = ();

  getMailFilters( 
		 $EmailDB_DSN,
		 $EmailDB_USER,
		 $EmailDB_PASSWD,
		 $ID,
		 \%filters,
		 \%types,
		 \%targets,
		 \%actives
		);
  
  foreach  $t (sort (keys %filters)) {
    if ( $types{$t} eq "X")  { $excl = 1;}
    if ( $types{$t} eq "I")  { $incl = 1;}
  }

  return( $excl, $incl );
}


#-- are there activated mail filters
sub activeMailFilters {
  my (
      $EmailDB_DSN,
      $EmailDB_USER,
      $EmailDB_PASSWD,
      $ID
     ) = @_;
  
  my %filters  = ();
  my %types    = ();
  my %targerts = ();
  my %actives  = ();

  getMailFilters( 
		 $EmailDB_DSN,
		 $EmailDB_USER,
		 $EmailDB_PASSWD,
		 $ID,
		 \%filters,
		 \%types,
		 \%targets,
		 \%actives
		);
  
  if (keys %filters) {
    return(1);
  }

  return(0);
}



#-----------------------
sub getSignatures {
  my (
      $EmailDB_DSN,
      $EmailDB_USER,
      $EmailDB_PASSWD,
      $ID,
      $signatures
     ) = @_;

  my $dbh = M_signature::connectDB( 
				   $EmailDB_DSN,
				   $EmailDB_USER,
				   $EmailDB_PASSWD
				  );
  if ($dbh) {
    M_signature::getSignatures( $dbh, $ID, $signatures);
    M_signature::disconnectDB( $dbh);
  }
}

#------------------------------------------------------
# rueckgabe

1;

#--------------------- ende ---------------------------
