#!/usr/bin/perl -w
#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#

use CGI;
use Unix::Syslog qw(:macros);
use Unix::Syslog qw(:subs);


#--------------------------
require "wml_email.cfg"; 

require "../../shared_modules/M_session.pm";
require "../../shared_modules/M_user.pm";
require "wml_header.pm";
require "M_pop.pm";
require "M_wmessages.pm";
require "ZwapTools.pm";

#--------------
# in wml_email_config  my $URLbase = "http://matush.wi-inf.uni-essen.de/~mnr/zwap/";
my $URLbase = $wml_email_config::URLbase;
my $readMailURL = "${URLbase}pop3.pl";
my $sendMailURL = "${URLbase}smtp.pl";
my $loginURL = "${URLbase}login.pl";


#-----------------
my $debug = 0;          # debug-meldungen
my $logit = 1;          # sysloggen
$M_session::debug = $debug;
$M_pop::debug = $debug;

#--- fuer UserDB
my $UserDB_DIR      = "../../databases/ZWap-User";
my $UserDB_DSN      = "DBI:CSV:f_dir=$UserDB_DIR";
my $UserDB_USER     = "";
my $UserDB_PASSWD   = "";

#--- fuer SessionDB
my $SessDB_DIR      = "../../databases/ZWap-SessionKeys";
my $SessDB_DSN      = "DBI:CSV:f_dir=$SessDB_DIR";
my $SessDB_USER     = "";
my $SessDB_PASSWD   = "";

$M_pop::SessDB_DIR      = $SessDB_DIR;
$M_pop::SessDB_DSN      = "DBI:CSV:f_dir=$SessDB_DIR";
$M_pop::SessDB_USER     = "";
$M_pop::SessDB_PASSWD   = "";


#--- fuer EmailDB
my $EmailDB_DIR      = "../../databases/ZWap-Email";
my $EmailDB_DSN      = "DBI:CSV:f_dir=$EmailDB_DIR";
my $EmailDB_USER     = "";
my $EmailDB_PASSWD   = "";

$M_pop::EmailDB_DIR      = $EmailDB_DIR;
$M_pop::EmailDB_DSN      = "DBI:CSV:f_dir=$EmailDB_DIR";
$M_pop::EmailDB_USER     = "";
$M_pop::EmailDB_PASSWD   = "";




#---------------------------------
my $RET = 99;
my $anzahl = $wml_email_config::anzahl;    # Anzahl dargestellter MailHeader
my $anzLines = $wml_email_config::anzlines;    # Anzahl dargestellter MailZeilen

#---------------------------------------------------------
my $query = new CGI;

#-- welcher Client ruft an?
my $WapDevice = $ENV{"HTTP_USER_AGENT"};

#---------------------------------------------------------
#    in PATH_INFO:
#        sessID
#        ID
#
#
#    als Parameter:
#        action    a       content      sc
#                          showmail     sm
#        start  
#        end    
#      
#        msgID                  - bei Anzeige der Mail
#
#---------------------------------------------------------

my $sessID = "";
my $ID = "";
my $POP3Server = "";
my $POP3account = "";

my $action = $query->param("action");
if ( !defined($action)) { $action = "";}

my $start = $query->param("start");
if ( !defined($start)) { $start = 1;}

my $end = $query->param("end");
if($action eq "showmail") {
  if ( !defined($end)) { $end = $start + $anzLines -1;}
} #else {
#  if ( !defined($end)) { $end = $start + $anzahl -1;}
#}

my $msgID = $query->param("msgID");

#--  sessID und ID aus PATH_INFO holen
my $PATHI = $ENV{"PATH_INFO"};
$PATHI =~ s#^/+(.*)#$1#;     # fuehrende / ab
($sessID,$ID) = split( '/', $PATHI);
if ( !defined($ID)) { $ID = "";}
#------------------------------------------------------------


#-- sysloggen
openlog("zWAP-wml: pop3.pl", LOG_PID, LOG_DAEMON) if $logit;

#--- header schicken
WML_header::printContentType();
WML_header::printDocType();
WML_header::printWmlBegin();


if( $ID ne "" ) {     # name angegeben

  #-- Sprache, Schriftart  aus UserDB lesen
  ($GUI_language, $GUI_Font) = ZwapTools::getGUIdata(
				       $UserDB_DSN,
				       $UserDB_USER,
				       $UserDB_PASSWD,
				       $ID 
				      );


  
  #-- Session--Datenbank-Verbindung herstellen  
  my $SessDbh = M_session::connectDB(
				     $SessDB_DSN, 
				     $SessDB_USER, 
				     $SessDB_PASSWD
				    );
  if ($SessDbh) { #- SessionDB OK
    #------------------------------------------------------------

    #-- session pruefen, popdaten holen, passwd holen
    my $sessIDvalid = M_session::validID( $SessDbh, $sessID);
    if( $sessIDvalid) {

      #-- update session timeout 
      M_session::updateSessID( $SessDbh, $sessID);
      
      #-- passwort und serverno aus session lesen
      my ($P,$serverNo) = M_session::getPWSessID( $SessDbh, $sessID);
      
      #------------- POPdaten holen, user auth. ----------------------------
      ($POP3server, $POP3account) = 
	ZwapTools::getPOPdata( 
			      $UserDB_DSN,
			      $UserDB_USER,
			      $UserDB_PASSWD,
			      $ID,
			      $serverNo        
			     );
      if ( defined($POP3server) && defined($POP3account) ) {
	$RET = 1;
      } else {           # keine POP-daten definiert
	$RET = 99;
      }

      #------------ auth OK -----------------------------------
      if ( $RET == 1 ) {      # user und pw OK
	if ( defined($P) ) {  #-- session hatte passwort

	  #-- alles OK, jetzt action bearbeiten
#>>>>>>>>>          
	  if ($action eq "content"){ #--  MailVerzeichnis anzeigen

	    # $sessID, $ID, $readMailURL, 
	    # $P, $POP3server, $POP3account, 
	    # $start     : startindex 
	    # $anzahl    : anzahl der mails im display
	    p_content(
		      $sessID, $ID, $loginURL, $readMailURL, 
		      $P, $POP3server, $POP3account, 
		      $start, $anzahl 
		     );    
      	    
	    #-- update session timeout 
	    M_session::updateSessID( $SessDbh, $sessID);
	    

#>>>>>>>>>>
	  } elsif ( $action eq "showmail") { #-- Mail anzeigen

	    if ( defined( $msgID)) {

	      # sessID, ID, loginURL, readMailURL, 
	      # P, POP3server, POP3account, 
	      # start, end, msgID
	      p_mail( 
		     $sessID, $ID, $loginURL, $readMailURL, 
		     $P, $POP3server, $POP3account, 
		     $start, $end, $msgID 
		    );    

	      #-- update session timeout 
	      M_session::updateSessID( $SessDbh, $sessID);
	    

	    } else {

	      #- Texte sprachabhaengig auslesen
	      $CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
	      $CardText = M_Wmessages::getText( $GUI_language,"C_NO_MSGID");
	      #- Variablen in $CardT* aufloesen
	      $CardTitle =~ s/(\$\w+)/$1/eeg; 
	      $CardText =~ s/(\$\w+)/$1/eeg; 
	      
	      WML_header::printErrorCard( 1,
					  "main",
					  $CardTitle,
					  $CardText
					);
	    }

#>>>>>>>>>>
	  } elsif ( $action eq "cfgfilter") { #-- Mail Filter config

	      # sessID, ID, readMailURL 
	      p_config_mailfilter( $sessID, $ID, $readMailURL );    

	      #-- update session timeout 
	      M_session::updateSessID( $SessDbh, $sessID);

#>>>>>>>>>>
	  } elsif ( $action eq "setfilter") { #-- Mail Filter set

	    my $FI = $query->param("fi");

	    #- save FilterCFG to Session
	    M_session::saveFilterCFGtoSession( $SessDbh, $sessID, $FI);

	    #- show filtered mail list, starting at mail no 1
	    p_content(
		      $sessID, $ID, $loginURL, $readMailURL, 
		      $P, $POP3server, $POP3account, 
		      1, $anzahl 
		     );    

	    #-- update session timeout 
	    M_session::updateSessID( $SessDbh, $sessID);


#>>>>>>>>>>
	  } else {   #-- action ist leer oder unbekannt
	    
	    #- Texte sprachabhaengig auslesen
	    $CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
	    $CardText = M_Wmessages::getText( $GUI_language,"C_NO_ACTION");
	    #- Variablen in $CardT* aufloesen
	    $CardTitle =~ s/(\$\w+)/$1/eeg; 
	    $CardText =~ s/(\$\w+)/$1/eeg; 
	    
	    WML_header::printErrorCard( 1,
					"main",
					$CardTitle,
					$CardText
				      );
	  } 
	  #----- fertig mit actionBearbeitung

	  
	} else {  # ! defined $P

	  #-- und ausloggen
	  M_session::deleteSessID( $SessDbh, $sessID);
	  syslog( LOG_INFO, "member $ID logoff. (no password)") if $logit;

	  #- Texte sprachabhaengig auslesen
	  $CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
	  $CardText = M_Wmessages::getText( $GUI_language,"C_NO_PWFOUND");
	  #- Variablen in $CardT* aufloesen
	  $CardTitle =~ s/(\$\w+)/$1/eeg; 
	  $CardText =~ s/(\$\w+)/$1/eeg; 
	  
	  WML_header::printErrorCard( 1,
				      "main",
				      $CardTitle,
				      $CardText
				    );
	}
	
      } else { # $RET == 1

	#- Texte sprachabhaengig auslesen
	$CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
	$CardText = M_Wmessages::getText( $GUI_language,"C_NO_POPSERVER");
	#- Variablen in $CardT* aufloesen
	$CardTitle =~ s/(\$\w+)/$1/eeg; 
	$CardText =~ s/(\$\w+)/$1/eeg; 
	
	WML_header::printErrorCard( 1,
				    "main",
				    $CardTitle,
				    $CardText
				  );
      }
    } else {    # ! $sessIDvalid

      #- Texte sprachabhaengig auslesen
      $CardTitle = M_Wmessages::getText( $GUI_language,"T_CLOSED");
      $CardText = M_Wmessages::getText( $GUI_language,"C_NO_SESSION");
      #- Variablen in $CardT* aufloesen
      $CardTitle =~ s/(\$\w+)/$1/eeg; 
      $CardText =~ s/(\$\w+)/$1/eeg; 
      
      WML_header::printErrorCard( 1,
				  "main",
				  $CardTitle,
				  $CardText
				);
    }
   
    #-- sessionDB schliessen
    M_session::disconnectDB( $SessDbh); 

  } else {    # ! $SessDbh

    #- Texte sprachabhaengig auslesen
    $CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
    $CardText = M_Wmessages::getText( $GUI_language,"C_NO_SESSIONDB_CONNECT");
    #- Variablen in $CardT* aufloesen
    $CardTitle =~ s/(\$\w+)/$1/eeg; 
    $CardText =~ s/(\$\w+)/$1/eeg; 
    
    WML_header::printErrorCard( 1,
				"main",
				$CardTitle,
				$CardText
			      );

    syslog( LOG_INFO, "sessionDB connect failed") if $logit;
  }
  
} else { # $NE eq ""

  $GUI_language = $GUI_language_def;

  #- Texte sprachabhaengig auslesen
  $CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
  $CardText = M_Wmessages::getText( $GUI_language,"C_NO_USERNAME");
  #- Variablen in $CardT* aufloesen
  $CardTitle =~ s/(\$\w+)/$1/eeg; 
  $CardText =~ s/(\$\w+)/$1/eeg; 
  
  WML_header::printErrorCard( 1,
			      "main",
			      $CardTitle,
			      $CardText
			    );
} 


#-- wml am ende
WML_header::printWmlEnd();

#-- sysloggen beenden
closelog() if $logit;

#---------------------- ende ---------------------




#--------------------- subs ----------------------

sub p_content {   # sessID, ID, loginURL, readMailURL, P, popserver, popaccount, start, anzahl
  my ($sessID, $ID, 
      $loginURL, $readMailURL, 
      $P, $POP3server, $POP3account, 
      $start, $mail_cnt) = @_;

  WML_header::printTemplate();
  WML_header::printCardBegin( "main", "zWAP-mail");

  my $new_start = 0;

  #--- die ersten Mail-header anzeigen, logoff-button, next-button

  #- entrys     -> Referenz auf Array
  #- count      -> Anzahl der Eintraege in entrys
  #- num        -> Anzahl der Mails auf dem Server
  #- new_start  -> neuer startindex der mailliste
  ($entrys, $count, $num, $new_start) =
    M_pop::getList( $ID, $POP3server, $POP3account, $P, 
		    $start, $mail_cnt);
  
#  if( $num > 0) {
  if( $count > 0) {
    
    my $mailstart = 1;
    my $mailend = $mailstart + $anzLines -1;     # Anzahl der gezeigten Zeilen der Mail (split)

    my $from = "";
    my $subject = "";
    my $msgID = "";

    print "<small>\n" if $GUI_Font eq 'S';

    for( $i=0; $i < $count; $i++) {
      #		  print "ID: $entrys->[$i][0] \n";
      #		  print "From: $entrys->[$i][1] \n";
      #		  print "Subject: $entrys->[$i][2] \n";
      #		  print "Size: $entrys->[$i][3] \n";
      #		  print "Datum: $entrys->[$i][4] \n";



#      $from = WML_header::encode2wml( M_pop::filterFromLine( $entrys->[$i][1]));
      $from = M_pop::filterFromLine( $entrys->[$i][1]);
#      $subject = WML_header::encode2wml( $entrys->[$i][2]);
      $subject = $entrys->[$i][2];
      $date = $entrys->[$i][4];
      $msgID = $entrys->[$i][0];

      # hier from, subject entspr. dem device ($WAPclient) formatieren

#----------------- TEST -----------------

#------ auf 15 Zeichen begrenzen ------- kleine Schrift !!!

      if( length( $subject) > 15 ) {
	$subject = substr( $subject, 0, 15);
#	$subject = $subject . "...";
      }

      if( length( $from) > 15 ) {
	$from = substr( $from, 0, 15);
#	$from = $from . "...";
      }
      if( length( $date) > 17 ) {
	$date = substr( $date, 0, 17);
      }

#----------------- TEST ENDE ------------



#      print "D:${date}<br/>\n";
#      print "-${from}<br/>\n";                         # from
#      print "<a href=\"$readMailURL/${sessID}/${ID}?action=showmail\&amp;start=${mailstart}\&amp;end=${mailend}\&amp;msgID=${msgID}\"> ${subject}</a><br/>\n"; 


      #- better show all string as CDATA-section ??

      #-- CDATA 
#      my $startCDATA = "<![CDATA[ ";
#      my $endCDATA   = " ]]>";
      my $startCDATA = "";
      my $endCDATA   = "";

    # fiter dollar-sign from subject
    $subject =~ s/[\$]//;

      print "${startCDATA}-${from}${endCDATA}<br/>\n";                         # from
      print "<a href=\"$readMailURL/${sessID}/${ID}?action=showmail\&amp;start=${mailstart}\&amp;end=${mailend}\&amp;msgID=${msgID}\">${startCDATA}${subject}${endCDATA}</a><br/>\n"; 

    }

    print "</small>\n" if $GUI_Font eq 'S';
    
    if ( $num >= $new_start) {  # more mails?
      $start = $new_start;      # set start index 
      #- next-button
      WML_header::nextButton( $readMailURL, $sessID, $ID, $start, $GUI_language);
    }

  } else {
    $CardText = M_Wmessages::getText( $GUI_language,"C_NOMAIL");
    #- Variablen in $CardT* aufloesen
    $CardText =~ s/(\$\w+)/$1/eeg;     

    print "$CardText \n";
  }

  #- config-filter-button, only if filters defined
  my $defined_filter = ZwapTools::activeMailFilters(
						    $EmailDB_DSN,
						    $EmailDB_USER,
						    $EmailDB_PASSWD,
						    $ID
						   );

  if ($defined_filter == 1) {
    WML_header::cfgfilterButton( $readMailURL, $sessID, $ID, $GUI_language );
  }

  #- writemail-button
  WML_header::writemailButton( $sendMailURL, $sessID, $ID, $GUI_language);

  #- logoff-button
  WML_header::logoffButton( $loginURL, $sessID, $ID, $GUI_language);
  
  WML_header::printCardEnd();
}


#------------------------------------------
sub p_mail {   # sessID, ID, 
               # loginURL, readMailURL, 
               # P, popserver, popaccount, 
               # start, end, msgID
  my ($sessID, $ID, 
      $loginURL, $readMailURL, 
      $P, $POP3server, $POP3account, 
      $mailstart, $mailend,
      $msgID
     ) = @_;
  
  #--- die ersten Mail-Zeile anzeigen, logoff-button, nextLines-button, Inhalt-Button
  #- lines   -> Referenz auf Array mit Zeilen der Mail
  #- heads   -> zB from, subject, date
  #- count   -> Anzahl der Eintraege in lines
  #- num     -> gesamtAnzahl der Zeilen der Mail
  ($lines, $heads, $count, $num) =
    M_pop::readMail( $POP3server, $POP3account, $P, 
		     $mailstart,$mailend,$msgID);
  
  WML_header::printTemplate();

  my $from = M_pop::filterFromLine( $heads->[0]);
  WML_header::printCardBegin( "main", $from);

  #- beim ersten Teil der Mail subject, datum ausgeben
  if( $mailstart == 1) {
    $subject = $heads->[1];
    $date = $heads->[2]; 
    $replyto = $heads->[3];


    # fiter dollar-sign from subject
    $subject =~ s/[\$]//;



    print "<small>\n" if $GUI_Font eq 'S';
    print "<i>** date **</i><br/><![CDATA[ ${date} ]]><br/><i>** subject: **</i><br/><b><![CDATA[ ${subject} ]]></b><br/><i>** message: **</i><br/>\n";
    print "</small>\n" if $GUI_Font;
  }

  if( $num > 0) { #-- MailContent ungeparsed ausgeben

    print "<small>\n" if $GUI_Font eq 'S';
    print "<![CDATA[";   #- in unparsed-mode schalten

    $str = "";
    for( $i=0; $i <= $count; $i++) {

      # hier Zeile entspr. dem device ($WAPclient) formatieren
      $str = $lines->[$i];

      print "$str \n";
    }
    print "]]>";   #- unparsed-mode ausschalten
    print "</small>\n" if $GUI_Font eq 'S';
    

    if ( $num > $mailend) {  # noch mehr zeilen in der mail?
      $mailstart += $count;    ########  nur soweit springen, wie Zeilen ausgelesen wurden
      $mailend = $mailstart + $anzLines -1;
      
      #- next-button
      WML_header::nextLinesButton( $readMailURL, $sessID, $ID, 
				   $mailstart, $mailend, $msgID, 
				   $GUI_language
				 );
    }

  } else {
    $CardText = M_Wmessages::getText( $GUI_language,"C_MAILEMPTY");
    #- Variablen in $CardT* aufloesen
    $CardText =~ s/(\$\w+)/$1/eeg;     

    print "$CardText \n";
  }

  #- replyto-button
  $r_to   = $from;
  # check for Reply-To:
  if ( $replyto) { $r_to = $replyto; }
  #

  WML_header::replyButton( $sendMailURL, $sessID, $ID,$GUI_language,$r_to,$subject );

  #- logoff-button
  WML_header::logoffButton( $loginURL, $sessID, $ID, $GUI_language);

  #- Content-button
  WML_header::contentButton( $readMailURL, $sessID, $ID, 1, $anzahl, $GUI_language);
  
  WML_header::printCardEnd();
}


#------- wml-card mit auswahl der filter
sub p_config_mailfilter {
  my ($sessID, $ID, $readMailURL) = @_;

  #- get language dependent texts
  my $CardTitle    = M_Wmessages::getText( $GUI_language,"T_CFGFILTER");
  my $CardText     = M_Wmessages::getText( $GUI_language,"C_SELECTFILTER");
  my $Fi_typ_none  = M_Wmessages::getText( $GUI_language,"C_FILTER_NONE");
  my $Fi_typ_excl  = M_Wmessages::getText( $GUI_language,"C_FILTER_EXCL");
  my $Fi_typ_incl  = M_Wmessages::getText( $GUI_language,"C_FILTER_INCL");

  # get mail filters selection from session
  my $FI = ZwapTools::getGlobalFilterCFGfromSession(
						    $SessDB_DSN,
						    $SessDB_USER,
						    $SessDB_PASSWD,
						    $sessID,
						   );

  # which filter types in DB?
  my ($excl, $incl) = ZwapTools::getdefinedFilterTypes(
						       $EmailDB_DSN,
						       $EmailDB_USER,
						       $EmailDB_PASSWD,
						       $ID
						      );
  # fall back, if globally selected filter type isn't defined in DB
  if ( $FI eq "X" && $excl == 0) { $FI = "N"; }
  if ( $FI eq "I" && $incl == 0) { $FI = "N"; }

  WML_header::printTemplate();
  WML_header::printCardBegin( "main", $CardTitle);

  print "${CardText}<br/>\n";

  print "<a href=\"$readMailURL/${sessID}/${ID}?action=setfilter\&amp;fi=N\">" if $FI ne "N";
  print "\> " if $FI eq "N";
  print "${Fi_typ_none}";
  print "</a>" if $FI ne "N";
  print "<br/>\n"; 

  if($excl) { # only if filter of this type exists
    print "<a href=\"$readMailURL/${sessID}/${ID}?action=setfilter\&amp;fi=X\">" if $FI ne "X";
    print "\> " if $FI eq "X";
    print "${Fi_typ_excl}";
    print "</a>" if $FI ne "X";
    print "<br/>\n"; 
  }
  if ($incl) { # only if filter of this type exists
    print "<a href=\"$readMailURL/${sessID}/${ID}?action=setfilter\&amp;fi=I\">" if $FI ne "I";
    print "\> " if $FI eq "I";
    print "${Fi_typ_incl}";
    print "</a>" if $FI ne "I";
    print "<br/>\n"; 
  }
  
  WML_header::printCardEnd();
}


#-----------------------------------------
sub formatLine {
  my ($line,$cpl) = @_;
  my $str = "";
  my $cnt = 0;

  while( ($len = length( $line)) > $cpl) {
    $cnt ++;

    $tmpstr = substr( $line, 0, $cpl);
    $str = $str . $tmpstr . " ";
    $line = substr( $line, $cpl);
  }

  $str = $str . $line;
  
  return( $str );
}


#-------------------- subs ende ---------------------------
