#!/usr/bin/perl -w
#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#

use CGI;
use Net::SMTP;
use Unix::Syslog qw(:macros);
use Unix::Syslog qw(:subs);


#--------------------------
require "wml_email.cfg"; 

require "../../shared_modules/M_session.pm";
require "wml_header.pm";
require "M_wmessages.pm";
require "ZwapTools.pm";

#--------------
# in wml_email_config  my $URLbase = "http://matush.wi-inf.uni-essen.de/~mnr/zwap/";
my $URLbase     = $wml_email_config::URLbase;
my $readMailURL = "${URLbase}pop3.pl";
my $sendMailURL = "${URLbase}smtp.pl";
my $loginURL    = "${URLbase}login.pl";

#-----------------
my $path2sendmail    = $wml_email_config::path2sendmail;
my $sendmail_options = $wml_email_config::sendmail_options;
my $use_smtp         = $wml_email_config::use_smtp;
my $SMTP_server      = $wml_email_config::SMTP_server;

my $standard_footer  = $wml_email_config::standard_footer;

#-----------------
my $debug = 0;          # debug-meldungen
my $logit = 1;          # sysloggen
$M_session::debug = $debug;
#$M_pop::debug = $debug;

#--- fuer DB
my $UserDB_DIR      = "../../databases/ZWap-User";
my $UserDB_DSN      = "DBI:CSV:f_dir=$UserDB_DIR";
my $UserDB_USER     = "";
my $UserDB_PASSWD   = "";

#--- fuer SessionDB
my $SessDB_DIR      = "../../databases/ZWap-SessionKeys";
my $SessDB_DSN      = "DBI:CSV:f_dir=$SessDB_DIR";
my $SessDB_USER     = "";
my $SessDB_PASSWD   = "";

#--- fuer EmailDB
my $EmailDB_DIR      = "../../databases/ZWap-Email";
my $EmailDB_DSN      = "DBI:CSV:f_dir=$EmailDB_DIR";
my $EmailDB_USER     = "";
my $EmailDB_PASSWD   = "";

#---------------------------------
my $RET = 99;
my $anzahl = $wml_email_config::anzahl;    # Anzahl dargestellter MailHeader
my $anzLines = $wml_email_config::anzlines;    # Anzahl dargestellter MailZeilen

#-- Hashes fuer Mail-Adressen und 
#--  vorgefertigte Mail-Inhalte (InstantText)
my %to_aliases = ();
my %instant_texts = ();

#-- vom aktuellen Account schicken
my $sender = "";

#-- fooling cache by unique number
my $cache_fooling = time;

#---------------------------------------------------------
my $query = new CGI;

#-- welcher Client ruft an?
my $WapDevice = $ENV{"HTTP_USER_AGENT"};

#---------------------------------------------------------
#    in PATH_INFO:
#        sessID
#        ID
#        time (unique number for URL)
#
#
#    als Parameter:
#        action    a       writemail
#                          sel_text
#                          inp_addr
#                          editmail
#                          sendmail    
#
#---------------------------------------------------------

my $sessID = "";
my $ID = "";
my $POP3Server = "";
my $POP3account = "";

my $action = $query->param("action");
if ( !defined($action)) { $action = "";}

#--  sessID und ID aus PATH_INFO holen
my $PATHI = $ENV{"PATH_INFO"};
$PATHI =~ s#^/+(.*)#$1#;     # fuehrende / ab
($sessID,$ID) = split( '/', $PATHI);
if ( !defined($ID)) { $ID = "";}
#------------------------------------------------------------


#-- sysloggen
openlog("zWAP-wml: smtp.pl", LOG_PID, LOG_DAEMON) if $logit;

#--- header schicken
WML_header::printContentType();
WML_header::printDocType();
WML_header::printWmlBegin();


if( $ID ne "" ) {     # name angegeben

  #-- Sprache, Schriftart  aus UserDB lesen
  ($GUI_language, $GUI_Font) = ZwapTools::getGUIdata(
				       $UserDB_DSN,
				       $UserDB_USER,
				       $UserDB_PASSWD,
				       $ID 
				      );
  #--  Hash fuer vorgefertigte Mail-Inhalte (InstantText)
  ZwapTools::getInstanTexts( 
			 $EmailDB_DSN,
			 $EmailDB_USER,
			 $EmailDB_PASSWD,
			 $ID,
			 \%instant_texts
			);

  #-- Hash fuer Mail-Adressen und 
  ZwapTools::getMailAliases( 
			 $EmailDB_DSN,
			 $EmailDB_USER,
			 $EmailDB_PASSWD,
			 $ID,
			 \%to_aliases
			);


  #-- Session--Datenbank-Verbindung herstellen  
  my $SessDbh = M_session::connectDB(
				     $SessDB_DSN, 
				     $SessDB_USER, 
				     $SessDB_PASSWD
				    );
  if ($SessDbh) { #- SessionDB OK
    #------------------------------------------------------------

    #-- session pruefen, popdaten holen, passwd holen
    my $sessIDvalid = M_session::validID( $SessDbh, $sessID);
    if( $sessIDvalid) {

      #-- update session timeout 
      M_session::updateSessID( $SessDbh, $sessID);
      
#      #-- passwort und serverno aus session lesen
#      my ($P,$serverNo) = M_session::getPWSessID( $SessDbh, $sessID);
      
      #------------- POPdaten holen, user auth. ----------------------------
      ($POP3server, $POP3account, $emailAdr) = 
	ZwapTools::getPOPdata( 
			      $UserDB_DSN,
			      $UserDB_USER,
			      $UserDB_PASSWD,
			      $ID,
			      $serverNo        
			     );
      if ( defined($POP3server) && defined($POP3account) ) {
	$RET = 1;
      } else {           # keine POP-daten ( Absender )definiert
	$RET = 99;
      }

      #------------ auth OK -----------------------------------
      if ( $RET == 1 ) {      # user und pw OK
#	if ( defined($P) ) {  #-- session hatte passwort
	if ( 1) {  # pw fuer smtp nicht noetig


	  #-- vom aktuellen Account schicken
#	  $sender = "${POP3account}\@${POP3server}";
	  $sender = $emailAdr;

	  #-- update session timeout 
	  M_session::updateSessID( $SessDbh, $sessID);

#>>>>>>>>>>
	  if ( $action eq "writemail") {     #-- get started 
	                                     #-- and select recipient(s)

	    p_writemail( $sessID, $ID);

	    #-- update session timeout 
	    M_session::updateSessID( $SessDbh, $sessID);

#>>>>>>>>>>
	  } elsif ( $action eq "inp_addr") { #-- input mailaddr

	    p_inp_addr( $sessID, $ID );

	    #-- update session timeout 
	    M_session::updateSessID( $SessDbh, $sessID);


#>>>>>>>>>>
	  } elsif ( $action eq "sel_text") { #-- select InstantText

	    my $tn = $query->param("tn");
	    if ( !defined($tn)) { $tn = "";}
	    my $to = $query->param("to");
	    if ( !defined($to)) { $to = "";}

	    p_sel_text( $sessID, $ID, "$tn", "$to" );

	    #-- update session timeout 
	    M_session::updateSessID( $SessDbh, $sessID);
	    
#>>>>>>>>>>
	  } elsif ( $action eq "editmail") { #-- edit mail text
	 
	    my $tn = $query->param("tn");
	    if ( !defined($tn)) { $tn = "";}
	    my $tx = $query->param("tx");
	    if ( !defined($tx)) { $tx = "";}
	    my $to = $query->param("to");
	    if ( !defined($to)) { $to = "";}

	    #-- update session timeout 
	    M_session::updateSessID( $SessDbh, $sessID);

	    p_editMail( $sessID, $ID, $tn, $tx, $to, $sender, "" );
	    
	    #-- update session timeout 
	    M_session::updateSessID( $SessDbh, $sessID);

#>>>>>>>>>>
	  } elsif ( $action eq "replymail") { #-- reply to mail
	 
	    my $to = $query->param("to");
	    if ( !defined($to)) { $to = "";}
	    my $subj = $query->param("subj");
	    if ( !defined($subj)) { $subj = "";}

	    # keine aliases, InstanText
	    $tn = "";
	    $tx = "";

	    #-- update session timeout 
	    M_session::updateSessID( $SessDbh, $sessID);

	    p_editMail( $sessID, $ID, $tn, $tx, $to, $sender, $subj );
	    
	    #-- update session timeout 
	    M_session::updateSessID( $SessDbh, $sessID);


#>>>>>>>>>>
	  } elsif ( $action eq "sendmail") { #-- deliver mail

	    if ( 
		p_sendMail( 
			   $ID,
			   $query->param("tn"),
			   $query->param("to"),
			   $query->param("from"), 
			   $query->param("s"),
			   $query->param("cont")
			  ) 
	       ) {

	      #-- update session timeout 
	      M_session::updateSessID( $SessDbh, $sessID);

	      #- Texte sprachabhaengig auslesen
	      $CardTitle = M_Wmessages::getText( $GUI_language,"T_MESSAGE");
	      $CardText = M_Wmessages::getText( $GUI_language,"C_MAILSENT");
	      #- Variablen in $CardT* aufloesen
	      $CardTitle =~ s/(\$\w+)/$1/eeg; 
	      $CardText =~ s/(\$\w+)/$1/eeg; 

	      WML_header::printTemplate();
	      WML_header::printCardBegin( "main", $CardTitle);

	      print $CardText;

	      #- editmail-button
	      WML_header::writemailButton( $sendMailURL, $sessID, $ID, $GUI_language);
	      #- logoff-button
	      WML_header::logoffButton( $loginURL, $sessID, $ID, $GUI_language);
	      #- Content-button
	      WML_header::contentButton( $readMailURL, $sessID, $ID, 1, $anzahl, $GUI_language);
	      
	      WML_header::printCardEnd();

	    } else {
	      #-- update session timeout 
	      M_session::updateSessID( $SessDbh, $sessID);

	      #- Texte sprachabhaengig auslesen
	      $CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
	      $CardText = M_Wmessages::getText( $GUI_language,"C_NO_MAILSENT");
	      #- Variablen in $CardT* aufloesen
	      $CardTitle =~ s/(\$\w+)/$1/eeg; 
	      $CardText =~ s/(\$\w+)/$1/eeg; 

	      WML_header::printTemplate();
	      WML_header::printCardBegin( "main", $CardTitle);

	      print $CardText;

	      #- editmail-button
	      WML_header::writemailButton( $sendMailURL, $sessID, $ID, $GUI_language);
	      #- logoff-button
	      WML_header::logoffButton( $loginURL, $sessID, $ID, $GUI_language);
	      #- Content-button
	      WML_header::contentButton( $readMailURL, $sessID, $ID, 1, $anzahl, $GUI_language);
	      
	      WML_header::printCardEnd();
	    }


#>>>>>>>>>>
	  } else {   #-- action ist leer oder unbekannt

	    #- Texte sprachabhaengig auslesen
	    $CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
	    $CardText = M_Wmessages::getText( $GUI_language,"C_NO_ACTION");
	    #- Variablen in $CardT* aufloesen
	    $CardTitle =~ s/(\$\w+)/$1/eeg; 
	    $CardText =~ s/(\$\w+)/$1/eeg; 
	    
	    WML_header::printErrorCard( 1,
					"main",
					$CardTitle,
					$CardText
				      );
	  } 
	  #----- fertig mit actionBearbeitung

	  
	} else {  # ! defined $P

	  #-- und ausloggen
	  M_session::deleteSessID( $SessDbh, $sessID);
	  syslog( LOG_INFO, "member $ID logoff. (no password)") if $logit;

	  #- Texte sprachabhaengig auslesen
	  $CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
	  $CardText = M_Wmessages::getText( $GUI_language,"C_NO_PWFOUND");
	  #- Variablen in $CardT* aufloesen
	  $CardTitle =~ s/(\$\w+)/$1/eeg; 
	  $CardText =~ s/(\$\w+)/$1/eeg; 
	  
	  WML_header::printErrorCard( 1,
				      "main",
				      $CardTitle,
				      $CardText
				    );
	}
	
      } else { # $RET == 1

	#- Texte sprachabhaengig auslesen
	$CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
	$CardText = M_Wmessages::getText( $GUI_language,"C_NO_POPSERVER");
	#- Variablen in $CardT* aufloesen
	$CardTitle =~ s/(\$\w+)/$1/eeg; 
	$CardText =~ s/(\$\w+)/$1/eeg; 
	
	WML_header::printErrorCard( 1,
				    "main",
				    $CardTitle,
				    $CardText
				  );
      }
    } else {    # ! $sessIDvalid

      #- Texte sprachabhaengig auslesen
      $CardTitle = M_Wmessages::getText( $GUI_language,"T_CLOSED");
      $CardText = M_Wmessages::getText( $GUI_language,"C_NO_SESSION");
      #- Variablen in $CardT* aufloesen
      $CardTitle =~ s/(\$\w+)/$1/eeg; 
      $CardText =~ s/(\$\w+)/$1/eeg; 
      
      WML_header::printErrorCard( 1,
				  "main",
				  $CardTitle,
				  $CardText
				);
    }
   
    #-- sessionDB schliessen
    M_session::disconnectDB( $SessDbh); 

  } else {    # ! $SessDbh

    #- Texte sprachabhaengig auslesen
    $CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
    $CardText = M_Wmessages::getText( $GUI_language,"C_NO_SESSIONDB_CONNECT");
    #- Variablen in $CardT* aufloesen
    $CardTitle =~ s/(\$\w+)/$1/eeg; 
    $CardText =~ s/(\$\w+)/$1/eeg; 
    
    WML_header::printErrorCard( 1,
				"main",
				$CardTitle,
				$CardText
			      );

    syslog( LOG_INFO, "sessionDB connect failed") if $logit;
  }
  
} else { # $NE eq ""

  $GUI_language = $GUI_language_def;

  #- Texte sprachabhaengig auslesen
  $CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
  $CardText = M_Wmessages::getText( $GUI_language,"C_NO_USERNAME");
  #- Variablen in $CardT* aufloesen
  $CardTitle =~ s/(\$\w+)/$1/eeg; 
  $CardText =~ s/(\$\w+)/$1/eeg; 
  
  WML_header::printErrorCard( 1,
			      "main",
			      $CardTitle,
			      $CardText
			    );
} 


#-- wml am ende
WML_header::printWmlEnd();

#-- sysloggen beenden
closelog() if $logit;

#---------------------- ende ---------------------




#--------------------- subs ----------------------

sub p_writemail {      # 

  my ($sessID, $ID) = @_;


  #-- no aliases available, get MailAddr
  if ( (keys %{to_aliases}) == 0) {
    p_inp_addr( $sessID, $ID);
    return;
  }

  $CardTitle = M_Wmessages::getText( $GUI_language,"T_WRITEMAIL");
  $CardText = M_Wmessages::getText( $GUI_language,"NL_GETINPUT");


  WML_header::printTemplate();
  WML_header::printCardBegin( "main", $CardTitle);

  print "<a href=\"./${ID}/${cache_fooling}?action=inp_addr\">${CardText}</a><br/>\n";


  foreach $t (sort keys %to_aliases) {
    #-- hier wird "to" nicht benoetigt
#    print "<a href=\"${sendMailURL}/${sessID}/${ID}/${cache_fooling}?action=sel_text&amp;tn=${t}\">$t</a><br/>\n";


    # mit browser-var
    print "<a href=\"./${ID}/${cache_fooling}?action=sel_text&amp;tn=${t}\">$t</a><br/>\n";
  }


    
  #-- standard navigation
  #- logoff-button
  WML_header::logoffButton( $loginURL, $sessID, $ID, $GUI_language);
  #- Content-button
  WML_header::contentButton( $readMailURL, $sessID, $ID, 1, $anzahl, $GUI_language);

  WML_header::printCardEnd();
}


#-----------------------
sub p_inp_addr {      # 

  my ($sessID, $ID) = @_;

  $CardTitle = M_Wmessages::getText( $GUI_language,"T_INP_ADDR");
  $InputName = M_Wmessages::getText( $GUI_language,"C_TO");
  $LinkName = M_Wmessages::getText( $GUI_language,"NL_NEXT");


  WML_header::printTemplate();
  WML_header::printCardBeginNewContext( "main", $CardTitle); # newcontext !! 


  print "${InputName}<br/><input name=\"to\" value=\"\" title=\"${InputName}\"/><br/>\n";

  #-- hier wird "toNo" nicht benoetigt
  print "<a href=\"./${ID}/${cache_fooling}?action=sel_text&amp;to=\$(to)\">${LinkName}</a><br/>\n";


  #-- standard navigation
  #- logoff-button
  WML_header::logoffButton( $loginURL, $sessID, $ID, $GUI_language);
  #- Content-button
  WML_header::contentButton( $readMailURL, $sessID, $ID, 1, $anzahl, $GUI_language);

  WML_header::printCardEnd();
}




#---------------------
sub p_sel_text {       # select InstantText
  my ($sessID, $ID, $toNo, $to) = @_;


  #-- no InstanTexts available, edit Mail
  if ( (keys %{instant_texts}) == 0) {
    p_editMail( $sessID, $ID, $toNo, "", $to );
    return;
  }

  $CardTitle = M_Wmessages::getText( $GUI_language,"T_SEL_TEXT");
  $CardText = M_Wmessages::getText( $GUI_language,"C_NO_USERNAME");
  $LinkName = M_Wmessages::getText( $GUI_language,"NL_GETINPUT");


  WML_header::printTemplate();
  WML_header::printCardBegin( "main", $CardTitle); # newcontext !! 


  print "<a href=\"./${ID}/${cache_fooling}?action=editmail&amp;to=${to}&amp;tn=${toNo}\">${LinkName}</a><br/>\n";


  foreach $t (sort keys %instant_texts) {
#    print "<a href=\"${sendMailURL}/${sessID}/${ID}/${cache_fooling}?action=editmail&amp;tx=${t}&amp;tn=${toNo}&amp;to=${to}\">${t}</a><br/>\n";
    print "<a href=\"./${ID}/${cache_fooling}?action=editmail&amp;tx=${t}&amp;tn=${toNo}&amp;to=${to}\">${t}</a><br/>\n";
  }


  #-- standard navigation
  #- logoff-button
  WML_header::logoffButton( $loginURL, $sessID, $ID, $GUI_language);
  #- Content-button
  WML_header::contentButton( $readMailURL, $sessID, $ID, 1, $anzahl, $GUI_language);

  WML_header::printCardEnd();
}



#---------------------
sub  p_editMail {      # edit mail text
  my ($sessID, $ID, $toNo, $textNo, $to, $from, $subj) = @_;

  #  if called from replyto, do not use InstanTexts, there's a subject instead
  if ( $textNo eq "") {
    $textNo = $subj;
  }

  my $std_text = $instant_texts{$textNo};

  $CardTitle = M_Wmessages::getText( $GUI_language,"T_EDITMAIL");
  $InputSubjectName = M_Wmessages::getText( $GUI_language,"C_SUBJECT");
  $InputTextName = M_Wmessages::getText( $GUI_language,"C_MAILTEXT");

  WML_header::printTemplate();
  WML_header::printCardBeginNewContext( "main", ${CardTitle}); # newcontext !! 

  print "${InputSubjectName}<input name=\"subj\" title=\"${InputSubjectName}\" value=\"${textNo}\"/>";
  print "${InputTextName}<input name=\"cont\" title=\"${InputTextName}\" value=\"${std_text}\"/>";


  #-- sendmail-button
  WML_header::sendmailButton2( $sendMailURL, $sessID, $ID, $GUI_language, 
			       $sender, $to, $toNo);

  #-- standard navigation
  #- logoff-button
  WML_header::logoffButton( $loginURL, $sessID, $ID, $GUI_language);
  #- Content-button
  WML_header::contentButton( $readMailURL, $sessID, $ID, 1, $anzahl, $GUI_language);

  WML_header::printCardEnd();
}




#---------------------
sub  p_sendMail {
  my ($ID, $toNo, $to, $from, $subject, $content) = @_;

  my $toa = $to_aliases{$toNo};

  #- in $to steht der freie Adress-Eintrag, noch testen, ob gueltige adresse

  #-- get signature from DB
  my $sig = "signature";   # default , by now the only one
                           # may later be fetched from session, or selected 
  my %signatures = ();
  ZwapTools::getSignatures( 
			   $EmailDB_DSN,
			   $EmailDB_USER,
			   $EmailDB_PASSWD,
			   $ID,
			   \%signatures
			  );
  
  #- send mail: sendmail or smtp 
  if ($use_smtp) {    #-- from options-file

    $smtp = Net::SMTP->new($SMTP_server);
    if($smtp) {
      

      return 1;
    }
    
    return 0;
  
  } else {
    open (MAIL,"| ${path2sendmail} ${sendmail_options}") || return(0);
    print MAIL "Subject: ${subject} \n";
    print MAIL "To: ${toa} ${to} \n";
    print MAIL "From: ${from} \n";
    print MAIL "Reply-To: ${from} \n";
    print MAIL "\n\n";
    print MAIL ${content};

    print MAIL "\n--\n" . $signatures{$sig};  # append signature

    print MAIL $standard_footer . "\n";       # standard footer on all mails

    close(MAIL);

    return 1;
  }
}

#-------------------- subs ende ---------------------------
