#!/usr/bin/perl -w
#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#



#-------------------------------------------------------
# daemon zum Managen der SessionIDs
#
#
#-------------------------------------------------------
#
#    Protokoll:
#    ---------------------------------------------------
#    QUIT                   Beenden
#    UPDATEID <SessKey>     TimeStamp hoeher setzen
#    ISVALID <SessKey>      Key noch gueltig?
#    NEWID <user>           neuen Key liefern
#    DELID <SessKey>        Key loeschen
#    USERIN <user>          gibts session fuer User?
#    LIST                   alle Sessions auflisten
#    SETPW <session> <pw>   mail-passwort fuer session merken 
#    GETPW <session>        mail-passwort lesen 
#    HELP
#-------------------------------------------------------

use POSIX;
use IO::Socket;
use DBI;            # fuer Datenbank
use Getopt::Std;
use Unix::Syslog qw(:macros);
use Unix::Syslog qw(:subs);

$debug = 0;
$logit = 1;

#---------------------------------------------
#         fuer die Datenbank
#
my $DB_DIR      = "../databases/ZWap-SessionKeys";
my $DB_TABLE    = "SessionKeys";
my $DB_DSN      = "DBI:CSV:f_dir=$DB_DIR";
my $DB_USER     = "";
my $DB_PASSWD   = "";

#---------------------------------------------
#         fuer den Server
#
my $serverport = 2079;   # Port, auf dem gelauscht wird
my $server = 0;          # Instanz der socket-Klasse
my $clientConnection;    # Verbindung aus accept()

my $time2die = 0;        # daemon beenden (sigint, sigterm, sighup)
my $saveDir ="/tmp/daemon";  # Arbeitsverzeichnis
my $pidFile = "sIDd.pid";

my $Meldung = "SessionKeyManagementServer MnR 20000121\n";
my $helpmessage = "NEWID <user>          neue SessionID erzeugen\
DELID <ID>            SessionID loeschen\
UPDATEID <ID>         Timelimit erneuern\
ISVALID <ID>          gibts die ID?\
USERIN <user>         gibts session fuer user?\
LIST                  welche IDs gibts?\
QUIT                  raus hier\
HELP                  diese Hilfe\
\nREADY\n";


#-----------------------------------------------
#         timeout fuer die SessionID
#
my $idTimeout = 600;       # timeout in sek.
#-----------------------------------------------


#--- in sicheres Verzeichnis wechseln
#chroot(${saveDir}) or die "chroot: can`t change to ${saveDir}\n";

#--- neuen Prozess forken
$pid = fork;
exit if $pid;
die "fork: can`t start new prozess: $!\n" unless defined($pid);

#--- ProzessNr. nach /var/run/NAME schreiben
#open( PFILE, "> $pidFile") or die "cannot open pid file\n";
#print PFILE $$ . "\n";
#close PFILE;

#--- vom kontollierenden Terminal loesen
POSIX:setsid() or die "setsid: \n";

#--- signale abfangen
$SIG{INT} = $SIG{TERM} = $SIG{HUP} = \&signal_handler;

#--- syslog-Verbindung herstellen
openlog("sIDd", LOG_PID, LOG_DAEMON) if $logit;
syslog( LOG_INFO, "sIDd.pl started") if $logit;

#--- Datenbank-Verbindung -----------------------
#- Handle holen
my $dbh = DBI->connect($DB_DSN, $DB_USER, 
              $DB_PASSWD) or die "Cannot connect to DB";


#--- KillerDaemon starten und seine PID merken
# ("sIDkiller.pl");
# my killerPID = 0;

#--- socket erzeugen
$server = IO::Socket::INET->new(LocalPort => $serverport,
				Proto     => 'tcp',
				Type      => SOCK_STREAM,
				Reuse     => 1,
				Listen    => 30)
          or die "can`t start TCP-server on port ${serverport}: $@\n";

  while (($time2die == 0) && ($clientConnection = $server -> accept())) {
    print $clientConnection $Meldung ."\nREADY\n";

    $goon = 1;
    while (($goon == 1) && ($input = <$clientConnection>))
    {
      chop($input);      # wieso 2mal???
      chop($input);


      print $clientConnection "$goon:Eingabe war: |$input|\n" if $debug;


      $command = $parameter = "";
      ($command,$parameter,$wert) = split(/ /,$input);
      if ( !defined $parameter) { $parameter = ""; }
      if ( !defined $wert)      { $wert = ""; }
      if ( !defined($command))  { $command = ""; }

      if ($command eq "NEWID") {
	print $clientConnection "NEWID: |$command|$parameter|\n" if $debug;
	$RET = newID($parameter);
	if ($RET eq "FAIL") {
	  print $clientConnection "FAIL\nREADY\n";
	  syslog( LOG_INFO, "NEWID for %s failed", $parameter) if $logit;
	} else {
	  print $clientConnection $RET . "\nREADY\n";
	  syslog( LOG_INFO, "NEWID for %s OK", $parameter) if $logit;
	}

      } elsif ($command eq "DELID") {
	print $clientConnection "DELID: |$command|$parameter|\n" if $debug;
	$RET = delID($parameter);
	if ($RET eq "FAIL") {
	  print $clientConnection "FAIL\nREADY\n";
	  syslog( LOG_INFO, "DELID %s failed", $parameter) if $logit;
	} else {
	  print $clientConnection  $RET .  "\nREADY\n";
	  syslog( LOG_INFO, "DELID %s OK", $parameter) if $logit;
	}

      } elsif ($command eq "ISVALID") {
	print $clientConnection "ISVALID: |$command|$parameter|\n" if $debug;
	$RET = isvalidID($parameter);
	if ($RET eq "FAIL") {
	  print $clientConnection "FAIL\nREADY\n";
	  syslog( LOG_INFO, "ISVALID %s failed", $parameter) if $logit;
	} else {
	  print $clientConnection  $RET . "\nREADY\n";
	  syslog( LOG_INFO, "ISVALID %s OK", $parameter) if $logit;
	}

      } elsif ($command eq "UPDATEID") {
	print $clientConnection "UPDATEID: |$command|$parameter|\n" if $debug;
	$RET = updateID($parameter);
	if ($RET eq "FAIL") {
	  print $clientConnection "FAIL\nREADY\n";
	  syslog( LOG_INFO, "UPDATEID %s failed", $parameter) if $logit;
	} else {
	  print $clientConnection  $RET . "\nREADY\n";
	  syslog( LOG_INFO, "UPDATEID %s OK", $parameter) if $logit;
	}

      } elsif ($command eq "USERIN") {
	print $clientConnection "USERIN: |$command|$parameter|\n" if $debug;
	$RET = userIn($parameter);
	if ($RET eq "FAIL") {
	  print $clientConnection "FAIL\nREADY\n";
	  syslog( LOG_INFO, "USERIN %s failed", $parameter) if $logit;
	} else {
	  print $clientConnection  $RET . "\nREADY\n";
	  syslog( LOG_INFO, "USERIN %s OK", $parameter) if $logit;
	}

      } elsif ($command eq "SETPW") {
	print $clientConnection "SETPW: |$command|$parameter|$wert|\n" if $debug;
	$RET = setPW($parameter,$wert);
	if ($RET eq "FAIL") {
	  print $clientConnection "FAIL\nREADY\n";
	  syslog( LOG_INFO, "SETPW for %s failed", $parameter) if $logit;
	} else {
	  print $clientConnection  $RET . "\nREADY\n";
	  syslog( LOG_INFO, "SETPW for %s OK", $parameter) if $logit;
	}

      } elsif ($command eq "GETPW") {
	print $clientConnection "GETPW: |$command|$parameter|\n" if $debug;
	$RET = getPW($parameter);
	if ($RET eq "FAIL") {
	  print $clientConnection "FAIL\nREADY\n";
	  syslog( LOG_INFO, "GETPW for %s failed", $parameter) if $logit;
	} else {
	  print $clientConnection  $RET . "\nREADY\n";
	  syslog( LOG_INFO, "GETPW for %s OK", $parameter) if $logit;
	}

      } elsif ($command eq "LIST") {
	print $clientConnection "LIST: |$command|$parameter|\n" if $debug;
	$RET = listIDs();
	if ($RET eq "FAIL") {
	  print $clientConnection "FAIL\nREADY\n";
	} else {
	  print $clientConnection $RET . "\nREADY\n";
	}
      } elsif ($command eq "QUIT") {
	print $clientConnection "QUIT: |$command|$parameter|\n" if $debug;
	$goon = 0;
      } elsif ($command eq "HELP") {
	print $clientConnection "HELP: |$command|$parameter|\n" if $debug;
	help();
      } elsif ($command eq "") {
	print $clientConnection "READY\n";
      } else {
	print $clientConnection "invalid command\nREADY\n";
      }
    }
    close($clientConnection);
  }
  close($server);

# syslog: exit ausgeben
syslog( LOG_INFO, "sIDd.pl shutdown") if $logit;

#--- KillerDaemon killen
#- pid in /var/run/sIDkiller

#--- Datenbankverbindung lsen.
$dbh->disconnect();


#--- syslog-Verbindung abbauen
closelog() if $logit;

#--- PID file loeschen
rmdir ($pidFile) or die "cannot remove PID-file\n";


exit; #-------- schluss


#-----------------------------------------------
#     SignalHandler
sub signal_handler {
  $time2die = 1;
  close($clientConnection);
}

#--------------- subfunctions ---------------------------
#- neue ID erzeugen
sub newID {           
  my $user = shift;

  if (($RET = userIn($user)) ne "OK") {

    #- sessID : user+datum in sek.
    #- timeout: datum in sek. um $idTimeout erhoeht
    #-
    #- sessID erzeugen, mit berechnetem timeout und user eintragen

    $zeit = time;

    $sessID    = $user . $zeit ;
    $timelimit = $zeit + $idTimeout;

    print "\nNEWID ZEIT: $zeit    ID: $sessID   LIMIT: $timelimit \n" if $debug;

    my $sql = qq[ 
		 INSERT INTO SessionKeys
		 (user, sessionID, timelimit)
		 VALUES ('$user', '$sessID', '$timelimit')
		];
    $dbh->do($sql) or return("FAIL");
    return($sessID);
  } else {
    return("FAIL");
  }
}

#---------------
#- ID loeschen
sub delID {             
  my $sessID = shift;

  if (($RET = isvalidID($sessID)) eq "OK") {
    #- Eintrage mit sessID loeschen
    my $sql = qq[ 
		 DELETE FROM SessionKeys
		 WHERE (sessionID = "$sessID")
		];
    $dbh->do($sql) or return("FAIL");

    return($sessID);
  } else {
    return("FAIL");
  }
}

#---------------
#- Timelimit erhoehen
sub updateID {
  my $sessID = shift;

  if (($RET = isvalidID($sessID)) eq "OK") {

    #- Eintrag mit neuem Timeout setzen
    #- Eintrag v. sessID lesen
    #-            datum um $idTimeout erhoehen
    #-            Eintrag zurueckschreiben
    $zeit = time;

    $timelimit = $zeit + $idTimeout;

    my $sql = qq[ 
		 UPDATE SessionKeys SET timelimit = "$timelimit"
		 WHERE (sessionID = "$sessID")
		];
    $dbh->do($sql) or return("FAIL");

    return($timelimit);
  } else {
    return("FAIL");
  }
}

#---------------
#- gibts diese ID?
sub isvalidID {
  my $sessID = shift;

  #- gibts einen Eintrag sessID?
  $sth = $dbh->prepare(
	       "SELECT sessionID FROM SessionKeys WHERE (sessionID = ?)") 
               or return("FAIL");;
  $sth->execute($sessID) or return("FAIL");

  ($ID) =  (@row = $sth->fetchrow_array);
  if( !defined $ID) { $ID = "";}
  
  print "ID: $ID \n" if $debug;

  if ( $ID eq $sessID) {
    return("OK");
  } else {
    return("FAIL");
  }
}

#--------------- 
#- ist dieser User eingeloggt?
sub userIn {
  my $user = shift;

  #- gibts einen Eintrag user?
  $sth = $dbh->prepare(
	       "SELECT user FROM SessionKeys WHERE (user = ?)") 
               or return("FAIL");;
  $sth->execute($user) or return("FAIL");

  ($ID) =  (@row = $sth->fetchrow_array);
  if( !defined $ID) { $ID = "";}
  
  print "User: $ID \n" if $debug;

  if ( $ID eq $user) {
    return("OK");
  } else {
    return("FAIL");
  }
}

#---------------
#- alle IDs auflisten
sub listIDs {

#  $sth = $dbh->prepare("SELECT sessionID FROM SessionKeys") or return("FAIL");;
  $sth = $dbh->prepare("SELECT sessionID, timelimit FROM SessionKeys") or return("FAIL");;
  $sth->execute() or return("FAIL");
  while ( @row = $sth->fetchrow_array) {
#    print $clientConnection "@row \n";
    print $clientConnection "@row \n";
  }
  return("OK");
}


#---------------
#- mail-pw merken
sub setPW {
  my ($sessID, $P) = @_;

  if (($RET = isvalidID($sessID)) eq "OK") {

    #- Eintrag mit PW setzen
    #- Eintrag v. sessID lesen

    my $sql = qq[ 
		 UPDATE SessionKeys SET pw = "$P"
		 WHERE (sessionID = "$sessID")
		];
    $dbh->do($sql) or return("FAIL");

    return("OK");
  } else {
    return("FAIL");
  }
}

#---------------
#- mail-pw lesen
sub getPW {
  my ($sessID) = @_;

  if (($RET = isvalidID($sessID)) eq "OK") {

    #- Eintrag v. sessID lesen
    my $sth = $dbh->prepare(
			 "SELECT pw FROM SessionKeys WHERE ( sessionID = ?)"
			) 
      or return("FAIL");
    $sth->execute($sessID) or return("FAIL");

    ($P) =  (@row = $sth->fetchrow_array);
    if( !defined $P) { $P = "";}
  
    print "getPW: $sessID \n" if $debug;

    return($P);
  } else {
    return("FAIL");
  }
}


#---------------
#- Hilfe ausgeben
sub help {
  print $clientConnection $helpmessage;
}

#-----------------------------------------------

