VERSION 5.00
Object = "{0ECD9B60-23AA-11D0-B351-00A0C9055D8E}#6.0#0"; "mshflxgd.ocx"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Begin VB.Form Telefonbuch 
   AutoRedraw      =   -1  'True
   BackColor       =   &H8000000B&
   BorderStyle     =   1  'Fest Einfach
   Caption         =   "Telefonbuch ( Kai-Uwe Mrkor - November 2000)"
   ClientHeight    =   4290
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   9330
   Icon            =   "telefonbuch.frx":0000
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4290
   ScaleWidth      =   9330
   StartUpPosition =   2  'Bildschirmmitte
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   7800
      Top             =   3360
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.CommandButton DateiLesen 
      Caption         =   "aus Datei lesen"
      Height          =   375
      Left            =   7680
      TabIndex        =   7
      Top             =   240
      Width           =   1455
   End
   Begin VB.CommandButton Lesen 
      Caption         =   "Karte aus&lesen"
      Height          =   375
      Left            =   7680
      TabIndex        =   6
      Top             =   1560
      Width           =   1455
   End
   Begin VB.CommandButton DateiSpeichern 
      Caption         =   "in Datei speichern"
      Enabled         =   0   'False
      Height          =   375
      Left            =   7680
      TabIndex        =   5
      Top             =   720
      Width           =   1455
   End
   Begin VB.CommandButton Schreiben 
      Caption         =   "Karte be&schreiben"
      Enabled         =   0   'False
      Height          =   375
      Left            =   7680
      TabIndex        =   4
      Top             =   2040
      Width           =   1455
   End
   Begin VB.TextBox StatusText 
      BackColor       =   &H8000000F&
      Height          =   315
      Left            =   360
      Locked          =   -1  'True
      TabIndex        =   2
      Top             =   3600
      Width           =   3735
   End
   Begin MSHierarchicalFlexGridLib.MSHFlexGrid FlexGrid 
      Height          =   3015
      Left            =   120
      TabIndex        =   1
      Top             =   240
      Width           =   7335
      _ExtentX        =   12938
      _ExtentY        =   5318
      _Version        =   393216
      AllowBigSelection=   0   'False
      FocusRect       =   2
      _NumberOfBands  =   1
      _Band(0).Cols   =   2
   End
   Begin VB.ComboBox LeserNamenCombo 
      Height          =   315
      Left            =   4800
      TabIndex        =   0
      Text            =   "LeserNamenCombo"
      Top             =   3600
      Width           =   2415
   End
   Begin VB.Frame Frame1 
      Caption         =   "Terminalname"
      Height          =   735
      Left            =   4560
      TabIndex        =   3
      Top             =   3360
      Width           =   2895
   End
   Begin VB.Frame Frame2 
      Caption         =   "Status"
      Height          =   735
      Left            =   120
      TabIndex        =   8
      Top             =   3360
      Width           =   4215
   End
End
Attribute VB_Name = "Telefonbuch"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim lngContext As Long                  ' Kontext
Dim lngCard As Long                     ' KartenHandle
Dim abyKommandoAPDU(1 To 255) As Byte   ' Kommando-APDU
Dim abyAntwortAPDU(1 To 255) As Byte    ' Antwort-APDU
Dim pioSendPci As SCARD_IO_REQUEST
Dim AnzRecords As Integer               ' Anzahl der Eintrge

Private Type Eintrag                    ' eine Struktur fr die Dateiarbeit
    Index   As String * 3
    Name    As String * 20
    Nummer  As String * 40
    Enter   As Integer
End Type

' Datei auslesen
Private Sub DateiLesen_Click()
    
    Dim DateiNum As Integer
    Dim i As Byte
    Dim j As Byte
    Dim k As Byte
    
    Dim MeinEintrag As Eintrag
    Dim dummy As String
    Dim dummy2 As Variant
    Dim test As String
    Dim Name As String
    Dim Nummer As String
    

    On Error GoTo Fehler

    CommonDialog1.Filter = "Telefonbuch (*.tel)|*.tel|" & _
                            "Alle Dateien (*.*)|*.*|"
    CommonDialog1.FilterIndex = 1
    CommonDialog1.ShowOpen

    DateiNum = FreeFile
    Open CommonDialog1.FileName For Random As DateiNum Len = Len(MeinEintrag)

    Get #DateiNum, 1, MeinEintrag
    AnzRecords = MeinEintrag.Nummer
    'Ausgabefeld vorbereiten (siehe VB-Buch S. 324)
    FlexGrid.Cols = 3
    FlexGrid.Rows = AnzRecords + 1     ' Anzahl der Rekords + 1
    FlexGrid.FixedCols = 1      ' grau hinterlegtes Beschreibungsfeld
    FlexGrid.FixedRows = 1      ' grau hinterlegtes Beschreibungsfeld
    FlexGrid.ColWidth(0) = FlexGrid.Width * 0.08
    FlexGrid.ColWidth(1) = FlexGrid.Width * 0.43
    FlexGrid.ColWidth(2) = FlexGrid.Width * 0.43
    FlexGrid.TextArray(1) = "Kurzname"
    FlexGrid.TextArray(2) = "Tel.-Nr."
    For i = FlexGrid.FixedRows To FlexGrid.Rows - 1
        FlexGrid.TextArray(Fgi(i, 0)) = i
    Next
    
    For i = 1 To AnzRecords
        Get #DateiNum, i + 1, MeinEintrag
        
        ' berflssige Zeichen entfernen
        For j = 1 To 40
            dummy = Mid(MeinEintrag.Nummer, 40 + 1 - j, 2)
            If Asc(dummy) <> 32 Then
                Nummer = Left(MeinEintrag.Nummer, 40 + 1 - j)
                GoTo weiter1
            End If
        Next
weiter1:

        ' berflssige Zeichen entfernen
        For j = 1 To 20
            dummy = Mid(MeinEintrag.Name, 20 + 1 - j, 2)
            If Asc(dummy) <> 32 Then
                Name = Left(MeinEintrag.Name, 20 + 1 - j)
                GoTo weiter2
            End If
        Next
weiter2:
                
        FlexGrid.TextArray(Fgi(i, 1)) = Name
        FlexGrid.TextArray(Fgi(i, 2)) = Nummer
        Name = ""
        Nummer = ""

    Next

    Close DateiNum
    
    DateiSpeichern.Enabled = True
    Schreiben.Enabled = True
                
    StatusText.Text = "Telefonbuch aus einer Datei eingelesen"
        
    Exit Sub
    
Fehler:
    Exit Sub

End Sub

' Inhalt des Telefonbuchs in eine Datei schreiben
Private Sub DateiSpeichern_Click()

    Dim DateiNum As Integer
    Dim i As Byte
    Dim Name As String      '16er String
    Dim Nummer As String    '40er Zahl
    Dim MeinEintrag As Eintrag
    
       
    On Error GoTo Fehler

    CommonDialog1.Filter = "Telefonbuch (*.tel)|*.tel|" & _
                            "Alle Dateien (*.*)|*.*|"
    CommonDialog1.FilterIndex = 1
    CommonDialog1.ShowSave

    DateiNum = FreeFile
    Open CommonDialog1.FileName For Random As DateiNum Len = Len(MeinEintrag)

    MeinEintrag.Name = "Anzahl Eintrge"
    MeinEintrag.Nummer = AnzRecords
    MeinEintrag.Enter = &HA0D
    MeinEintrag.Index = "0"
        
    Put #DateiNum, 1, MeinEintrag
    For i = 1 To AnzRecords
        MeinEintrag.Name = FlexGrid.TextArray(Fgi(i, 1))
        MeinEintrag.Nummer = FlexGrid.TextArray(Fgi(i, 2))
        MeinEintrag.Index = i
        Put #DateiNum, i + 1, MeinEintrag
    Next

    Close DateiNum
    
    StatusText.Text = "Telefonbuch in einer Datei gespeichert"
    Exit Sub
    
Fehler:
    Exit Sub

End Sub

' Telefonbucheintrag ndern
Private Sub Editieren_Click()
    
    Dim Zeile As Byte
    Dim Name As String
    Dim Nummer As String
         
    Zeile = FlexGrid.Row
    
    If Zeile <> 0 And Zeile < FlexGrid.Rows Then
        Edit.EditName = FlexGrid.TextArray(Fgi(Zeile, 1))
        Edit.EditNummer = FlexGrid.TextArray(Fgi(Zeile, 2))
    
        Edit.Show vbModal
        
        If Edit.uebernahme = True Then
            FlexGrid.TextArray(Fgi(Zeile, 1)) = Edit.EditName
            FlexGrid.TextArray(Fgi(Zeile, 2)) = Edit.EditNummer
        End If
    
        StatusText.Text = "Eintrag " & Zeile & " gendert"
        
        Unload Edit
    End If
    
End Sub

' die Tabelle wurde angeklickt
Private Sub FlexGrid_DblClick()
    Call Editieren_Click
End Sub


Private Sub FlexGrid_KeyPress(KeyAscii As Integer)
    Call Editieren_Click
End Sub

' der "Urlader"
Private Sub Form_Load()
    Dim strLeser As String          ' Liste der Leser
    Dim lngLeserAnzahl As Long      ' Lnge der Leser-Liste
    Dim lngResult As Long           ' SCARD-Ergebnis
    Dim intLeserAnzahl As Integer   ' Anzahl der inst. Leser
    Dim astrLeser As Variant        ' StringFeld fr die LeserNamen
       
    Dim i As Integer
       
    Telefonbuch.Show                ' Anzeige der Form
           
    ' ein paar Vorbereitungen
    strLeser = String(2048, vbNullChar)
    lngLeserAnzahl = Len(strLeser)
    
    ' Auslesen der Namen
    lngResult = SCardListReadersA(&O0, vbNullString, strLeser, lngLeserAnzahl)
    If lngResult = SCARD_S_SUCCESS Then
        astrLeser = ParseMultistring(strLeser, intLeserAnzahl)
        If intLeserAnzahl > 0 Then
            For i = 1 To intLeserAnzahl
                LeserNamenCombo.AddItem astrLeser(i - 1)
            Next i
        Else
            LeserNamenCombo.AddItem ("Kein PC/SC-Leser gefunden")
        End If
    Else
        LeserNamenCombo.AddItem ("Kein PC/SC-Leser gefunden")
    End If
        
    LeserNamenCombo.Text = LeserNamenCombo.List(0)
        
    FlexGrid.Cols = 0   ' FlexGrid erst mal verbergen
    FlexGrid.Rows = 0   '
    
    IntroForm.Show      ' ein paar Aufklrungen
    
End Sub
' Berechnet die Adresse des durch Spalte und Zeile gewhlten Feldes
Function Fgi(Spalte As Byte, Zeile As Byte)
    Fgi = Zeile + FlexGrid.Cols * Spalte
End Function

' Beschaffung der notwendigen Handles
' und ffnen des DFs Telecom
Private Function Init_Karte() As Long
    
    Dim lngResult As Long           ' das Ergebnis
    Dim strLeser As String          ' der LeserName
    Dim lngLeserStatusLen As Long
    Dim udtReaderStates(2) As SCARD_READERSTATEA
    
    Dim lngTimeOut  As Long
    Dim lngActiveProtocol As Long   ' Protokoll
    
    ' Kontext besorgen
    lngContext = lngNull
    lngResult = SCardEstablishContext(SCARD_SCOPE_SYSTEM, lngNull, lngNull, lngContext)
    If lngResult <> SCARD_S_SUCCESS Then
        MsgBox "SCardEstablishContext fehlgeschlagen", vbCritical, "Telefonbuch lesen"
        Init_Karte = lngResult
        Exit Function
    End If
    
    ' Status setzen
    strLeser = LeserNamenCombo.Text
    lngLeserStatusLen = 1
    udtReaderStates(0).szReader = strLeser + vbNullChar
    udtReaderStates(0).dwCurrentState = 0
    lngResult = SCardGetStatusChangeA(lngContext, lngTimeOut, udtReaderStates(0), _
                                        lngLeserStatusLen)
    If lngResult <> SCARD_S_SUCCESS Then
        MsgBox "SCardGetStatusChangeA fehlgeschlagen. ", vbCritical, "Telefonbuch lesen"
        Init_Karte = lngResult
        Exit Function
    End If

    ' mit der eingelegten Karte verbinden
    lngCard = lngNull
    lngActiveProtocol = 0
    lngResult = SCardConnectA(lngContext, strLeser, SCARD_SHARE_SHARED, _
                    SCARD_PROTOCOL_Tx, lngCard, lngActiveProtocol)
    If lngResult <> SCARD_S_SUCCESS Then
        MsgBox "SCardConnectA fehlgeschlagen. Karte im Terminal?", vbCritical, "Telefonbuch lesen"
        Init_Karte = lngResult
        Exit Function
    End If

    ' Select DF 7F10 (DF_Telecom)
    abyKommandoAPDU(1) = &HA0
    abyKommandoAPDU(2) = &HA4
    abyKommandoAPDU(3) = &H0
    abyKommandoAPDU(4) = &H0
    abyKommandoAPDU(5) = &H2
    abyKommandoAPDU(6) = &H7F
    abyKommandoAPDU(7) = &H10
       
    pioSendPci.dwProtocol = SCARD_PROTOCOL_T0
    pioSendPci.dbPciLength = Len(pioSendPci)
        
    lngResult = SCardTransmit(lngCard, pioSendPci, abyKommandoAPDU(1), _
                    7, _
                    pioSendPci, abyAntwortAPDU(1), _
                    UBound(abyAntwortAPDU) - LBound(abyAntwortAPDU) + 1)

    If lngResult <> SCARD_S_SUCCESS Then
        MsgBox "SCardTransmit fehlgeschlagen", vbCritical, "Telefonbuch lesen"
        Init_Karte = lngResult
        Exit Function
    End If

    Call Lese_Status

    Init_Karte = lngResult

End Function

' Freigabe der Handles
Private Sub Freigabe_Karte()
    
    Dim lngResult As Long           ' das Ergebnis
    
    ' Karte wieder freigeben
    lngResult = SCardDisconnect(lngCard, SCARD_LEAVE_CARD)
    If lngResult <> SCARD_S_SUCCESS Then
        MsgBox "SCardDisconnect fehlgeschlagen", vbCritical, "Telefonbuch lesen"
        Exit Sub
    End If
    
    ' Handle wieder freigeben
    lngResult = SCardReleaseContext(lngContext)
    If lngResult <> SCARD_S_SUCCESS Then
        MsgBox "SCardReleaseContext fehlgeschlagen", vbCritical, "Telefonbuch lesen"
        Exit Sub
    End If

End Sub

' liest den gewhlten Record aus dem selektierten EF
Private Function Lese_Record(Rekord As Byte, RecordLaenge As Byte) As Long
            
    Dim lngResult As Long
    Dim dummy As Byte
    Dim AntwortLaenge As Long
           
nochmal:
    abyKommandoAPDU(1) = &HA0
    abyKommandoAPDU(2) = &HB2
    abyKommandoAPDU(3) = Rekord
    abyKommandoAPDU(4) = &H4
    abyKommandoAPDU(5) = RecordLaenge
          
    pioSendPci.dwProtocol = SCARD_PROTOCOL_T0
    pioSendPci.dbPciLength = Len(pioSendPci)
        
    AntwortLaenge = 255
    lngResult = SCardTransmit(lngCard, pioSendPci, abyKommandoAPDU(1), _
                 5, _
                 pioSendPci, abyAntwortAPDU(1), _
                 AntwortLaenge)

    
    If lngResult <> SCARD_S_SUCCESS Then
        MsgBox "SCardTransmit fehlgeschlagen", vbCritical, "Telefonbuch lesen"
        Exit Function
    End If

    Lese_Record = lngResult
    
    If AntwortLaenge > 2 Then
        Exit Function           ' alles in Ordnung
    Else
        If abyAntwortAPDU(1) = &H98 Then ' PIN1 erforderlich
            
            If Verify_CHV = SCARD_S_SUCCESS Then
                GoTo nochmal
            Else
                Lese_Record = SCARD_S_SUCCESS + 1
            End If
        
        End If
    End If
        
End Function
' liest den gewhlten Record aus dem selektierten EF
Private Function Update_Record(Rekord As Byte, RecordLaenge As Byte) As Long
            
    Dim lngResult As Long
    Dim AntwortLaenge As Long

    abyKommandoAPDU(1) = &HA0
    abyKommandoAPDU(2) = &HDC
    abyKommandoAPDU(3) = Rekord
    abyKommandoAPDU(4) = &H4
    abyKommandoAPDU(5) = RecordLaenge
          
    pioSendPci.dwProtocol = SCARD_PROTOCOL_T0
    pioSendPci.dbPciLength = Len(pioSendPci)
        
    lngResult = SCardTransmit(lngCard, pioSendPci, abyKommandoAPDU(1), _
                 5 + RecordLaenge, pioSendPci, abyAntwortAPDU(1), 255)

    Update_Record = lngResult
    
    If lngResult <> SCARD_S_SUCCESS Then
        MsgBox "SCardTransmit fehlgeschlagen", vbCritical, "Telefonbuch lesen"
        Exit Function
    End If

    If abyAntwortAPDU(1) <> &H90 Then ' kein OK als Antwort
            Update_Record = SCARD_S_SUCCESS + 1
    End If

End Function

' PIN-Vergleich starten
Private Function Verify_CHV() As Long

    Dim i As Byte
    Dim lngResult As Long

    PINEingabe.Eingabe = ""
    PINEingabe.Show vbModal
    If PINEingabe.uebernahme = True Then
    
        ' Header schreiben
        abyKommandoAPDU(1) = &HA0
        abyKommandoAPDU(2) = &H20
        abyKommandoAPDU(3) = &H0
        abyKommandoAPDU(4) = &H1    'PNI1
        abyKommandoAPDU(5) = &H8
        
        ' PIN ablegen und den Rest mit FF auffllen
        For i = 1 To Len(PINEingabe.Eingabe)
            abyKommandoAPDU(5 + i) = Asc(Mid(PINEingabe.Eingabe, i, 1))
        Next
        For i = Len(PINEingabe.Eingabe) + 1 To 8
            abyKommandoAPDU(5 + i) = 255
        Next
    
        pioSendPci.dwProtocol = SCARD_PROTOCOL_T0
        pioSendPci.dbPciLength = Len(pioSendPci)
        lngResult = SCardTransmit(lngCard, pioSendPci, abyKommandoAPDU(1), _
                     5 + 8, pioSendPci, abyAntwortAPDU(1), 255)
        If lngResult <> SCARD_S_SUCCESS Then
            MsgBox "SCardTransmit fehlgeschlagen", vbCritical, "Telefonbuch lesen"
            Exit Function
        End If

        If abyAntwortAPDU(1) <> &H90 Then
            MsgBox "Pin-Vergleich fehlgeschlagen", vbCritical, "Telefonbuch lesen"
        End If
        
                
        Verify_CHV = lngResult
    
    Else
        
        Verify_CHV = SCARD_S_SUCCESS + 1
    
    End If
    
    Unload PINEingabe
    
End Function

' EF selektieren, Alle nachfolgenden Operationen beziehen sich dann auf dieses
Private Function Selektiere_EF(EF1 As Byte, EF2 As Byte) As Long
        
    Dim lngResult As Long           ' das Ergebnis
    Dim laenge As Long
    
    ' Select EF
    abyKommandoAPDU(1) = &HA0
    abyKommandoAPDU(2) = &HA4
    abyKommandoAPDU(3) = &H0
    abyKommandoAPDU(4) = &H0
    abyKommandoAPDU(5) = &H2
    abyKommandoAPDU(6) = EF1
    abyKommandoAPDU(7) = EF2
           
    pioSendPci.dwProtocol = SCARD_PROTOCOL_T0
    pioSendPci.dbPciLength = Len(pioSendPci)
        
    lngResult = SCardTransmit(lngCard, pioSendPci, abyKommandoAPDU(1), _
                    7, pioSendPci, abyAntwortAPDU(1), 255)

    If lngResult <> SCARD_S_SUCCESS Then
        MsgBox "SCardTransmit fehlgeschlagen", vbCritical, "Telefonbuch lesen"
        Selektiere_EF = lngResult
        Exit Function
    End If

    Selektiere_EF = lngResult
    
   If abyAntwortAPDU(1) <> &H9F Then
        MsgBox "Kommando Select EF fehlgeschlagen", vbCritical, "Telefonbuch lesen"
        Exit Function
    End If
            
End Function

' Dateistatus Auslesen (Einsatz nach Select_EF)
Private Function Lese_Status() As Long
    
    Dim lngResult As Long           ' das Ergebnis
    
    ' Get Response
    abyKommandoAPDU(1) = &HA0
    abyKommandoAPDU(2) = &HC0
    abyKommandoAPDU(3) = &H0
    abyKommandoAPDU(4) = &H0
    abyKommandoAPDU(5) = abyAntwortAPDU(2)
    
       
    pioSendPci.dwProtocol = SCARD_PROTOCOL_T0
    pioSendPci.dbPciLength = Len(pioSendPci)
        
    lngResult = SCardTransmit(lngCard, pioSendPci, abyKommandoAPDU(1), _
                    5, pioSendPci, abyAntwortAPDU(1), 255)

    Lese_Status = lngResult
    
    If lngResult <> SCARD_S_SUCCESS Then
        MsgBox "SCardTransmit fehlgeschlagen", vbCritical, "Telefonbuch lesen"
        Exit Function
    End If
    
End Function

' UP zum Auslesen des Telefonbuchs
Private Sub Lesen_Click()
    
    Dim lngResult As Long           ' das Ergebnis
    Dim RecordLaenge As Byte        ' Gre eines Telefonbucheintrags
    Dim Rekord As Byte              ' Eintragsindex
    Dim i As Byte                   ' Laufvariable
    Dim X As Byte                   ' Namens-Offset

    Dim Nummer(1 To 255) As Byte    ' Zwischenpuffer
    Dim AnzNummernBytes As Byte     ' Anzahl der bentigten Bytes
    
    Dim ausgabe As Variant          ' zwei Hilfsvariablen
    Dim dummy   As Byte             '
    
    
    ' Karte vorbereiten
    If Init_Karte() <> SCARD_S_SUCCESS Then
        Exit Sub
    End If
    
    ' EF_ADN selektieren
    If Selektiere_EF(&H6F, &H3A) <> SCARD_S_SUCCESS Then
        Call Freigabe_Karte
        Exit Sub
    End If

    ' Dateistatus lesen
    If Lese_Status() <> SCARD_S_SUCCESS Then
        Call Freigabe_Karte
        Exit Sub
    End If

    RecordLaenge = abyAntwortAPDU(15)
    AnzRecords = (abyAntwortAPDU(3) * 256 + abyAntwortAPDU(4)) / RecordLaenge
    
    'Ausgabefeld vorbereiten (siehe VB-Buch S. 324)
    FlexGrid.Cols = 3
    FlexGrid.Rows = AnzRecords + 1      ' Anzahl der Rekords + 1
    FlexGrid.FixedCols = 1              ' grau hinterlegtes Beschreibungsfeld
    FlexGrid.FixedRows = 1              ' grau hinterlegtes Beschreibungsfeld
    FlexGrid.ColWidth(0) = FlexGrid.Width * 0.08
    FlexGrid.ColWidth(1) = FlexGrid.Width * 0.43
    FlexGrid.ColWidth(2) = FlexGrid.Width * 0.43
    FlexGrid.TextArray(1) = "Kurzname"
    FlexGrid.TextArray(2) = "Tel.-Nr."
    For i = FlexGrid.FixedRows To FlexGrid.Rows - 1
        FlexGrid.TextArray(Fgi(i, 0)) = i
        FlexGrid.TextArray(Fgi(i, 1)) = ""
        FlexGrid.TextArray(Fgi(i, 2)) = ""
    Next


    X = RecordLaenge - 14   ' Gre des ASCII-Feldes ermitteln

    ' die Rekords auslesen
    For Rekord = 1 To AnzRecords
    
        StatusText.Text = "Lese Eintrag " & Rekord & " von " & AnzRecords
        Telefonbuch.Refresh
                     
        ausgabe = ""

        ' Lese Rekord
        If Lese_Record(Rekord, RecordLaenge) <> SCARD_S_SUCCESS Then
            FlexGrid.Cols = 0
            FlexGrid.Rows = 0      ' FlexGrid "lschen"
            StatusText.Text = "Telefonbuch durch PIN1 geschtzt"
            Call Freigabe_Karte
            Exit Sub
        End If

        '******************
        '  Namen auslesen
        '******************
        For i = 1 To X
            If abyAntwortAPDU(i) <> 255 Then
                ausgabe = ausgabe + Chr(abyAntwortAPDU(i))
            End If
        Next
        FlexGrid.TextArray(Fgi(Rekord, 1)) = ausgabe

        '******************
        ' Nummer auslesen
        '******************
        AnzNummernBytes = abyAntwortAPDU(X + 1)
        If AnzNummernBytes <> &HFF Then ' nur auslesen, wenn wirklich vorhanden
            
            ' die "Nummern"-Bytes auslesen
            For i = 1 To AnzNummernBytes
                If i < 11 Then
                    Nummer(i) = abyAntwortAPDU(X + 2 + i)
                End If
            Next
               
            ' gegebenenfalls den "Rest" aus EXT1 holen (-> max. 40 Nummern)
            If abyAntwortAPDU(X + 14) <> &HFF Then
                
                MsgBox "Der Eintrag " & Rekord & " umfasst mehr als 20 Nummern. " & _
                        "Bitte beachten Sie, dass beim Speicher in dieser Version aber nur die ersten 20 Nummern abgelegt werden.", _
                        vbCritical, "Telefonbuch lesen"
                
                ' EF_EXT1 selektieren
                If Selektiere_EF(&H6F, &H4A) <> SCARD_S_SUCCESS Then
                    Call Freigabe_Karte
                    Exit Sub
                End If
                ' korrespondierende Erweiterung auslesen
                If Lese_Record(abyAntwortAPDU(X + 14), 13) <> SCARD_S_SUCCESS Then
                    MsgBox "Fehler beim Lesen von Rekord" & Rekord, vbCritical, "Telefonbuch lesen"
                    Call Freigabe_Karte
                    Exit Sub
                End If
        
                ' und die gelesene Nummer anhngen
                AnzNummernBytes = AnzNummernBytes + abyAntwortAPDU(2)
                For i = 11 To AnzNummernBytes
                    If i < 11 + abyAntwortAPDU(2) Then
                        Nummer(i) = abyAntwortAPDU(2 + i - 10)
                    End If
                Next
                        
                ' und wieder EF_ADN selektieren
                If Selektiere_EF(&H6F, &H3A) <> SCARD_S_SUCCESS Then
                    Call Freigabe_Karte
                    Exit Sub
                End If
            End If
                        
            ' berprfen, ob es sich um eine Internationale Nummer handelt
            If abyAntwortAPDU(X + 2) <> &H81 Then
                ausgabe = "+"   ' ja, also ein Pluszeichen vorsetzen
            Else
                ausgabe = ""    ' nein, also "Blanko"
            End If

            ' und nun die Nummern ziffernweise aus den Nibbles lesen
            If AnzNummernBytes <> &HFF Then
                For i = 1 To AnzNummernBytes
    
                    ' L-Nibble
                    dummy = Nummer(i)
                    dummy = dummy And &HF
                    If dummy <> &HF Then
                        dummy = dummy + &H30
                        ausgabe = ausgabe + Chr(dummy)
                    End If
            
                    ' H-Nibble
                    dummy = Nummer(i)
                    dummy = dummy And &HF0
                    If dummy <> &HF0 Then
                        dummy = dummy / 16 + &H30
                        ausgabe = ausgabe + Chr(dummy)
                    End If
                                           
                Next
            End If
            
        Else                ' if AnzNummernBytes <> &HFF Then
            ausgabe = ""    ' keine Telefonnummer gefunden
        End If
               
        ' die ermittelte Zeichenkette ausgeben
        FlexGrid.TextArray(Fgi(Rekord, 2)) = ausgabe

    Next
    StatusText.Text = AnzRecords & " Eintrge aus der Karte gelesen"

    DateiSpeichern.Enabled = True
    Schreiben.Enabled = True
    Call Freigabe_Karte

End Sub

' UP zum Beschreiben des Telefonbuchs
Private Sub Schreiben_Click()
    
    Dim lngResult As Long           ' das Ergebnis
    Dim RecordLaenge As Byte
    Dim Rekord As Byte
    Dim i As Byte
    Dim j As Byte

    Dim X As Byte

    Dim dummy   As Byte
    Dim dummy2   As Byte
    Dim strDummy As String
    Dim Nummer   As String
    
    Dim LaengeEintrag As Byte
    
    StatusText.Text = "Beschreiben des Telefonbuchs wird vorbereitet"
            
    ' Karte vorbereiten
    If Init_Karte() <> SCARD_S_SUCCESS Then
        StatusText.Text = "Fehler beim Initialisieren des CT"
        Exit Sub
    End If
    
    ' EF_ADN selektieren
    If Selektiere_EF(&H6F, &H3A) <> SCARD_S_SUCCESS Then
        StatusText.Text = "Fehler beim Selektieren des EF"
        Call Freigabe_Karte
        Exit Sub
    End If
    
    ' Dateistatus lesen
    If Lese_Status() <> SCARD_S_SUCCESS Then
        StatusText.Text = "Fehler beim Status-Auslesen"
        Call Freigabe_Karte
        Exit Sub
    End If

    RecordLaenge = abyAntwortAPDU(15) ' *256 -> Rechtsverschiebung um 8 Bit
    AnzRecords = (abyAntwortAPDU(3) * 256 + abyAntwortAPDU(4)) / RecordLaenge
    X = RecordLaenge - 14   ' Gre des ASCII-Feldes
      
    ' Lese Rekord 1 (zum Test auf PIN)
    If Lese_Record(1, RecordLaenge) <> SCARD_S_SUCCESS Then
        StatusText.Text = "Telefonbuch durch PIN1 geschtzt"
        Call Freigabe_Karte
        Exit Sub
    End If
    
    ' hier geht es nun los
    For Rekord = 1 To AnzRecords
    
        StatusText.Text = "Schreibe Eintrag " & Rekord & " von " & AnzRecords
        Telefonbuch.Refresh
    
        ' X Bytes fr den Namen ab abyKommandoAPDU (5+1)
        '
        LaengeEintrag = Len(FlexGrid.TextArray(Fgi(Rekord, 1)))
        If LaengeEintrag <> 0 Then
        
            For i = 1 To LaengeEintrag
                strDummy = Mid(FlexGrid.TextArray(Fgi(Rekord, 1)), i, 1)
                abyKommandoAPDU(5 + i) = Asc(strDummy)
            Next
    
            For i = LaengeEintrag + 1 To X
                abyKommandoAPDU(5 + i) = &HFF
            Next
        
            '*****************************
            ' und nun die Telefonnummer
            '*****************************
            
            ' Die Anzahl der Bentigten Bytes zur Ablage
            ' der Telefonnummer auf abyKommandoAPDU (5+X+1)
            LaengeEintrag = Len(FlexGrid.TextArray(Fgi(Rekord, 2)))
            
            ' Nach vorangestelltem + untersuchen
            strDummy = Mid(FlexGrid.TextArray(Fgi(Rekord, 2)), 1, 1)
            If strDummy = "+" Then
                Nummer = FlexGrid.TextArray(Fgi(Rekord, 2))
                Nummer = Right(Nummer, LaengeEintrag - 1)
                LaengeEintrag = LaengeEintrag - 1
                abyKommandoAPDU(5 + X + 2) = &H91 ' Kennzeichen fr international
            Else
                Nummer = FlexGrid.TextArray(Fgi(Rekord, 2))
                abyKommandoAPDU(5 + X + 2) = &H81 ' Kennzeichen fr lokal
            End If
                        
            ' z.Z. werden nur Nummern mit bis zu 20 Ziffern untersttzt
            If LaengeEintrag > 20 Then
                MsgBox "Nummernberlauf", vbCritical, "Telefonbuch schreiben"
                LaengeEintrag = 20
            End If
        
            ' Anzahl der zur Speicherung bentigten Bytes ermitteln
            j = 0
            For i = 1 To LaengeEintrag Step 2
                j = j + 1
            Next
            abyKommandoAPDU(5 + X + 1) = j + 1 '+1 fr Anzahl-Byte
    
    
            ' max 10 Bytes fr die Nummer ab abyKommandoAPDU (5+X+3)
            '
            j = 1
            For i = 1 To abyKommandoAPDU(5 + X + 1) - 1
                                
                'nwt
                strDummy = Mid(Nummer, j, 1)
                If strDummy <> "" Then
                    dummy = strDummy
                    dummy2 = dummy
                Else
                    dummy2 = &HF
                End If
                j = j + 1
            
                'hwt
                strDummy = Mid(Nummer, j, 1)
                If strDummy <> "" Then
                dummy = strDummy
                dummy2 = dummy2 + dummy * 16
                Else
                    dummy2 = dummy2 + &HF0
                End If
                j = j + 1
        
                abyKommandoAPDU(5 + X + 2 + i) = dummy2
        
            Next i
        
            ' den Rest mit FF auffllen
            For i = 5 + X + 3 + abyKommandoAPDU(5 + X + 1) - 1 To 5 + X + 13
                abyKommandoAPDU(i) = &HFF
            Next i
    
    
            'Extension1 Record (keine Erweiterung) vorgeben
            abyKommandoAPDU(5 + X + 14) = &HFF
                
        Else ' wenn keine Name im Feld -> gibt es auch keinen Eintrag
             ' daher wird der gesamte Rekord FF gesetzt
            For i = 1 To RecordLaenge
                abyKommandoAPDU(5 + i) = &HFF
            Next
                
        End If ' if laenge
    
        If Update_Record(Rekord, RecordLaenge) <> SCARD_S_SUCCESS Then
            StatusText.Text = "Fehler beim Aktualisieren von Rekord " & Rekord
            Call Freigabe_Karte
            Exit Sub
        End If

    Next Rekord ' For Rekord=1
    
    StatusText.Text = "Das Telefonbuch der Karte wurde aktualisiert"
    Call Freigabe_Karte

    Exit Sub

End Sub
