Attribute VB_Name = "modInterview"
' Interview.bas
' Datenbank-Routinen
Option Explicit
' Globale Variablen
Public lType As Long
Public lCreator As Long
Public db As Long ' Datenbank-Handle

' enum fr Attention
Public Enum eAttentionValue
    attCt
    attInternet
    attOther
End Enum
' enum fr Felder im Datensatz
Public Enum eInterviewRecord
    eDate
    eAttention
    eOther
    eHandhelds
    eName
    eEmail
End Enum

Public Sub openDatabase()
Dim strDBName As String
lType = PalmIDtoLong("DATA") ' Datenbank-Typ
lCreator = PalmIDtoLong("Invw") ' Creator

#If APPFORGE Then
    'Datenbankname auf dem Handheld
    strDBName = "InterviewDB"
#Else
    'Datenbankname unter Windows
    strDBName = App.Path & "\InterviewDB.pdb"
#End If
' ffne Datenbank nach Name (Type, Creator etc. mu nicht angegeben werden)
db = PDBOpen(Byfilename, strDBName, 0, 0, 0, 0, afModeReadWrite)
If db = 0 Then
    ' Datenbank existiert noch nicht, erzeuge eine neue
    ' Name, Type und Creator mssen angegeben werden
    db = PDBCreateDatabase(strDBName, lType, lCreator)
End If
createSchema
End Sub

Public Sub createSchema()
' erzeuge Schema mit Feldinformationen fr Datenstze
PDBSetNumFields db, eEmail + 1

PDBSetFieldType db, eDate, eDateField, 0
PDBSetFieldType db, eAttention, eIntegerField, 0
PDBSetFieldType db, eOther, eStringField, 0
PDBSetFieldType db, eHandhelds, eIntegerField, 0
PDBSetFieldType db, eName, eStringField, 0
PDBSetFieldType db, eEmail, eStringField, 0

End Sub
Public Sub closeDatabase()
' falls Datenbank geffnet war, schliee sie
If db <> 0 Then PDBClose db
End Sub

' Hilfsfunktion
' wandle 4-Zeichen-String nach Long um
Public Function PalmIDtoLong(PalmID As String) As Long
Dim myLng As Long, i As Integer
For i = 1 To Len(PalmID)
  myLng = myLng * 256 + Asc(Mid$(PalmID, i, 1))
Next i
PalmIDtoLong = myLng
End Function
