unit testmain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,
  vc1;

type
  TMainForm = class(TForm)
    Log: TMemo;
    BtnClose: TButton;
    Label1: TLabel;
    Button1: TButton;
    procedure BtnCloseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
	function OnCOPYDATA(pCDS: PCOPYDATASTRUCT): cardinal;
    function ON_EVENT_QCHECKPROCESS(pEvent: PSCEVENT): cardinal;
    function ON_EVENT_EXECUTE(pEvent: PSCEVENT): cardinal;
    function ON_EVENT_CREATEOBJECT(pEvent: PSCEVENT): cardinal;
    function ON_EVENT_FILE(pEvent: PSCEVENT): cardinal;
    function ON_EVENT_REGKEY(pEvent: PSCEVENT): cardinal;
    function ON_EVENT_REGVALUE(pEvent: PSCEVENT): cardinal;
  public
    { Public-Deklarationen }
	procedure WndProc(var Message: TMessage); override;
  end;

var
  MainForm: TMainForm;

implementation

uses
	ole2, Registry
	;

{$R *.DFM}

function StringFromEventType(nEvent: integer): string;
begin
	case (nEvent and VC_EVENTTYPEMASK) of
    	VC_EVENTTYPE_READ: Result := 'Read/Open';
    	VC_EVENTTYPE_WRITE: Result := 'Write/Create';
    	VC_EVENTTYPE_ENUM: Result := 'Enum';
    	VC_EVENTTYPE_DELETE: Result := 'Delete';
        else Result := '';
    end;
end;

function ProgStringFromCLSIDString(sCLSID: String): String;
var
    Reg: TRegistry;
begin
	Reg := TRegistry.Create;
	Reg.RootKey := HKEY_CLASSES_ROOT;
    if Reg.OpenKey('\CLSID\' + sCLSID + '\ProgID', FALSE) then
    	Result := Reg.ReadString('')
      else
	    if Reg.OpenKey('\CLSID\' + sCLSID, FALSE) then
	    	Result := Reg.ReadString('');
   	if Result = '' then
    	Result := sCLSID;
    Reg.Free;
end;

function TMainForm.ON_EVENT_QCHECKPROCESS(pEvent: PSCEVENT): cardinal;
begin
    Result := 0;
    Log.Lines.append(format('ON_EVENT_QCHECKPROCESS(%s:%s)',
    	[pEvent^._Process._szModule,
         pEvent^._szParameter]));
end;

function TMainForm.ON_EVENT_EXECUTE(pEvent: PSCEVENT): cardinal;
begin
    Result := 0;
    Log.Lines.append(format('%s/%s:ON_EVENT_EXECUTE(%s)',
    	[pEvent^._Process._szModule,
         pEvent^._szDLL,
         pEvent^._szParameter]));
end;

function TMainForm.ON_EVENT_CREATEOBJECT(pEvent: PSCEVENT): cardinal;
begin
    Result := 0;
    Log.Lines.append(format('%s/%s:ON_EVENT_CREATEOBJECT(%s)',
    	[pEvent^._Process._szModule,
         pEvent^._szDLL,
         ProgStringFromCLSIDString(pEvent^._szParameter)]));
    if ProgStringFromCLSIDString(pEvent^._szParameter) = 'Scripting.FileSystemObject' then
    	begin
        if Application.MessageBox(
        	pchar(format('%s tries to access the FileSystemObject scripting object - shall access be allowed?',
            	[pEvent^._Process._szModule])),
            'Warning',
            MB_YESNO) = IDNO then
	    	Result := 1;
        end
end;

function TMainForm.ON_EVENT_FILE(pEvent: PSCEVENT): cardinal;
begin
    Result := 0;
    Log.Lines.append(format('%s/%s:ON_EVENT_FILE(%s:%s)',
    	[pEvent^._Process._szModule,
         pEvent^._szDLL,
         StringFromEventtype(pEvent^._nEvent),
         pEvent^._szParameter]));
end;

function TMainForm.ON_EVENT_REGKEY(pEvent: PSCEVENT): cardinal;
begin
    Result := 0;
    Log.Lines.append(format('%s/%s:ON_EVENT_REGKEY(%s:%s)',
    	[pEvent^._Process._szModule,
         pEvent^._szDLL,
         StringFromEventtype(pEvent^._nEvent),
         pEvent^._szParameter]));

end;

function TMainForm.ON_EVENT_REGVALUE(pEvent: PSCEVENT): cardinal;
begin
    Result := 0;
    Log.Lines.append(format('%s/%s:ON_EVENT_REGVALUE(%s:%s)',
    	[pEvent^._Process._szModule,
         pEvent^._szDLL,
         StringFromEventtype(pEvent^._nEvent),
         pEvent^._szParameter]));
    
end;

procedure TMainForm.BtnCloseClick(Sender: TObject);
begin
	Close();
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
	VcInstall(self.Handle,0);
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
	VcEnable(FALSE);
	VcUninstall();
end;


function TMainForm.OnCOPYDATA(pCDS: PCOPYDATASTRUCT): cardinal;
var
	pEvent:	PSCEVENT;
begin
	Result := 0;
	case pCDS^.dwData of
		0: // only value at the moment
			begin
            pEvent := PSCEVENT(pCDS^.lpData);
            case (pEvent^._nEvent and VC_EVENTMASK) of
				VC_QUEST_CHECKPROCESS:
                	Result := ON_EVENT_QCHECKPROCESS(pEvent);
				VC_EVENT_EXECUTE:
                	Result := ON_EVENT_EXECUTE(pEvent);
				VC_EVENT_CREATEOBJECT:
                	Result := ON_EVENT_CREATEOBJECT(pEvent);
				VC_EVENT_FILE:
                	Result := ON_EVENT_FILE(pEvent);
				VC_EVENT_REGKEY:
                	Result := ON_EVENT_REGKEY(pEvent);
				VC_EVENT_REGVALUE:
                	Result := ON_EVENT_REGVALUE(pEvent);
	            end;
			end;
		end;
end;

procedure TMainForm.WndProc(var Message: TMessage);
begin
	case Message.msg of
    	WM_COPYDATA:
        	begin
            Message.Result := OnCOPYDATA(PCOPYDATASTRUCT(Message.lParam));
            end;
        else
        	begin
            inherited;
            end;
    end;
end;


procedure TMainForm.FormResize(Sender: TObject);
begin
	BtnClose.Left := ClientWidth - BtnClose.Width
end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
	Close;
end;

end.
