// RunOnRes.cpp : Definiert den Einsprungpunkt fr die Anwendung.
//

#include "stdafx.h"
#include "resource.h"

#define MAX_LOADSTRING 100

// Die Display-Settings fr das zu startende Programm werden global
// gendert und in der Registry gespeichert, damit das System Desktop, 
// Taskleiste, etc. mit anpasst. Wer das nicht will, sollte die 
// folgende Zeile auskommentieren.
#define CHANGEGLOBALLY

#ifdef CHANGEGLOBALLY
#define CDSFLAGS CDS_UPDATEREGISTRY
#else
#define CDSFLAGS 0
#endif

// Globale Variablen:
HINSTANCE hInst;                     // aktuelle Instanz
HWND hWndMain;                       // Handle des Hauptfensters
TCHAR szTitle[MAX_LOADSTRING];       // Text der Titelzeile
TCHAR szWindowClass[MAX_LOADSTRING]; // Text der Titelzeile
UINT nTimer;                         // Timer-ID fr die Prozessabfrage
int resX, resY;                      // gewnschte Auflsung
DEVMODE dmOld;                       // gespeicherte Display-Settings
BOOL bChanged;                       // Einstellungen gendert?
LPSTR command;                       // Befehlszeile des aufzurufenden Programms
PROCESS_INFORMATION procInfo;        // Process-ID des gestarteten Programms

// Vorausdeklarationen von Funktionen, die in diesem Code-Modul enthalten sind:
BOOL             ParseCommandLine( LPSTR cmdLine );
ATOM             MyRegisterClass( HINSTANCE hInstance );
BOOL             InitInstance( HINSTANCE, int );
LRESULT CALLBACK WndProc( HWND, UINT, WPARAM, LPARAM );

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
{
	MSG msg;

    hInst = hInstance; // Instanzzugriffsnummer in unserer globalen Variable speichern

	// Globale Zeichenfolgen initialisieren
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_RUNONRES, szWindowClass, MAX_LOADSTRING);
	
	if( !ParseCommandLine(lpCmdLine) )
		return FALSE;

	MyRegisterClass(hInstance);

	// Initialisierung der Anwendung durchfhren:
	if( !InitInstance( hInstance, nCmdShow ) ) 
	{
		return FALSE;
	}

	// Hauptnachrichtenschleife:
	while( GetMessage(&msg, NULL, 0, 0) ) 
	{
		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}

	return msg.wParam;
}

//
//  FUNKTION: MyRegisterClass()
//
//  AUFGABE: Registriert die Fensterklasse.
//
//  KOMMENTARE:
//
//    Diese Funktion und ihre Verwendung sind nur notwendig, wenn dieser Code
//    mit Win32-Systemen vor der 'RegisterClassEx'-Funktion kompatibel sein soll,
//    die zu Windows 95 hinzugefgt wurde. Es ist wichtig diese Funktion aufzurufen,
//    damit der Anwendung kleine Symbole mit den richtigen Proportionen zugewiesen
//    werden.
//
ATOM MyRegisterClass( HINSTANCE hInstance )
{
	WNDCLASSEX wcex;

	memset(&wcex, 0, sizeof(WNDCLASSEX));
	wcex.cbSize         = sizeof(WNDCLASSEX); 
	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, (LPCTSTR)IDI_RUNONRES);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszClassName	= szWindowClass;

	return RegisterClassEx(&wcex);
}

//
//  FUNKTION: ParseCommandLine()
//
//  AUFGABE: Extrahiert Optionen aus der Befehlszeile.
//
//  KOMMENTARE:
//
//    Die Befehlszeile muss folgendes Format haben:
//       RunOnRes [640|800|1024|1152|1280|1600] <Anwendung>
//
BOOL ParseCommandLine( LPSTR cmdLine )
{
	resX = 0;
	LPSTR p = strtok(cmdLine, " \t"); // Zahl f. Auflsung aus Kommandozeile lesen
	if(p)
	{
		resX = atoi(p); // Umwandlung in int
		if(resX != 640 && resX != 800 && resX != 1024
		   && resX != 1152 && resX != 1280 && resX != 1600)
			resX = 0; // Ungltig
		else
		{
			command = strtok(NULL, "\0"); // Nchstes "Wort" ist Programmaufruf
			if(command)                   // Vorhanden?
			{
				if(resX == 1280)
					resY = 1024; // Sonderfall
				else
					resY = (3 * resX) / 4; // Sonst 4/3
			}
			else
				resX = 0;
		}
	}
	if(resX == 0) // Ungltige Befehlszeile
	{
		TCHAR szError[MAX_LOADSTRING + 1];
		LoadString(hInst, IDS_USAGE, szError, MAX_LOADSTRING);
		MessageBox(NULL, szError, szTitle, MB_OK | MB_ICONSTOP);
		return FALSE; // Programm gleich beenden; s. WinMain
	}

	return TRUE;
}

//
//   FUNKTION: InitInstance(HANDLE, int)
//
//   AUFGABE: Speichert die Instanzzugriffsnummer und erstellt das Hauptfenster
//
//   KOMMENTARE:
//
//        In dieser Funktion wird die Instanzzugriffsnummer in einer globalen Variable
//        gespeichert und das Hauptprogrammfenster erstellt und angezeigt.
//
BOOL InitInstance( HINSTANCE hInstance, int nCmdShow )
{
   TCHAR szError[MAX_LOADSTRING + 1];

   bChanged = FALSE; // Noch nichts passiert

   // Fenster fr Nachrichtenempfang (WM_TIMER) erzeugen
   // Beachte: Das Fenster bleibt unsichtbar
   hWndMain = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if( !hWndMain ) 
   {
      return FALSE;
   }

   // Aktuelle Bildschirmeinstellung abfragen
   DEVMODE dm;
   memset(&dm, 0, sizeof(DEVMODE));
   dm.dmSize = sizeof(DEVMODE);
   EnumDisplaySettings(NULL, ENUM_CURRENT_SETTINGS, &dm);
   
   // Einstellungen speichern
   dm.dmFields = DM_PELSWIDTH | DM_PELSHEIGHT;
   memcpy(&dmOld, &dm, sizeof(DEVMODE));
   // Neu: Beim Wiederherstellen Frequenz mitnehmen
   dmOld.dmFields |= DM_DISPLAYFREQUENCY;

   // Umschalten
   dm.dmPelsWidth = resX;
   dm.dmPelsHeight = resY;
   if( ChangeDisplaySettings(&dm, CDSFLAGS) != DISP_CHANGE_SUCCESSFUL )
   {
     LoadString(hInst, IDS_MODEERROR, szError, MAX_LOADSTRING);
     MessageBox(NULL, szError, szTitle, MB_OK | MB_ICONSTOP);
     return FALSE;
   }
   bChanged = TRUE;

   // Das eigentliche Programm starten
   STARTUPINFO si;
   memset(&si, 0, sizeof(STARTUPINFO));
   si.cb = sizeof(STARTUPINFO);
   if( !CreateProcess(NULL, command, NULL, NULL, FALSE, 0, NULL, NULL, &si, &procInfo) )
   {
     // Bei Fehler: Display restaurieren und raus
	 ChangeDisplaySettings(&dmOld, CDSFLAGS);
	 bChanged = FALSE;
     LoadString(hInst, IDS_STARTERROR, szError, MAX_LOADSTRING);
     MessageBox(NULL, szError, szTitle, MB_OK | MB_ICONSTOP);
     return FALSE;
   }

   // Wecker installieren
   nTimer = SetTimer(hWndMain, 1, 500, NULL);

   return TRUE;
}

//
//  FUNKTION: WndProc(HWND, unsigned, WORD, LONG)
//
//  AUFGABE:  Verarbeitet Nachrichten fr das Hauptfenster.
//
//  WM_COMMAND	- Anwendungsmen verarbeiten
//  WM_TIMER	- berprfen, ob die gestartete Anwendung noch luft
//  WM_DESTROY	- Beendigungsnachricht ausgeben und zurckkehren
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	DWORD dwExitCode;

	switch( message ) 
	{
		case WM_TIMER:
			// Luft das gestartete Programm noch?
			GetExitCodeProcess(procInfo.hProcess, &dwExitCode);
			if(dwExitCode != STILL_ACTIVE)
			{
				// Gestartetes Programm beendet => Timer abrumen und raus
				// Den Rest erledigt WM_DESTROY
				KillTimer(hWnd, nTimer);
				DestroyWindow(hWnd);
			}
			break;
		case WM_QUERYENDSESSION:
			// Windows wird beendet => Display restaurieren
		case WM_DESTROY:
			// Programmende => Display restaurieren
		    if(bChanged)
			{
				ChangeDisplaySettings(&dmOld, CDSFLAGS);
				bChanged = FALSE;
			}
			if(message == WM_QUERYENDSESSION)
				return TRUE; // Okay fr Shutdown
			else
				PostQuitMessage( 0 ); // Feierabend fr uns
			break;
		default:
			return DefWindowProc( hWnd, message, wParam, lParam );
   }
   return 0;
}
