/* LW_PALM.h:  common function for PALM programming
 *
 * Arndt Kritzner
 * kritzner@logicway.de
 */

#ifndef __LW_PALM_H__
#define __LW_PALM_H__

#define MAX_DIGITS 20
#define MAX_VALID_DIGITS 7

#define LW_NO_ERROR 0
#define LW_ERR_DToStr 1
#define LW_ERR_StrToD 2
#define LW_ERR_SQRT 3
#define LW_ERR_ArcSin 4
#define LW_ERR_USER 100

#define LW_ITERATION_ACCURACY 1.0e-3
#define LW_ITERATION_LOOPS 100
#define LW_PI 3.1415926
#define LW_RAD2DEG (180/LW_PI)
#define LW_DEG2RAD (LW_PI/180)

UInt8 LW_Error( UInt8 e );
Int8 LW_DoubleToStr( char* StrVal, const UInt8 maxLen, const double FVal );
Int8 LW_StrToDouble( char* StrVal, double* FVal );
Int16 LW_DoubleToInt( const double FVal );
double LW_IntToDouble( Int16 IVal );
double LW_abs( const double x );
double LW_sqrt( const double x );
double LW_sin( const double x );
double LW_cos( const double x );
double LW_arcsin( const double x );
double LW_arccos( const double x );

#endif
