import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

/**
 * c't TicTacToe Midlet
 * @author Karsten Violka, Lars Bremer
 */
public class TicCanvas extends Canvas {

  private static final int backColor = 0xffffff;
  private static final int lineColor = 0x000000;
  private static final int winColor = 0x880088;
  private static final int winTextColor = 0x222222;
  private static final int player1Color = 0xff0000;
  private static final int player2Color = 0x0000ff;

  private static final int PLAYER = -1;
  private static final int COMPUTER = 1;
  private static final int DRAW = 2;      // unentschieden

  private static final int MATT = 10;  // schachmatt, Konstante fr Suchalgorithmus

  int displayHeight;    // Gre des Displays
  int displayWidth;
  int xOff;
  int yOff;

  int currentPlayer;
  int winner;
  int[][] fields;       // das Spielfeld

  int iMaxTiefe;

  // die Zge werden in Reihenfolge mglicher Dreier ausprobiert
  // das Feld in der Mitte lt 4 zu, die Ecken je 3 und die Randfelder nur 2
  int iVorSort [][] = {{1,1},{0,0},{2,2},{0,2},{2,0},{1,0},{1,2},{2,1},{0,1}};

  // Konstruktor
  public TicCanvas() {
    fields = new int[3][3];
    displayHeight = getHeight();
    displayWidth = getWidth();
    xOff = displayWidth / 3;
    yOff = displayHeight / 3;
  }

  public void start(boolean computerBegins) {
    int i, j;

    //Feld lschen
    for(i=0 ;i<3; i++) {
      for(j=0; j<3; j++) {
        fields[i][j] = 0;
      }
    }
    winner = 0;
    if (computerBegins) {
      currentPlayer = COMPUTER;
      setComputer();
    } else {
      currentPlayer = PLAYER;
      repaint();
    }
  }

  public void paint(Graphics g)
  {
    int i, j;

    // Canvas lschen
    g.setColor(backColor);
    g.fillRect(0, 0, displayWidth-1, displayHeight-1);

    // Spielfeld zeichnen
    g.setColor(lineColor);
    g.drawLine(xOff, 0, xOff, displayHeight);
    g.drawLine(2*xOff, 0, 2*xOff, displayHeight);
    g.drawLine(0, yOff, displayWidth, yOff);
    g.drawLine(0,2*yOff, displayWidth, 2*yOff);

    for(i=0; i<3; i++) {
      for(j=0; j<3; j++) {
        switch(fields[i][j]) {
          case 0:         // leeres Feld
            g.setColor(backColor);
            g.fillRect(i*xOff+1, j*yOff+1,
                       xOff-1, yOff-1);
            break;
          case PLAYER:    // Spieler 1
            g.setColor(player1Color);
            g.drawLine(i*xOff+3, j*yOff + 3,
                       (i+1)*xOff-3, (j+1)*yOff-3);
            g.drawLine(i*xOff+3, (j+1)*yOff-3,
                       (i+1)*xOff-3, j*yOff+3);
            break;
          case COMPUTER:   // Spieler 2
            g.setColor(player2Color);
            g.drawArc(i*xOff+2, j*yOff+2,
                      xOff-4, yOff-4, 0, 360);
            break;
        }
      }
    }
    g.setColor(winTextColor);
    if(winner == DRAW) {         // untentschieden ?
      g.drawString("Unentschieden",displayWidth/2,displayHeight/2,g.HCENTER|g.BASELINE);
    } else if(winner == PLAYER) {
      g.drawString("Du hast gewonnen",displayWidth/2,displayHeight/2,g.HCENTER|g.BASELINE);
    } else if(winner == COMPUTER) {
      g.drawString("Ich habe gewonnen",displayWidth/2,displayHeight/2,g.HCENTER|g.BASELINE);
    }
  }

  // berschriebene Methode aus Canvas fr Tastendruck.
  public void keyPressed(int keyCode) {
    switch(keyCode) {
      case KEY_NUM1: setTic(0,0); break;
      case KEY_NUM2: setTic(1,0); break;
      case KEY_NUM3: setTic(2,0); break;
      case KEY_NUM4: setTic(0,1); break;
      case KEY_NUM5: setTic(1,1); break;
      case KEY_NUM6: setTic(2,1); break;
      case KEY_NUM7: setTic(0,2); break;
      case KEY_NUM8: setTic(1,2); break;
      case KEY_NUM9: setTic(2,2); break;
    }
  }

  // berschriebene Methode aus Canvas fr Stiftbedienung
  public void pointerPressed(int x, int y) {
    int ticX = x / (xOff);
    int ticY = y / (yOff);
    setTic(ticX, ticY);
  }

  // Zug setzen, liefert bei Erfolg true zurck.
  public boolean setTic(int x, int y) {
    if(winner > 0) {
      return false;
    }
    if(x<0 || x>3 || y <0 || y > 3) {
      return false;
    }
    if(fields[x][y] != 0) {
      return false;
    }
    fields[x][y] = currentPlayer;
    winner = testWinner();
    repaint();
    if (winner == 0) {
      if(currentPlayer == PLAYER) {
        currentPlayer = COMPUTER;
        setComputer();
      } else {
        currentPlayer = PLAYER;
      }
    }
    return true;
  }

  // liefert eine der Konstanten PLAYER, COMPUTER oder DRAW (fr untentschieden).
  private int testWinner() {
    if (gewonnen(PLAYER)) return PLAYER;
    if (gewonnen(COMPUTER)) return COMPUTER;

    int i, j;

    //unentschieden ?
    int empty = 0;
    for(i=0; i<3; i++) {
      for(j=0; j<3; j++) {
        if(fields[i][j] == 0) {
          empty++;
        }
      }
    }
    if (empty == 0) {
      return DRAW;
    }

    // kein Sieger
    return 0;
  }

  // Berechung eines Computer-Zuges
  private void setComputer() {
    int iBestX = 0;
    int iBestY = 0;
    int iBesteBewertung = -MATT-1;
    int iMoveCount = 0;
    int i, j;

    for (i=0; i<3; i++) {
      for (j=0; j<3; j++) {
        if (fields[i][j] != 0) {
        System.out.println(i + " " + j + " " + fields[i][j]);
          iMoveCount++;
        }
      }
    }
    if (iMoveCount >= 9) return;

    // Abbruchbedingung fr die rekursive Suche
    iMaxTiefe = (9-iMoveCount);
    int iWert = -10;

    // alle Zge aus dem vorsortierten Feld lesen
    for (int a=0; a<9; a++) {
      i = iVorSort[a][0];
      j = iVorSort[a][1];

      // ist das Feld noch frei?
      if (fields[i][j] == 0) {
        // Zug ausfhren
        fields[i][j] = currentPlayer;
        // gewinnt er oder mssen wir suchen?
        if (gewonnen(currentPlayer)) {
          iWert = MATT;
        } else {
          iWert = -alphabeta (2, -MATT, MATT, -currentPlayer);
        }
        // neuer bester Zug?
        if ( iWert > iBesteBewertung) {
          // Bewertung und Koordinaten merken
          iBesteBewertung = iWert;
          iBestX=i;
          iBestY=j;

          // gewinnt er vielleicht? dann Schleife abbrechen
          if (iBesteBewertung == MATT) {
            fields[i][j] = 0;
          }
        }
        // Zug zurcknehmen
        fields[i][j] = 0;
      }
    }
    setTic(iBestX, iBestY);
  } // ende setComputer()

  private int alphabeta(int iTiefe, int alpha, int beta, int iAmZug) {
    // ist die maximale Suchtiefe berschritten, muss das Feld voll sein
    if (iTiefe>iMaxTiefe) {
      return 0;
    }

    // erstmal vom schlimmstmglichen Fall ausgehen
    int iBesteBewertung = -MATT-1;

    // alle vorsortieren Felder testen
    for (int a=0;a<9;a++) {
      int i = iVorSort[a][0];
      int j = iVorSort[a][1];

      // wenn das Feld leer ist
      if (fields[i][j] == 0) {
        // Zug ausfhren
        fields[i][j] = iAmZug;

        // bei einem Sieg den Zug zurcknehmen und keine weiteren Zge untersuchen
        if (gewonnen(iAmZug)) {
          fields[i][j] = 0;
          return MATT;
        }

        // ansonsten Berechnung eine Ebene tiefer weiterfhren
        int iWert = -alphabeta(iTiefe+1, -beta, -alpha, -iAmZug);
        if (iWert > iBesteBewertung) iBesteBewertung = iWert;

        // Zug zurcknehmen
        fields[i][j] = 0;

        // Wenn die Bewertung >= beta ist, knnen wir die Suche abbrechen.
        // Normalerweise merkt man sich den Zug, um ihn beim nchsten
        // Erreichen dieser Suchtiefe als ersten zu probieren
        // aber das ist hier gar nicht ntig
        if (iWert >= beta) return iWert;

        // Ist sie grer Alpha, Alpha anpassen, weil das auf der
        // nchsthheren Suchtiefe einen besseren Beta-Cutoff geben kann
        if (iWert > alpha) alpha = iWert;
      }
    }
    // wenn das eintritt, haben wir keinen legalen Zug gefunden
    if (iBesteBewertung<-MATT) iBesteBewertung =0;
    return iBesteBewertung;
  }

  private boolean gewonnen(int iPlayer) {
    if (fields[1][1] == iPlayer) {
      if (fields[0][1] == iPlayer && fields[2][1] == iPlayer) return true;
      if (fields[1][0] == iPlayer && fields[1][2] == iPlayer) return true;
      if (fields[0][0] == iPlayer && fields[2][2] == iPlayer) return true;
      if (fields[0][2] == iPlayer && fields[2][0] == iPlayer) return true;
    }

    if (fields[0][0] == iPlayer) {
      if (fields[1][0] == iPlayer && fields[2][0] == iPlayer) return true;
      if (fields[0][1] == iPlayer && fields[0][2] == iPlayer) return true;
    }

    if (fields[2][2] == iPlayer) {
      if (fields[0][2] == iPlayer && fields[1][2] == iPlayer) return true;
      if (fields[2][0] == iPlayer && fields[2][1] == iPlayer) return true;
    }

    return false;
  }
}


