% Quicksort

	LOC 	Data_Segment
	GREG 	@
BUFFER	BYTE 	0	Anfang Einlesepuffer
BUFSIZE IS	32
	LOC	BUFFER+BUFSIZE
Arg	OCTA	BUFFER,BUFSIZE	Argumente fuer das Einlesen
1H	BYTE	"10000.txt",0	Dateiname
InFPar	OCTA	1B,TextRead	Parameterbereich

EOL	BYTE	#a,0		Zeilenumbruch fuer Ausgabe
BLANK	BYTE	" ",0
InFErr	BYTE	"Fehler beim Oeffnen der Datei",#a,0

	LOC	(@+8)&-8
Heap	GREG	@	Anfang des Heapbereichs

	LOC 	#100
;	GREG 	@
size 	IS	$0
i 	IS	$1
n 	IS	$2
arg1 	IS	$3	2 Register fuer Argumente
arg2 	IS	$4
error 	IS	$255
InFile	IS	2	Kanalnummer

; Einlesen der Daten
Main 	LDA	$255,InFPar
	TRAP	0,Fopen,InFile
	BNN	$255,2F		alles o.k.? unten weiter
	LDA	$255,InFErr	sonst Fehlermeldung ausgeben
	TRAP	0,Fputs,StdOut
	TRAP	0,0,0

2H	SET	size,0

1H	PUSHJ	n,LsZahl
	CMP	error,error,1
	BNP	error,1F
	STO	n,Heap,size
	ADD	size,size,8
; Ausgabe des unsortierten Feldes durch Entfernen der Kommentare
;	SET	arg2,n
;	PUSHJ	arg1,DrZahl
;	LDA	$255,EOL	Zeilenvorschub
;	TRAP	0,Fputs,StdOut
	JMP 1B

% Sortieren
1H 	SET	arg1,Heap	Argumente
	SET	arg2,size
	PUSHJ	n,QSort

; Naechste Zeile auskommentieren, um Ausgabe des sortierten Felds zu erzeugen
	JMP	Done
; ausgeben
	SET	i,0
	JMP	2F
1H 	LDO	arg1,Heap,i
	PUSHJ	n,DrZahl
	LDA	$255,EOL
	TRAP	0,Fputs,StdOut
	ADD	i,i,8
2H 	CMP	$255,i,size
	BN	$255,1B

Done	TRAP 0,Halt,0

; Jetzt kommen ein paar Unterprogramme
; Kleine Bereiche werden mit Insertion Sort sortiert:
	PREFIX :ISort:
; Parameter
A 	IS	$0
size 	IS	$1
; Lokale Register
i 	IS	$2	Offset fuer einzufuegende Elemente
j 	IS	$3	Laufindex fuer das Einfuegen
k 	IS	$4
x 	IS	$5
y 	IS	$6
tmp 	IS	$7

; Zuerst Positionierung auf zweites Element. Alle Elemente sind 8 Bytes gross.
; Daher werden die Indizes stets um Vielfache von 8 bewegt
:ISort	SET	i,8
	JMP	1F

2H 	LDO	x,A,i	naechstes einzufuegendes Element
	SET	j,i
	JMP	3F
5H 	STO	y,A,j	y rueckt eine Position weiter vor
	SET	j,k
3H 	BNP	j,4F
	SUBU	k,j,8
	LDO	y,A,k
	CMP	tmp,y,x
	BP	tmp,5B

4H 	STO	x,A,j	Element x hat seinen Platz gefunden
	ADDU	i,i,8	
1H 	CMP	tmp,i,size
	BN	tmp,2B
	POP	0,0	Kein Return-Wert


; QuickSort Feld A von OCTAs (Groesse in Bytes)
	PREFIX :QSort:
; Parameter
A 	IS	$0
size 	IS	$1

; Locale Register
return 	IS	$2
i 	IS	$3 	linker Index
; Nur VOR dem rekursive Aufruf benoetigen wir:
j 	IS	$4	rechter index
k 	IS	$5
l 	IS	$6	linkes Element
r 	IS	$7	rechtes Element
pivot 	IS	$8 	Pivot-Element fuer die Partitionierung
tmp 	IS	$9

; einige lokale Register werden auch zum Abliefern von Return-Werten benutzt
retarg 	IS	$4	Zum Speichern der aktuellen Return-Adresse
arg 	IS	$5	Argument: Bereichsanfang
sizearg IS	$6	Argument: Bereichsgroesse

; Kleine Bereiche werden mit Insertion Sort sortiert. 
; Deren Groesse kann hier eingestellt werden (typischerweise zwischen 4*8 und 20*8)
cutoff 	IS	10*8

:QSort	CMP	tmp,size,cutoff
	BN	tmp,:ISort	Also Insertion Sort durchfuehren

; Jetzt geht's endlich mit Quicksort los
4H 	GET	return,:rJ	Return-Adresse vor rekursivem Aufruf sichern

; Pivot bestimmen
; erstes, letztes und mittleres Element des Bereichs
	SET	i,0
	LDO	l,A,i
	SUBU	j,size,8
	LDO	r,A,j
	SR	k,size,1	mittleres Element
	LDO	pivot,A,k

; Erstes, letztes und mittleres Element sortieren...
	CMP	tmp,l,r
	BNP	tmp,1F

	XOR	l,l,r		tauschen von l und r
	XOR	r,l,r
	XOR	l,l,r

1H 	CMP	tmp,l,pivot
	BNP	tmp,1F

	XOR	l,l,pivot 	tauschen
	XOR	pivot,l,pivot
	XOR	l,l,pivot

1H 	CMP	tmp,pivot,r
	BNP	tmp,1F

	XOR	r,r,pivot 	tauschen
	XOR	pivot,r,pivot
	XOR	r,r,pivot

; .. und zurueckschreiben
1H 	STO	l,A,i
	STO	r,A,j
; Pivot als vorletztes Element speichern
	SUB	j,j,8
	LDO	r,A,j
	STO	r,A,k
	SET	k,j
	STO	pivot,A,k

; Partitionierung des Sortierbereichs
1H 	ADDU	i,i,8
	LDO	l,A,i
	CMP	tmp,l,pivot
	BN	tmp,1B

2H 	SUBU	j,j,8
	LDO	r,A,j
	CMP	tmp,r,pivot
	BP	tmp,2B

	CMP	tmp,i,j
	BNN	tmp,1F
	STO	l,A,j 	tauschen
	STO	r,A,i
	JMP	1B

1H 	STO	pivot,A,i	Pivot in die Mitte zurueck
	STO	l,A,k

	SET	arg,A
	SET	sizearg,i
	PUSHJ	retarg,:QSort 	erster rekursiver Aufruf

	ADDU	i,i,8
	LDA	A,A,i
	SUBU	size,size,i
	PUT	:rJ,return
	JMP	:QSort		zweiter (rekursiver) Aufruf

; Unterprogramm zum Ausgeben einer Zahl
	PREFIX	DrZahl
zahl 	IS	$0	Aufrufparameter Zahl
rest 	IS	$1 	Rest
vorz 	IS	$2	Vorzeichen
p 	IS	$3	Pointer

:DrZahl LDA	p,:BUFFER+:BUFSIZE-1
	SET	vorz,0		Vorzeichen auf 0 initializieren
	STBU	vorz,p,0	Buffer mit 0 abschliessen
	BNN	zahl,1F
	SET	vorz,'-'	Vorzeichen negativ
	NEG	zahl,zahl 	Zwei-Komplement bilden
1H      SUB	p,p,1 
	DIV	zahl,zahl,10
	GET	rest,:rR	Divisionsrest holen
	ADD	rest,rest,'0'
	STBU	rest,p,0
	BNZ	zahl,1B
	BZ	vorz,1F
	SUB	p,p,1
	STBU	vorz,p,0
1H	SET	$255,p
	TRAP	0,:Fputs,:StdOut
	POP	0,0

; Unterprogramm zum Einlesen einer Zahl
	PREFIX LsZahl
zahl 	IS	$0	Aufrufparameter Zahl
c 	IS	$1	Zeichen
vorz 	IS	$2	Vorzeichen
p 	IS	$3	Pointer
tmp 	IS	$4

:LsZahl LDA	$255,:Arg 
	TRAP	0,:Fgets,:InFile 
	LDA	p,:BUFFER
	SET	zahl,0
	SET	vorz,1
	LDBU	c,p,0
	CMP	tmp,c,'+'
	BZ	tmp,2F
	CMP	vorz,c,'-'
	BNZ	vorz,1F
2H 	ADDU	p,p,1
	LDBU	c,p,0
1H 	SUB	c,c,'0'
	BN	c,1F
	CMP	tmp,c,9
	BP	tmp,1F
	MUL	zahl,zahl,10
	ADD	zahl,zahl,c
	JMP	2B
1H 	BNZ	vorz,1F
	NEG	zahl,zahl
1H 	POP	1,0
