/* lochwuerfel.h by Harald Bgeholz */


class Bitvector
{
  unsigned int word;
 public:
  Bitvector::Bitvector(void) { word = 0; }
  void set(const Bitvector& bv) { word |= bv.word; }
  void set(int bit) { word |= 1 << bit; }
  bool test(const Bitvector& bv) const
    { return (word & bv.word) != 0; }
  bool test(int bit) const
    { return (word & (1 << bit)) != 0; }
  bool operator== (const Bitvector& bv) const
    { return word == bv.word; }
};


class Projection
{
  int fx, fy, fz, fo;
 public:
  void set(int ffx, int ffy, int ffz, int ffo)
    { fx = ffx; fy = ffy; fz = ffz; fo = ffo; }
  int to_bit(int x, int y, int z) const
    { return x*fx + y*fy + z*fz + fo; }
};


const int MAX_PARTPOS=288;

class Part
{
  bool hx0, hx1, hy0, hy1, hz00, hz10, hz01;

  void twist(void);
  void turn(int [3][3], 
            int, const Projection&);
  void place(int [3][3], 
             int, const Projection&, 
             int, const Projection&);
 public:
  Bitvector bvPos[MAX_PARTPOS];
  Bitvector bvHole[MAX_PARTPOS];
  Bitvector bvNonHole[MAX_PARTPOS];
  int nbv; // number of Bitvectors

  Part(bool, bool, bool, bool, bool, bool, bool);
};


class Solution
{
 public:
  int part[3][3][3];
};


const int nparts=9;
const int flatbits=27;

class Puzzle
{
  Part *parts;
  bool part_used[nparts];
  int nsolutions;
  int part_pos[nparts];

  void solve1(Bitvector, Bitvector, Bitvector, int);
  void found_solution(Bitvector);

 public:
  static int pos_to_bit(int, int, int);
  Puzzle(Part *);
  void solve(void);
};
