// Einfache Temperaturumrechnung. Based on Code by Jeffrey Fink.
// Kompilieren mit: javac -target 1.1 Temp.java

import java.awt.*;
import java.applet.Applet;
import java.awt.event.*;

public class Temp extends Applet implements AdjustmentListener {
  private Scrollbar tempConversion;
  private TextField tempText;
  
  public void init() {
    int min, max;
    try {
      min = Integer.valueOf(getParameter("min")).intValue();
      max = Integer.valueOf(getParameter("max")).intValue();
    } catch(NumberFormatException ex) {
      min = -30;
      max = 50;
    }
    tempConversion = new Scrollbar(Scrollbar.HORIZONTAL , 0, 1, min, max+1);
    tempConversion.addAdjustmentListener(this);
    tempConversion.setBlockIncrement(1);
    tempText = new TextField("Celsius/Fahrenheit-Umrechnung");
    tempText.setEditable(false);
    this.setLayout(new GridLayout(2, 1));
    this.add(tempConversion);
    this.add(tempText);
  }

  public void adjustmentValueChanged(AdjustmentEvent e) {
    float tempConversionValue = (float) tempConversion.getValue();    
    float fEquivalent = (tempConversionValue*9/5) + 32f;
    tempText.setText(tempConversionValue + " Grad Celsius = " + fEquivalent + " Grad Fahrenheit");
  }

  public String getAppletInfo() {
    return "Kleines Demo-Applet zur Temperatur-Umrechnung";
  }
}
