' USBSecure 1.0 fr Windows 2000/XP
' Copyright 2003 Robert Hohmann & c't
' Erkennt installierte USB-Gerte und vergleicht
' sie mit einer Liste zugelassener Gerte (USBSecure.cfg)
' Der Aufruf des Scripts mit dem Parameter "/c" erzeugt
' die Datei ExistingUsbDevices.txt, die als USBSecure.cfg 
' verwendet werden kann.  

CfgFileName = "C:\Programme\USBSecure\USBSecure.cfg"
TxtFileName = "C:\Programme\USBSecure\ExistingUsbDevices.txt"

Set Reg = GetObject("winmgmts:root\Default:StdRegProv")
Set Shell = CreateObject("Wscript.Shell")

Const HKEY_LOCAL_MACHINE = &H80000002
Dim UsbDevices(255)
Dim UsbDeviceTypes(255)
Dim UsbDeviceDescription(255)
Dim AllowedUsbDevices(255)


Do

    Key = "SYSTEM\CurrentControlSet\Enum\USB"
    return = Reg.EnumKey(HKEY_LOCAL_MACHINE, Key, subkeys)
    ' Im Array subkeys befinden sich jetzt alle USB-Gertetypen, d.h. alle Untereintrge
    ' von HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\USB
    
    DeviceTypeCounter = 0
    For Each subkey In subkeys
        UsbDeviceTypes(DeviceTypeCounter) = subkey
        DeviceTypeCounter = DeviceTypeCounter + 1
    Next


    ' Jetzt werden alle Untereintrge von HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\USB
    ' ausgelesen, um an die eigentlichen Gerteeintrge zu gelangen
    For DeviceCounter = 0 To DeviceTypeCounter - 1
        Key = "SYSTEM\CurrentControlSet\Enum\USB" & "\" & UsbDeviceTypes(DeviceCounter)
        return = Reg.EnumKey(HKEY_LOCAL_MACHINE, Key, subkeys)
        i = 0
        For Each subkey In subkeys
           UsbDevices(i) = subkey
           i = i + 1
        Next
        Key = "SYSTEM\CurrentControlSet\Enum\USB" & "\" & UsbDeviceTypes(DeviceCounter) & "\" & UsbDevices(0)
        Name = "DeviceDesc"
        return = Reg.GetStringValue(HKEY_LOCAL_MACHINE, Key, Name, Description)
        UsbDeviceDescription(DeviceCounter) = Description
    Next


    ' ExistingUsbDevices.txt erzeugen, falls Parameter /c mitgegeben wurde
    If WScript.Arguments.Count > 0 Then
        If WScript.Arguments(0) = "/c" Then
            Set fs = CreateObject("Scripting.FileSystemObject")
            Set TxtFile = fs.OpenTextFile(TxtFileName, 2, True)
            For j = 0 To DeviceTypeCounter - 1
                TxtFile.Writeline UsbDeviceDescription(j) & ": " & UsbDeviceTypes(j)
            Next
            TxtFile.Close
            Exit Do
        End If
    End If


    ' Einlesen der Datei USBSecure.cfg in das Array AllowedUsbDevices()
    Set fs = CreateObject("Scripting.FileSystemObject")
    Set CfgFile = fs.OpenTextFile(CfgFileName)
    AllowedDeviceCounter = 0
    Do Until CfgFile.AtEndOfStream
        AllowedUsbDevices(AllowedDeviceCounter) = CfgFile.ReadLine
        AllowedDeviceCounter = AllowedDeviceCounter + 1
    Loop
    CfgFile.Close


    ' Vergleich der beiden Arrays AllowedUsbDevices() und UsbDeviceDescription()
    For x = 0 To DeviceTypeCounter - 1
        OK = False
        For y = 0 To AllowedDeviceCounter - 1
            If UsbDeviceDescription(x) & ": " & UsbDeviceTypes(x) = AllowedUsbDevices(y) Then OK = True
        Next
        If OK = False Then ' Angeschlossenes Gert steht nicht in USBSecure.cfg
'            return = shell.Run("C:\Programme\USBSecure\shutdown.exe /L /T:90 /C", 1, True)
            return = MsgBox("Unzulssiges Gert an der USB-Schnittstelle: " & UsbDeviceDescription(x), 4096, "USBSecure")
        End If
    Next

    'Script nur alle 10 Sekunden ausfhren
    WScript.Sleep 10000

Loop

