Attribute VB_Name = "OL_Dateiberwachung"
Option Explicit

' 2003, Ralf Nebelo

'Deklaration der bentigten API-Funktionen
Private Declare Function SHBrowseForFolder Lib "shell32" (lpbi As BrowseInfo) As Long
Private Declare Function SHGetPathFromIDList Lib "shell32" (ByVal pidList As Long, ByVal lpBuffer As String) As Long
Private Declare Function lstrcat Lib "kernel32" Alias "lstrcatA" (ByVal lpString1 As String, ByVal lpString2 As String) As Long
Private Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As Any, ByVal lpWindowName As Any) As Long

'Deklaration benutzerdefinierter Variablentypen
Private Type BrowseInfo
   hwndOwner      As Long
   pIDLRoot       As Long
   pszDisplayName As Long
   lpszTitle      As Long
   ulFlags        As Long
   lpfnCallback   As Long
   lParam         As Long
   iImage         As Long
End Type

Global Const APP_NAME As String = "Dateiberwachung"

Public Sub DateiHinzufgen()
    'Userform frmDateiberwachung anzeigen
    frmDateiberwachung.Show
End Sub

Public Sub OrdnerPrfen()
    Dim objOrdner As MAPIFolder
    Dim objFSO As Object
    Dim objEintrag As JournalItem
    Dim strPfadname As String
    Dim strLetztenderung As String
    Dim strZielordner As String
    Dim intPos As Integer
    Dim strDateiname As String
    
    'Fehlerverfolgung ausschalten
    On Error Resume Next
    
    'Verweis auf berwachungsordner holen
    Set objOrdner = OrdnerVerweis(APP_NAME, Nothing, Nothing)
    'Wenn Ordner nicht existiert, dann...
    If objOrdner Is Nothing Then
        '... Makro verlassen
        Exit Sub
    End If
    
    'Verweis auf FileSystemObject-Objekt holen
    Set objFSO = CreateObject("Scripting.FileSystemObject")
    
    'Alle Eintrge des berwachungsordners durchlaufen
    For Each objEintrag In objOrdner.Items
        'Pfadname der zu berwachenden Datei aus "Betreff" lesen
        strPfadname = objEintrag.Subject
        'Wenn Datei nicht existiert, dann...
        If objFSO.FileExists(strPfadname) = False Then
            '... nachfragen, ob Eintrag gelscht werden soll. Wenn ja, dann...
            If MsgBox(strPfadname & " - Die Datei" & vbCr & "existiert nicht mehr oder ist derzeit nicht verfgbar." & vbCr & "berwachungseintrag lschen?", vbYesNoCancel + vbDefaultButton2 + vbInformation, APP_NAME) = vbYes Then
                '... Eintrag lschen
                objEintrag.Delete
            End If
        'Wenn Datei existiert, dann...
        Else
            'Datum der letzten nderung aus "Eintragstyp" lesen
            strLetztenderung = objEintrag.Type
            'Wenn Datum sich vom aktuellen Datum der letzten nderung unterscheidet, dann...
            If strLetztenderung <> objFSO.GetFile(strPfadname).DateLastModified Then
                '... wenn Meldung angezeigt werden soll, dann...
                If LCase(HolWert(objEintrag, "Meldung anzeigen:")) = "ja" Then
                    '... Versionsnderung melden
                    MsgBox strPfadname & " - Die Datei wurde gendert.", vbInformation, APP_NAME
                End If
                
                'Zielordner aus Eintrag lesen
                strZielordner = HolWert(objEintrag, "Zielordner:")
                'Wenn Zielordner angegeben, dann...
                If strZielordner <> "" Then
                    '... Dateiname aus Pfadnamen der zu berwachenden Datei isolieren
                    intPos = InStrRev(strPfadname, "\")
                    strDateiname = Right(strPfadname, Len(strPfadname) - intPos)
                    'Ggf. Backslash an Zielordner anhngen
                    If Right(strZielordner, 1) <> "\" Then
                        strZielordner = strZielordner & "\"
                    End If
                    
                    'Datei in Zielordner kopieren
                    objFSO.CopyFile strPfadname, strZielordner & strDateiname, True
                    'Im Falle eines Fehlers...
                    If Err <> 0 Then
                        '... Fehler melden
                        MsgBox strPfadname & " - Beim Kopieren der Datei ist ein Fehler aufgetreten.", vbCritical, APP_NAME
                        'Makro verlassen
                        Exit Sub
                    End If
                End If
                
                'Eintrag aktualisieren
                With objEintrag
                    'Neues Datum der letzten nderung in Feld "Eintragstyp" schreiben
                    .Type = objFSO.GetFile(strPfadname).DateLastModified
                    'Eintrag speichern
                    .Save
                End With
            End If
        End If
    Next
End Sub

'*************************************************************
'Hilfsroutinen
'*************************************************************

Public Function OrdnerVerweis(strOrdnername, objStartOrdner As Object, objTmpVerweis As MAPIFolder) As MAPIFolder
    Dim objUnterordner As MAPIFolder
    
    'Wenn kein Startordner angegeben, dann...
    If objStartOrdner Is Nothing Then
        '... "ganz unten" mit MAPI-Ordner beginnen
        Set objStartOrdner = GetNamespace("MAPI")
    End If
    
    'Alle Unterordner des Startordners durlaufen
    For Each objUnterordner In objStartOrdner.Folders
        'Wenn Ordnernamen bereinstimmen, dann...
        If LCase(objUnterordner.Name) = LCase(strOrdnername) Then
            '... Verweis im Argument objTmpVerweis zwischenspeichern
            Set objTmpVerweis = objUnterordner
        End If
        
        'Routine rekursiv fr alle Unterordner des Unterordners aufrufen
        Call OrdnerVerweis(strOrdnername, objUnterordner, objTmpVerweis)
    Next
    
    'Inhalt von objTmpVerweis als Funktionswert zurckgeben
    Set OrdnerVerweis = objTmpVerweis
End Function

Public Function Dateiffnen(strDlgTitel As String, strFilter As String) As String
    Dim objXL As Object
    Dim vntDatei As Variant
    
    'Fehlerverfolgung ausschalten
    On Error Resume Next
    
    'Verweis auf Excel holen
    Set objXL = CreateObject("Excel.Application")
    
    'Excel-eigenen Datei-ffnen-Dialog anzeigen
    vntDatei = objXL.GetOpenFilename(FileFilter:=strFilter, Title:=strDlgTitel)
    'Wenn Datei gewhlt, dann...
    If vntDatei <> False Then
        '... Dateiname zurckgeben
        Dateiffnen = vntDatei
    End If
    
    'Objektvariable freigeben
    Set objXL = Nothing
End Function

Public Function OrdnerWhlen(strDlgTitel As String, strFensterTitel As String) As String
    Dim lngIDList As Long
    Dim strBuffer As String
    Dim usrBrowseInfo As BrowseInfo

    'Dialogfeld konfigurieren
    With usrBrowseInfo
        'Userform als Eigner eintragen
        .hwndOwner = FindWindow(0&, strFensterTitel)
        'Titelfestlegen
        .lpszTitle = lstrcat(strDlgTitel, "")
        'Flags definieren
        .ulFlags = 3
    End With
    
    'Dialogfeld anzeigen
    lngIDList = SHBrowseForFolder(usrBrowseInfo)
    'Wenn Ordner gewhlt, dann...
    If (lngIDList) Then
        '... Pfad isolieren und...
        strBuffer = Space(260)
        SHGetPathFromIDList lngIDList, strBuffer
        strBuffer = Left(strBuffer, InStr(strBuffer, vbNullChar) - 1)
        '... als Funktionswert zurckgeben
        OrdnerWhlen = strBuffer
    End If
End Function

Private Function HolWert(objEintrag As JournalItem, strLabel As String) As String
    Dim intStart As Integer
    Dim intEnde As Integer
    
    'Nach strLabel suchen
    intStart = InStr(LCase(objEintrag.Body), LCase(strLabel))
    'Wenn strLabel nicht im Body-Text des Eintrags enthalten, dann...
    If intStart = 0 Then
        '... Funktion verlassen
        Exit Function
    'Wenn strLabel im Body-Text des Eintrags enthalten, dann...
    Else
        '... Start des zugehrigen Werts berechnen
        intStart = intStart + Len(strLabel)
        'Ende des zugehrigen Werts berechnen
        intEnde = InStr(intStart, objEintrag.Body, vbCr)
        'Wert zurckgeben
        HolWert = Trim(Mid(objEintrag.Body, intStart, intEnde - intStart))
    End If
End Function

