VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} frmDateiberwachung 
   Caption         =   "frmDateiberwachung"
   ClientHeight    =   3090
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   5040
   OleObjectBlob   =   "frmDateiberwachung.frx":0000
   StartUpPosition =   1  'Fenstermitte
End
Attribute VB_Name = "frmDateiberwachung"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' 2003, Ralf Nebelo

Private Sub UserForm_Initialize()
    'Dialogtitel festlegen
    Me.Caption = APP_NAME
        
    'Einstellungen der Steuerelemente aus Registry lesen
    chkMeldung = CBool(GetSetting(APPNAME:="VBAMakros", Section:=APP_NAME, Key:="Meldung", Default:="Wahr"))
    chkKopieren.Value = CBool(GetSetting(APPNAME:="VBAMakros", Section:=APP_NAME, Key:="Kopieren", Default:="Falsch"))
    txtZielordner.Text = GetSetting(APPNAME:="VBAMakros", Section:=APP_NAME, Key:="Zielordner", Default:="")
    
    'Klick auf Kontrollkstchen "chkKopieren" simulieren
    Call chkKopieren_Click
End Sub

Private Sub cmdDatei_Click()
    'Datei whlen
    txtDatei.Text = Dateiffnen("Datei zur berwachung whlen", "Alle Dateien (*.*), *.*")
End Sub

Private Sub chkKopieren_Click()
    'Steuerelemente "txtZielordner" und "cmdZielordner" je nach
    'Status von "chkKopieren" aktivieren oder deaktivieren
    txtZielordner.Enabled = chkKopieren.Value
    cmdZielordner.Enabled = chkKopieren.Value
End Sub

Private Sub cmdZielordner_Click()
    'Zielordner whlen
    txtZielordner.Text = OrdnerWhlen("Whlen Sie den Zielordner:", Me.Caption)
End Sub

Private Sub cmdOK_Click()
    Dim objFSO As Object
    Dim objOrdner As MAPIFolder
    Dim objEintrag As JournalItem
    
    'Fehlerverfolgung ausschalten
    On Error Resume Next
    
    'Verweis auf FileSystemObject-Objekt holen
    Set objFSO = CreateObject("Scripting.FileSystemObject")
    
    'Wenn Datei nicht angegeben oder Datei nicht existiert, dann...
    If txtDatei.Text = "" Or objFSO.FileExists(txtDatei.Text) = False Then
        '... Fehler melden
        MsgBox "Bitte whlen Sie eine vorhandene Datei.", vbInformation, APP_NAME
        'Fokus in zugehriges Eingabefeld setzen
        txtDatei.SetFocus
        'Prozedur verlassen
        Exit Sub
    End If
    
    'Wenn "chkKopieren" eingeschaltet aber keine Zielordner angegeben ist, dann...
    If chkKopieren.Value = True And txtZielordner.Value = "" Then
        '... Fehler melden
        MsgBox "Bitte whlen Sie einen gltigen Zielordner.", vbInformation, APP_NAME
        'Fokus in zugehriges Eingabefeld setzen
        txtZielordner.SetFocus
        'Prozedur verlassen
        Exit Sub
    End If

    'Wenn weder "chkMeldung" noch "chkKopieren" eingeschaltet sind, dann...
    If chkMeldung.Value = False And chkKopieren.Value = False Then
        '... Fehler melden
        MsgBox "Bitte whlen Sie mindestens eine Aktion.", vbInformation, APP_NAME
        'Prozedur verlassen
        Exit Sub
    End If
    
    'Verweis auf berwachungsordner holen
    Set objOrdner = OrdnerVerweis(APP_NAME, Nothing, Nothing)
    'Wenn Ordner nicht existiert, dann...
    If objOrdner Is Nothing Then
        '... im Ordner "Persnliche Ordner" neu anlegen
        Set objOrdner = OrdnerVerweis("Persnliche Ordner", Nothing, Nothing).Folders.Add(APP_NAME, olFolderJournal)
        'Wenn Anlegen gescheitert, dann...
        If objOrdner Is Nothing Then
            '... Fehler melden
            MsgBox "Fehler beim Anlegen des berwachungsordners.", vbCritical, APP_NAME
            'Userform entladen
            Unload Me
        End If
    End If
    
    'Neuen Eintrag im berwachungsordner anlegen
    Set objEintrag = objOrdner.Items.Add(olJournalItem)
    With objEintrag
        'Dateipfad als "Betreff" definieren
        .Subject = txtDatei.Text
        'Datum der letzten nderung unter "Eintragstyp" speichern
        .Type = objFSO.GetFile(txtDatei.Text).DateLastModified
        
        'Wenn "chkMeldung" eingeschaltet ist, dann...
        If chkMeldung.Value = True Then
            '... entsprechende Message in Eintragstext schreiben
            .Body = "Meldung anzeigen: ja" & vbCr
        End If
        
        'Wenn "chkKopieren" eingeschaltet ist, dann...
        If chkKopieren.Value = True Then
            '... Zielordner in Eintragstext schreiben
            .Body = .Body & "Zielordner: " & txtZielordner.Text & vbCr
        End If
        
        'Eintrag speichern
        .Save
    End With
    
    'Einstellungen der Steuerelemente in Registry sichern
    Call SaveSetting(APPNAME:="VBAMakros", Section:=APP_NAME, Key:="Zielordner", Setting:=txtZielordner.Text)
    Call SaveSetting(APPNAME:="VBAMakros", Section:=APP_NAME, Key:="Meldung", Setting:=chkMeldung.Value)
    Call SaveSetting(APPNAME:="VBAMakros", Section:=APP_NAME, Key:="Kopieren", Setting:=chkKopieren.Value)
    
    'Userform entladen
    Unload Me
End Sub

Private Sub cmdCancel_Click()
    'Userform entladen
    Unload Me
End Sub

