package com.objectfab.ctarticle;

/**
 * Dieses Interface abstrahiert von einer zeilenorientierten
 * Datenquelle (z.B. einem Datenbank-Record, einer Zeile einer
 * CSV-Datei, einem XML-Element mit seinen Attributen, ...).
 *
 * Es ist sehr wahrscheinlich, dass diese Schnittstelle von
 * einer Klasse implementiert wird, die auch mehrere Zeilen
 * adressieren kann. Fuer den hier betrachteten Ausschnitt
 * ist das jedoch nicht notwendig, deshalb wurde auf diese
 * Funktionalitaet verzichtet.
 */
public interface RowReader {
  /**
   * Ermittelt die Spaltenzahl der Zeile.
   *
   * @return Anzahl der Spalten
   */
  public int getNumColumns();

  /**
   * Ermittelt den Wert in einer bestimmten Spalte der Zeile.
   *
   * @param column Spalte (0 bis numColumns-1)
   * @return Zahlenwert der gegebenen Spalte als ganze Zahl.
   */
  public int getRowValue(int column);
}
