package com.objectfab.ctarticle;

public class SampleClass4 {
  /**
   * Bringt eine Dezimalzahl rechtsbuendig in einer
   * Zeichenkette vorgegebener Laenge unter. Reicht
   * der Platz nicht, wird eine Ausnahme ausgeloest.
   *
   * @param len die Laenge des String
   * @param a   die darzustellende Zahl
   * @return    der rechtsbuendig formatierte String
   */
  public String getRightAlignedIntString(int len, int a) {
    StringBuffer sb = new StringBuffer();
    String content  = Integer.toString(a);
    int numDigits   = content.length();

    if (len<numDigits) {
      throw new IllegalArgumentException("Zahl ist zu lang");
    }

    int numSpaces = len - numDigits;

    for (int i = 0; i < numSpaces; i++) {
      sb.append(" ");
    }
    sb.append(content);
    return sb.toString();
  }

  /**
   * Berechnung einer Tabellenzeile im Textformat (Leerzeichen als
   * Fuellzeichen). Die Methode baut auf der Formatierung einer Zahl
   * in einen rechtsbuendigen String (getRightAlignedIntString) auf.
   * Als Quelle der Daten wird ein anderes Objekt uebergeben, das
   * aber bis zu einem Interface mit nur zwei Methoden abstrahiert ist.
   * So wird es einfacher, fuer Testzwecke einmal ein anderes Objekt
   * zu uebergeben: ein Mock-Objekt.
   *
   * @param rowReader   eine Referenz auf eine Quelle fuer die Daten einer Zeile
   * @param columnWidth Spaltenbreite
   * @return String mit den rechtsbuendig formatierten Zahlen einer Zeile
   */
  public String getRowString(RowReader rowReader, int columnWidth) {
    StringBuffer sb = new StringBuffer();
    int columns;
    int value;

    if (rowReader != null) {
      columns = rowReader.getNumColumns();
      for (int i=0; i<columns; i++) {
        value = rowReader.getRowValue(i);
        sb.append(getRightAlignedIntString(columnWidth, value));
      }
    }
    return sb.toString();
  }
}
