package com.objectfab.ctarticle;

import junit.framework.TestCase;

public class SampleClass1Test extends TestCase {

  public SampleClass1Test(String name) {
    super(name);
  }

  public void testNumOfDecimalDigits() {
    SampleClass1 sample = new SampleClass1();

    assertEquals(1, sample.numOfDecimalDigits(0));
    assertEquals(1, sample.numOfDecimalDigits(1));
    assertEquals(1, sample.numOfDecimalDigits(9));
    assertEquals(2, sample.numOfDecimalDigits(10));
    assertEquals(2, sample.numOfDecimalDigits(99));
    assertEquals(3, sample.numOfDecimalDigits(100));
    assertEquals(3, sample.numOfDecimalDigits(999));
    assertEquals(4, sample.numOfDecimalDigits(1000));
    assertEquals(10, sample.numOfDecimalDigits(Integer.MAX_VALUE));

    assertEquals( 1, sample.numOfDecimalDigits(  -1));
    assertEquals( 1, sample.numOfDecimalDigits(  -9));
    assertEquals( 2, sample.numOfDecimalDigits( -10));
    assertEquals( 3, sample.numOfDecimalDigits( -100));
    assertEquals(10, sample.numOfDecimalDigits(Integer.MIN_VALUE));

    sample = null;
  }

  public void testGetRightAlignedIntString() {
    SampleClass1 sample = new SampleClass1();

    assertEquals("          0", sample.getRightAlignedIntString(0));
    assertEquals("          1", sample.getRightAlignedIntString(1));
    assertEquals("          2", sample.getRightAlignedIntString(2));
    assertEquals("         10", sample.getRightAlignedIntString(10));
    assertEquals("        100", sample.getRightAlignedIntString(100));
    assertEquals("       1000", sample.getRightAlignedIntString(1000));
    assertEquals("         -1", sample.getRightAlignedIntString(-1));
    assertEquals("       -999", sample.getRightAlignedIntString(-999));
    assertEquals(" 2147483647", sample.getRightAlignedIntString(Integer.MAX_VALUE));
    assertEquals("-2147483648", sample.getRightAlignedIntString(Integer.MIN_VALUE));

    sample = null;
  }
}
