# Perl-Skript zur hnlichkeitssuche, (c) 2003 Heise Verlag & Tobias Engler
#! /usr/bin/perl
use Text::German; # der einfache Stemmer kann bei Bedarf unten aktiviert werden

# Beispiel-Dokumente; es empfiehlt sich, hier eine Datenbank anzubinden
@docs = ("Der neue Fujitsu-Siemens-Rechner mit Pentium 4 im c't-Test.", "Bei 256 MB RAM wird der Speicher recht knapp.", "Der grne Toaster hat ein robustes Gehuse.");
# kurze beispielhafte Stopp-Wort-Liste
@stop_words = ("ab", "an", "auf", "bei", "da", "das", "der", "die", "dort", "durch", "ein", "einen", "hat", "in", "ist", "kann", "mit", "oder", "oft", "zu");

# Anfrage einlesen und Vektor berechnen
$query = "Welcher Rechner hat einen Pentium 4, 256 MB RAM und ein robustes Gehuse?";
$query_vector = construct_vector($query);

foreach $doc (@docs) # Fr jedes Dokument den zugehrigen Vektor berechnen
{	$temp_vector = construct_vector($doc);
	push(@vectors, $temp_vector);													}

foreach $vector (@vectors) # Vektoren mit Query vergleichen und Abstandsma berechnen
{	$doc_count ++;
	$results{$doc_count} = cosine_measure($vector, $query_vector);					}

# Ergebnisse sortieren, beste zuerst
print "\nText\tGewichtung\tQuery: " . substr($query, 0, 40) . "\n" . '-'x75 . "\n";
foreach $result (reverse sort { $results{$a} <=> $results{$b} } keys %results)
{	print "$result\t" . substr($results{$result}, 0, 6) . "\t\t"
	. substr($docs[$result - 1], 0, 40) . "\n";										}
print "\n";

sub cosine_measure($vector, $query_vector)
{
	my ($doc_v, $query_v, $query_sum, $doc_sum, $term_sum) = @_;
	local %doc_index = %{$doc_v}, local %query_index = %{$query_v};
	
	foreach $qterm (keys %query_index) # Summe im Zhler bilden
	{	if (exists $doc_index{$qterm})
		{	$term_sum += $doc_index{$qterm} * $query_index{$qterm};					}
		# Summe der Q-Terme im Nenner bilden
		$query_sum += ($query_index{$qterm} ** 2);									}
	
	foreach $dterm (keys %doc_index) # Summe der D-Terme im Nenner bilden
	{	$doc_sum += ($doc_index{$dterm} ** 2);										}
	
	return ($term_sum / (sqrt($query_sum * $doc_sum)));	# Koeffizient bilden
}

sub construct_vector()
{
	my $this_doc = shift, my %index;
	
	$this_doc =~ s/[\,\.\!\?]/ /g; # (winziger) Prprozessor
	
	# Terme aus Dokument extrahieren, durch - getrennte Komposita werden erkannt
	@terms = split(/[ \-]+/, $this_doc);
	
	foreach $term (@terms) # k-dimensionalen Vektorraum aufziehen
	{	next if (grep(/$term/, @stop_words)); # Stopp-Wort-Liste beachten	
		# print "Stamm: " . Text::German::reduce($term) . "\n"; 
		# hier evtl. anderen Stemmer einsetzen und $term
		# reduzieren oder Gewichtung regelbasiert anpassen
		$index{$term} ++;															}
	
	return \%index;
}
