'
' This script will edit the XMLTV file to change the channel format from the 
' new format back to the old.
'
'
' Usage: FixListings <Path and filename of XMLTV listings>
'
' Written by avekevin
' Released July 4, 2003
' Version 1.10
'
' Change Log:
'    v1.01
'	* Script now only pulls first 3 numbers for channel number.  The rest are used
'	  for channel call letters
'	
'    v1.00
'	* Initial release
'
'
	
Function ReplaceString (sourceFilename) 
	' Open XML file
	Set fso = CreateObject("Scripting.FileSystemObject")
	fileExists = fso.FileExists(sourceFilename)

	IF NOT fileExists THEN
		set shell = CreateObject("WScript.Shell")
		shell.PopUp "File not found!",0,"XMLTV Format Changer",16
		Exit Function
	END IF

	' Open source file
	set sourceFile = fso.OpenTextFile(sourceFilename,1,False)

	' Path is correct, now open temp file for writing
	tempFilename = fso.GetTempName

	' Open temp file
	set tempFile = fso.OpenTextFile(tempFilename,2,True)

	Do Until sourceFile.AtEndOfStream
		' Read line from source file
		lineContent = sourceFile.ReadLine

		' Replace orig string with new string
		set RegX = NEW RegExp
		RegX.Global = True
		RegX.IgnoreCase = True
		RegX.Pattern = "(id|channel)(="")C([0-9]{1,3})(.*)\.zap2it\.com"
		replaceRegExp = "$1$2$3 $4"
		
		' Replace string with short version of channel name, if found
		newLineContent = RegX.Replace(lineContent,replaceRegExp)

		' If a change was made above, make channel call letters uppercase
		If StrComp(newLineContent,lineContent,0) Then
			RegX.Pattern = "(id|channel)=""([0-9]{1,3})(.*)"""
			set findMatches = RegX.Execute(newLineContent)

			For Each Match in findMatches
				newLineContent = Replace(newLineContent,Match,UCase(Match))
				newLineContent = Replace(newLineContent,"ID","id")
				newLineContent = Replace(newLineContent,"CHANNEL","channel")
			Next
		End IF

		'Output result to temp file			
		tempFile.WriteLine(newLineContent)
	Loop

	' Close files
	tempFile.close
	sourceFile.close
	
	' Delete source file
	fso.DeleteFile sourceFilename,True
	
	' Rename temp file to source file
	fso.MoveFile tempFilename,sourceFilename
End Function

'
' Main function
'

' Get command line arguments
set commandLineArgs = WScript.Arguments

' If the path is provided, then run otherwise give an error
If commandLineArgs.length Then
	ReplaceString(commandLineArgs(0))
Else
	set shell = CreateObject("WScript.Shell")
	shell.PopUp "Source file name and path not provided!",0,"XMLTV Format Changer",16
End If

'
' End of main function
'