#if HAVE_CONFIG_H
# include <config.h>
#endif

#if HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#if HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif
#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#if HAVE_STDLIB_H
#include <stdlib.h>
#endif
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <stdio.h>
#if HAVE_STRING_H
# include <string.h>
#endif
#include <errno.h>

#ifndef DEFAULT_TIMEOUT
#define DEFAULT_TIMEOUT        10
#endif

int
wait_for_event (char **event)
{
  fd_set fds;
  int result;
  struct timeval to;
  struct timeval *timeout = NULL;

  to.tv_sec = DEFAULT_TIMEOUT;
  to.tv_usec = 0;

#if DEFAULT_TIMEOUT >= 0
  timeout = &to;
#endif

  FD_ZERO (&fds);
  FD_SET (0, &fds);

  result = select (FD_SETSIZE, &fds, NULL, NULL, timeout);
  if (result > 0)
    {
      if (timeout)
        return asprintf (event, "Fertig: Daten nach %i Sekunden",
                         DEFAULT_TIMEOUT - timeout->tv_sec);
      else
        return asprintf (event, "Fertig: Daten bereit");
    }
  if (result == 0)
    {
      if (timeout)
        return asprintf (event, "Timeout: %i Sekunden verstrichen",
                         DEFAULT_TIMEOUT);
      else
        return asprintf (event, "Fehler: Select unterbrochen");
    }
#if HAVE_STRERROR
  return asprintf (event, "Fehler: %s", strerror (errno));
#else
  return asprintf (event, "Fehler: %i", errno);
#endif
}
