# include <sys/types.h>
#include <sys/select.h>
#  include <sys/time.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
# include <string.h>
#include <errno.h>

#ifndef DEFAULT_TIMEOUT
#define DEFAULT_TIMEOUT        10
#endif

int
wait_for_event (char **event)
{
  fd_set fds;
  int result;
  struct timeval to;
  struct timeval *timeout = NULL;

  to.tv_sec = DEFAULT_TIMEOUT;
  to.tv_usec = 0;

#if DEFAULT_TIMEOUT >= 0
  timeout = &to;
#endif

  FD_ZERO (&fds);
  FD_SET (0, &fds);

  result = select (FD_SETSIZE, &fds, NULL, NULL, timeout);
  if (result > 0)
    {
      if (timeout)
        return asprintf (event, "Fertig: Daten nach %i Sekunden",
                         DEFAULT_TIMEOUT - timeout->tv_sec);
      else
        return asprintf (event, "Fertig: Daten bereit");
    }
  if (result == 0)
    {
      if (timeout)
        return asprintf (event, "Timeout: %i Sekunden verstrichen",
                         DEFAULT_TIMEOUT);
      else
        return asprintf (event, "Fehler: Select unterbrochen");
    }
  return asprintf (event, "Fehler: %s", strerror (errno));
}
