// PulseAllDemo.cs: Programm demonstriert den Wait-Mechanismus der Klasse Monitor.
// Pulse weckt den einen wartenden Thread auf (Reihenfolge nicht determiniert)
// PulseAll weckt alle schlafenden Threads auf.
// Experimente:
// Das Symbol MULTI schaltet zwischen einem und mehreren wartenden Hintergrund-Threads um.
// Wird das Symbol SLEEP auskommentiert, erfolgt Pulse/PulseALL noch bevor die Timer-Threads 
// Wait ausfhren und verhallt ungehrt.

#define MULTI
#define SLEEP
using System;
using System.Threading;

namespace PulseAllDemo
{
	class Class1
	{
		[STAThread]
		static void Main(string[] args)
		{ 
      // Timer-Thread starten. 100 ms Verzgerung, keine Wiederholung
      Timer t1 = new Timer(new TimerCallback(MySyncMethod), "Eins", 100, 0);
#if MULTI 
			Timer t2 = new Timer(new TimerCallback(MySyncMethod), "Zwei", 100, 0);
			Timer t3 = new Timer(new TimerCallback(MySyncMethod), "Drei", 100, 0);
       
#if SLEEP
      // Pause. Danach haben alle Timer-Threads Wait ausgefhrt und warten
			Thread.Sleep(2000);
#endif
			lock(typeof(Class1))
			{
      // Erlsen wartender Threads. 
      // Ein Thread, der bis zu diesem Zeitpunkt noch kein Wait ausgefhrt hat, 
      // bekommt Pulse im Nachhinein nicht mit und wird NICHT erlst!
			  Monitor.PulseAll(typeof(Class1));
				Console.WriteLine("PulseAll");
			}
#else
#if SLEEP
			Thread.Sleep(2000);
#endif
      lock(typeof(Class1))
			{
				Monitor.Pulse(typeof(Class1));
				Console.WriteLine("Pulsed");
			}

#endif
      Console.ReadLine();
		}

    // Timer-Routine
    public static void MySyncMethod(object Context)
		{ 
			Console.WriteLine(Context + ": Enter");
			lock(typeof(Class1))
			{
				Console.WriteLine(Context + ": Got Lock, Enter Wait");
        // Funktioniert nur, wenn Pulse DANACH kommt,
        // sonst hngt der Thread ewig!
        Monitor.Wait(typeof(Class1));
				Console.WriteLine(Context + ": End Wait");
				Thread.Sleep(3000);
				Console.WriteLine(Context + ": Release Lock");
			}
		}
	}
}
