// BeginInvokeControlDemo.cs -- Demo fr asynchronen Aufruf einer
// Methode im Kontext des UI-Threads aus dem Hintergrund
//   - Aufruf geschieht mittels Control.BeginInvoke() von einem
//     Hintergrundthread aus. 
//   - Synchronisierte Auswertung des Rckgabewerts mittels EndInvoke.

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading; 

namespace BeginInvokeControlDemo
{
	public class Form1 : System.Windows.Forms.Form
	{
    private System.Windows.Forms.Button button1;
    private System.Windows.Forms.ToolTip toolTip1;
    private System.Windows.Forms.TextBox textBox1;
    private System.ComponentModel.IContainer components;

		public Form1()
		{
			InitializeComponent();
		}
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Vom Windows Form-Designer generierter Code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
      this.components = new System.ComponentModel.Container();
      this.button1 = new System.Windows.Forms.Button();
      this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
      this.textBox1 = new System.Windows.Forms.TextBox();
      this.SuspendLayout();
      // 
      // button1
      // 
      this.button1.Location = new System.Drawing.Point(8, 24);
      this.button1.Name = "button1";
      this.button1.Size = new System.Drawing.Size(272, 32);
      this.button1.TabIndex = 0;
      this.button1.Text = "Starte ThreadPool-Thread";
      this.toolTip1.SetToolTip(this.button1, "startet Thread, der BeginInvoke des Formulars ausfhrt");
      this.button1.Click += new System.EventHandler(this.button1_Click);
      // 
      // textBox1
      // 
      this.textBox1.Location = new System.Drawing.Point(8, 80);
      this.textBox1.Multiline = true;
      this.textBox1.Name = "textBox1";
      this.textBox1.Size = new System.Drawing.Size(272, 176);
      this.textBox1.TabIndex = 1;
      this.textBox1.Text = "";
      // 
      // Form1
      // 
      this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
      this.ClientSize = new System.Drawing.Size(292, 270);
      this.Controls.Add(this.textBox1);
      this.Controls.Add(this.button1);
      this.Name = "Form1";
      this.Text = "BeginInvoke - Control";
      this.ResumeLayout(false);

    }
		#endregion
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

    // Worker Thread wird als Threadpool-Thread im Hintergrund
    // ausgefhrt und ruft die Methode InvokeMethod im Kontext des
    // UI-Thread auf.
    private void Worker(object o)
    {
      Output("Worker ThreadID :" + 
        AppDomain.GetCurrentThreadId().ToString());

      // asynchroner Aufruf
      IAsyncResult aRes = 
        this.BeginInvoke(new SynchDelegate(InvokeMethod));
      Output("Worker: Warte nun bei EndInvoke() auf Rckgabewert");

      // Optional: Funktionsergebnis synchronisiert entgegennehmen
      string res = (string) EndInvoke(aRes); 
      Output("Worker: Rckgabewert ist: " + res); 
    }

    // Delegattyp fr die mit Control.BeginInvoke ausgefhrte Methode
    private delegate string SynchDelegate(); 

    // wird von Threadpool-Thread im Kontext des UI-Thread
    // (synchronisiert) aufgerufen
    private string InvokeMethod()
    {
      Output("InvokeMethod ThreadID :" + 
        AppDomain.GetCurrentThreadId().ToString());
      MessageBox.Show(
        "im Kontext des UI-Thread aufgerufen\nThread-ID: " + 
        AppDomain.GetCurrentThreadId().ToString(), "InvokeMethod");
      return "InvokeMethod ist nun fertig"; 
    }

    // startet die Methode Worker als Threadpool-Thread 
    private void button1_Click(object sender, System.EventArgs e)
    {
      Output("button1_Click: Haupt-ThreadID :" + 
        AppDomain.GetCurrentThreadId().ToString());
      ThreadPool.QueueUserWorkItem(new WaitCallback(Worker)); 
    }
    // Hilfsmethode fr die Ausgabe von Statusmeldungen
    public void Output(string s)
    {
      lock(this)
      {
        textBox1.Text += s + "\r\n"; 
        textBox1.Refresh(); 
      }
    }
  }
}
