// BeginInvokeDemo.cs -- Demoprogramm fr die asynchrone Ausfhrung
// einer Methode ber BeginInvoke() eines Delegaten fr diese Methode. 
//   1. Aufruf mit Rckruf, Parameterbergabe, AsyncState-Parameter
//      fr Rckruf und synchronisierter Auswertung des Funktionswerts
//   2. Aufruf ohne weitere Synchronisation und ohne Rckruf 

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace BeginInvokeDemo
{
  public class Form1 : System.Windows.Forms.Form
  {
    private System.Windows.Forms.ToolTip toolTip1;
    private System.Windows.Forms.TextBox textBox1;
    private System.Windows.Forms.Button bAsyncCB;
    private System.Windows.Forms.Button bAsyncNoCB;
    private System.ComponentModel.IContainer components;

    public Form1()
    {
      InitializeComponent();
    }
    protected override void Dispose( bool disposing )
    {
      if( disposing )
      {
        if (components != null) 
        {
          components.Dispose();
        }
      }
      base.Dispose( disposing );
    }

    #region Vom Windows Form-Designer generierter Code
    /// <summary>
    /// Erforderliche Methode fr die Designeruntersttzung. 
    /// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
    /// </summary>
    private void InitializeComponent()
    {
		this.components = new System.ComponentModel.Container();
		this.bAsyncCB = new System.Windows.Forms.Button();
		this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
		this.bAsyncNoCB = new System.Windows.Forms.Button();
		this.textBox1 = new System.Windows.Forms.TextBox();
		this.SuspendLayout();
		// 
		// bAsyncCB
		// 
		this.bAsyncCB.Location = new System.Drawing.Point(16, 8);
		this.bAsyncCB.Name = "bAsyncCB";
		this.bAsyncCB.Size = new System.Drawing.Size(264, 32);
		this.bAsyncCB.TabIndex = 0;
		this.bAsyncCB.Text = "Asynchroner Methodenaufruf mit Rckruf und synchronisierter bernahme des Funktio" +
			"nswertes";
		this.toolTip1.SetToolTip(this.bAsyncCB, "Ruft Methode via Delegat asynchron vom Haupt-Thread aus auf. Am Schluss erfolgt R" +
			"ckruf.");
		this.bAsyncCB.Click += new System.EventHandler(this.bAsyncCB_Click);
		// 
		// bAsyncNoCB
		// 
		this.bAsyncNoCB.Location = new System.Drawing.Point(16, 48);
		this.bAsyncNoCB.Name = "bAsyncNoCB";
		this.bAsyncNoCB.Size = new System.Drawing.Size(264, 32);
		this.bAsyncNoCB.TabIndex = 2;
		this.bAsyncNoCB.Text = "Asynchroner Methodenaufruf ohne Schnickschnack";
		this.toolTip1.SetToolTip(this.bAsyncNoCB, "Ruft Methode via Delegat asynchron vom Haupt-Thread aus auf.");
		this.bAsyncNoCB.Click += new System.EventHandler(this.bAsyncNoCB_Click);
		// 
		// textBox1
		// 
		this.textBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
			| System.Windows.Forms.AnchorStyles.Left) 
			| System.Windows.Forms.AnchorStyles.Right)));
		this.textBox1.Location = new System.Drawing.Point(16, 88);
		this.textBox1.Multiline = true;
		this.textBox1.Name = "textBox1";
		this.textBox1.Size = new System.Drawing.Size(264, 160);
		this.textBox1.TabIndex = 1;
		this.textBox1.Text = "";
		// 
		// Form1
		// 
		this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
		this.ClientSize = new System.Drawing.Size(304, 270);
		this.Controls.Add(this.bAsyncNoCB);
		this.Controls.Add(this.textBox1);
		this.Controls.Add(this.bAsyncCB);
		this.Name = "Form1";
		this.Text = "BeginInvoke mit Delegaten";
		this.ResumeLayout(false);

	}
    #endregion

    [STAThread]
    static void Main() 
    {
      Application.Run(new Form1());
    }

    // Delegat fr asynchron auszufhrende Methode
    public delegate string myAsyncDelegate (string s); 

    // Asynchron auszufhrende Methode
    public string AsyncMeth(string info)
    {
      Output("AsyncMeth ThreadID :" +
        AppDomain.GetCurrentThreadId().ToString()); 
      MessageBox.Show(info, "AsyncMeth"); 
      return "Rckgabewert"; 
    }

    // Methode wird als Rckruf verwendet und verkndet das Ende des
    // asynchronen Aufrufs
    public void ResultCB(IAsyncResult asyncRes)
    {
      Output("ResultCB ThreadID:" +
        AppDomain.GetCurrentThreadId().ToString()); 
      MessageBox.Show("Rckruf: Hier noch " +
        asyncRes.AsyncState, "ResultCB"); 
    }

    // Hilfsmethode fr die Ausgabe von Statusmeldungen
    public void Output(string s)
    {
      lock(this)
      {
        textBox1.Text += s + "\r\n"; 
        textBox1.Refresh(); 
      }
    }

    // Aufruf von AsyncMeth ohne weitere Synchronisation
    // und ohne Rckruf 
    private void bAsyncNoCB_Click(object sender, System.EventArgs e)
    {
      Output("Haupt ThreadID :" +
        AppDomain.GetCurrentThreadId().ToString()); 
      // Delegat fr asynchron auszufhrende Methode 
      myAsyncDelegate md = new myAsyncDelegate(AsyncMeth);
      // asynchroner Aufruf ohne Rckruf
      md.BeginInvoke("Parameter fr AsyncMeth", null, null); 
    }

    // Aufruf von AsyncMeth mit Rckruf, Parameterbergabe,
    // AsyncState-Parameter fr Rckruf
    // und synchronisierter Auswertung des Funktionswerts
    private void bAsyncCB_Click(object sender, System.EventArgs e)
    {
      // Delegat fr asynchron auszufhrende Methode 
      myAsyncDelegate md = new myAsyncDelegate(AsyncMeth);
      // Delegat fr Rckruf 
      AsyncCallback asyncCB = new AsyncCallback(ResultCB); 
      Output("Haupt ThreadID :" +
        AppDomain.GetCurrentThreadId().ToString()); 
      IAsyncResult aRes = md.BeginInvoke("Parameter fr AsyncMeth",
        asyncCB, "das AsyncState-Objekt"); 
      Output("Das ist Code unmittelbar nach BeginInvoke()"); 
      string res = md.EndInvoke(aRes); 
      Output("Ergebnis der Operation: " + res); 
    }
  }
}
